/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Map;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.block.BaseFurnitureBlock;
import net.conczin.immersive_furniture.block.entity.FurnitureBlockEntity;
import net.conczin.immersive_furniture.client.model.DynamicAtlas;
import net.conczin.immersive_furniture.client.model.FurnitureModelBaker;
import net.conczin.immersive_furniture.client.model.MergedBakedModel;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FurnitureBlockEntityRenderer<T extends FurnitureBlockEntity>
implements BlockEntityRenderer<T> {
    public static final float[] BRIGHTNESS = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private static final RandomSource randomsource = RandomSource.m_216327_();

    public FurnitureBlockEntityRenderer(BlockEntityRendererProvider.Context ignoredContext) {
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ++Common.entityRendersTotal;
        FurnitureData data = ((FurnitureBlockEntity)((Object)blockEntity)).getData();
        if (data == null) {
            return;
        }
        if (DynamicAtlas.BAKED.knownFurniture.containsKey(data.getHash())) {
            return;
        }
        ++Common.entityRenders;
        poseStack.m_85836_();
        BlockState blockState = blockEntity.m_58900_();
        if (blockState.m_60734_() instanceof BaseFurnitureBlock) {
            float yaw = -((Direction)blockState.m_61143_((Property)BaseFurnitureBlock.FACING)).m_122424_().m_122435_();
            poseStack.m_252880_(0.5f, 0.5f, 0.5f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(yaw));
            poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        }
        BlockState state = blockEntity.m_58900_();
        FurnitureBlockEntityRenderer.renderFurniture(state, poseStack, buffer, packedLight, packedOverlay, data);
        poseStack.m_85849_();
    }

    public static void renderFurniture(BlockState state, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, FurnitureData data) {
        FurnitureBlockEntityRenderer.renderFurniture(state, poseStack, buffer, packedLight, packedOverlay, FurnitureModelBaker.getModel(data, DynamicAtlas.ENTITY), DynamicAtlas.ENTITY);
    }

    public static void renderFurniture(BlockState state, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, MergedBakedModel bakedModel, DynamicAtlas atlas) {
        for (int i = 0; i < 2; ++i) {
            ResourceLocation location = i == 0 ? atlas.getLocation() : InventoryMenu.f_39692_;
            for (Map.Entry<RenderType, BakedModel> entry : bakedModel.getModels().entrySet()) {
                VertexConsumer consumer = entry.getKey() == RenderType.m_110463_() || entry.getKey() == RenderType.m_110457_() ? buffer.m_6299_(RenderType.m_110452_((ResourceLocation)location)) : (entry.getKey() == RenderType.m_110466_() ? buffer.m_6299_(RenderType.m_110470_((ResourceLocation)location)) : buffer.m_6299_(RenderType.m_110446_((ResourceLocation)location)));
                FurnitureBlockEntityRenderer.renderModel(poseStack.m_85850_(), consumer, state, entry.getValue(), packedLight, packedOverlay, i == 1);
            }
        }
    }

    private static void renderModel(PoseStack.Pose pose, VertexConsumer consumer, BlockState state, BakedModel model, int packedLight, int packedOverlay, boolean blocksAtlas) {
        for (Direction direction : SignalGetter.f_276432_) {
            FurnitureBlockEntityRenderer.renderQuadList(pose, consumer, model.m_213637_(state, direction, randomsource), packedLight, packedOverlay, blocksAtlas);
        }
        FurnitureBlockEntityRenderer.renderQuadList(pose, consumer, model.m_213637_(state, null, randomsource), packedLight, packedOverlay, blocksAtlas);
    }

    private static void renderQuadList(PoseStack.Pose pose, VertexConsumer consumer, List<BakedQuad> quads, int packedLight, int packedOverlay, boolean blocksAtlas) {
        for (BakedQuad quad : quads) {
            ResourceLocation resourceLocation = quad.m_173410_().m_247685_();
            if (resourceLocation.m_135827_().equals("minecraft") != blocksAtlas) continue;
            consumer.m_85995_(pose, quad, BRIGHTNESS, 1.0f, 1.0f, 1.0f, new int[]{FurnitureBlockEntityRenderer.blend(packedLight, quad.m_111303_()[6]), FurnitureBlockEntityRenderer.blend(packedLight, quad.m_111303_()[14]), FurnitureBlockEntityRenderer.blend(packedLight, quad.m_111303_()[22]), FurnitureBlockEntityRenderer.blend(packedLight, quad.m_111303_()[30])}, packedOverlay, true);
        }
    }

    private static int blend(int worldLight, int vertexLight) {
        return Math.max(worldLight & 0xFFFF, vertexLight & 0xFFFF) | Math.max(worldLight >> 16 & 0xFFFF, vertexLight >> 16 & 0xFFFF) << 16;
    }
}

