/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.model;

import java.util.LinkedHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.client.model.DynamicAtlas;
import net.conczin.immersive_furniture.client.model.FurnitureModelFactory;
import net.conczin.immersive_furniture.client.model.MergedBakedModel;
import net.conczin.immersive_furniture.client.model.MultiRenderTypeBlockModel;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.utils.CachedSupplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public class FurnitureModelBaker {
    public static final ResourceLocation LOCATION = Common.locate("block/furniture");
    static final ModelBakerImpl modelBaker = new ModelBakerImpl();
    private static final RandomSource random = RandomSource.m_216327_();

    public static MergedBakedModel getAsyncModel(FurnitureData data, DynamicAtlas atlas) {
        String hash = data.getHash();
        if (atlas.knownFurniture.containsKey(hash)) {
            return FurnitureModelBaker.getModel(data, atlas, 0, false);
        }
        if (!atlas.asyncRequestedFurniture.contains(hash)) {
            atlas.asyncRequestedFurniture.add(hash);
            Common.EXECUTOR.execute(() -> {
                if (FurnitureModelBaker.getModel(data, atlas, 0, false) == null) {
                    atlas.asyncRequestedFurniture.remove(hash);
                }
            });
        }
        return null;
    }

    public static MergedBakedModel getModel(FurnitureData data, DynamicAtlas atlas) {
        return FurnitureModelBaker.getModel(data, atlas, 0, true);
    }

    public static MergedBakedModel getModel(FurnitureData data, DynamicAtlas atlas, int yRot, boolean force) {
        boolean exist;
        String hash = data.getHash();
        CachedBakedModelSet cachedBakedModelSet = atlas.knownFurniture.get(hash);
        boolean bl = exist = cachedBakedModelSet != null;
        if (!force && !exist && atlas.isFull()) {
            return null;
        }
        if (exist) {
            atlas.uploadIfDirty();
            return cachedBakedModelSet.get(yRot);
        }
        float previousUsage = atlas.getUsage();
        MultiRenderTypeBlockModel model = FurnitureModelFactory.getModel(data, atlas);
        atlas.uploadIfDirty();
        CachedBakedModelSet modelSet = new CachedBakedModelSet(atlas, model);
        atlas.knownFurniture.put(hash, modelSet);
        if (force || !atlas.isFull() && atlas.getUsage() >= previousUsage) {
            return modelSet.get(yRot);
        }
        atlas.knownFurniture.remove(hash);
        return null;
    }

    private static MergedBakedModel bakeModel(DynamicAtlas atlas, MultiRenderTypeBlockModel model, int yRot) {
        LinkedHashMap<RenderType, BakedModel> bakedModels = new LinkedHashMap<RenderType, BakedModel>();
        for (RenderType type : model.models.keySet()) {
            bakedModels.put(type, FurnitureModelBaker.bakeModel(atlas, model, type, yRot));
        }
        return new MergedBakedModel(bakedModels);
    }

    private static BakedModel bakeModel(DynamicAtlas atlas, MultiRenderTypeBlockModel model, RenderType type, int yRot) {
        BakedModel bake = model.models.get(type).m_7611_((ModelBaker)modelBaker, material -> atlas == DynamicAtlas.BAKED || !material.m_119203_().m_135827_().equals("immersive_furniture") ? material.m_119204_() : atlas.sprite, (ModelState)BlockModelRotation.m_119153_((int)0, (int)yRot), LOCATION);
        for (BakedQuad quad : bake.m_213637_(null, null, random)) {
            int[] vertices = quad.m_111303_();
            for (int i = 0; i < vertices.length; i += 8) {
                FurnitureData.Element element = model.getElement(quad.m_111305_());
                vertices[i + 3] = element.color;
                vertices[i + 6] = element.emission << 20 | element.emission << 4;
            }
        }
        return bake;
    }

    public static class CachedBakedModelSet {
        public final Supplier<MergedBakedModel> R0 = new CachedSupplier<MergedBakedModel>(() -> FurnitureModelBaker.bakeModel(atlas, model, 0));
        public final Supplier<MergedBakedModel> R90 = new CachedSupplier<MergedBakedModel>(() -> FurnitureModelBaker.bakeModel(atlas, model, 90));
        public final Supplier<MergedBakedModel> R180 = new CachedSupplier<MergedBakedModel>(() -> FurnitureModelBaker.bakeModel(atlas, model, 180));
        public final Supplier<MergedBakedModel> R270 = new CachedSupplier<MergedBakedModel>(() -> FurnitureModelBaker.bakeModel(atlas, model, 270));

        public CachedBakedModelSet(DynamicAtlas atlas, MultiRenderTypeBlockModel model) {
        }

        public MergedBakedModel get(int yRot) {
            return switch (yRot) {
                case 0 -> this.R0.get();
                case 90 -> this.R90.get();
                case 180 -> this.R180.get();
                case 270 -> this.R270.get();
                default -> throw new IllegalArgumentException("Invalid rotation: " + yRot);
            };
        }
    }

    static class ModelBakerImpl
    implements ModelBaker {
        ModelBakerImpl() {
        }

        public UnbakedModel m_245361_(ResourceLocation location) {
            return null;
        }

        public BakedModel m_245240_(ResourceLocation location, ModelState transform) {
            return null;
        }

        public BakedModel bake(ResourceLocation var1, ModelState var2, Function<Material, TextureAtlasSprite> var3) {
            return null;
        }

        public Function<Material, TextureAtlasSprite> getModelTextureGetter() {
            return null;
        }
    }
}

