/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui.components;

import java.util.LinkedList;
import java.util.List;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationEditorScreen;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationScreen;
import net.conczin.immersive_furniture.client.gui.components.ListComponent;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class SoundsComponent
extends ListComponent {
    static final int PAGE_SIZE = 7;
    List<ResourceLocation> allLocations = new LinkedList<ResourceLocation>();
    List<ResourceLocation> locations = new LinkedList<ResourceLocation>();
    List<Button> buttons = new LinkedList<Button>();

    public SoundsComponent(ArtisansWorkstationEditorScreen screen) {
        super(screen);
    }

    @Override
    public void init(int leftPos, int topPos, int width, int height) {
        if (this.screen.selectedElements.isEmpty()) {
            return;
        }
        this.buttons.clear();
        int y = topPos + 23;
        int i = 0;
        while (i < 7) {
            int finalI = i++;
            Button button = Button.m_253074_((Component)Component.m_237113_((String)""), b -> {
                if (finalI >= this.locations.size()) {
                    return;
                }
                this.screen.selectedElements.forEach(e -> {
                    e.soundEmitter.sound = this.locations.get(finalI);
                });
            }).m_252987_(leftPos + 5, y, width - 29, 18).m_253136_();
            this.screen.m_142416_(button);
            this.buttons.add(button);
            this.screen.m_142416_(new ImageButton(leftPos + width - 23, y, 18, 18, 238, 0, 18, ArtisansWorkstationScreen.TEXTURE, 256, 256, b -> {
                if (finalI >= this.locations.size()) {
                    return;
                }
                SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(this.locations.get(finalI));
                if (soundEvent == null) {
                    return;
                }
                this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)soundEvent, (float)1.0f, (float)1.0f));
            }, (Component)Component.m_237115_((String)"gui.immersive_furniture.play_sound")));
            y += 19;
        }
        super.init(leftPos, topPos, width, height);
    }

    @Override
    int getPages() {
        return Math.max(0, (this.allLocations.size() - 1) / 7 + 1);
    }

    @Override
    void updateSearch() {
        this.allLocations = BuiltInRegistries.f_256894_.m_6566_().stream().filter(p -> Utils.search(this.searchBox.m_94155_(), p.toString())).sorted(ResourceLocation::compareTo).toList();
        this.page = Math.min(this.page, this.getPages() - 1);
        this.locations = this.allLocations.subList(this.page * 7, Math.min(this.page * 7 + 7, this.allLocations.size()));
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (i < this.locations.size()) {
                ResourceLocation location = this.locations.get(i);
                MutableComponent message = Component.m_264568_((String)("subtitles." + location.m_135815_()), (String)Utils.capitalize(location));
                this.buttons.get(i).m_93666_((Component)message);
                MutableComponent namespaceTooltip = Component.m_237113_((String)Utils.capitalize(location.m_135827_())).m_130940_(ChatFormatting.GRAY);
                this.buttons.get(i).m_257544_(Tooltip.m_257550_((Component)message.m_6881_().m_130946_("\n").m_7220_((Component)namespaceTooltip)));
                this.buttons.get((int)i).f_93623_ = true;
                continue;
            }
            this.buttons.get(i).m_93666_((Component)Component.m_237113_((String)""));
            this.buttons.get(i).m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"")));
            this.buttons.get((int)i).f_93623_ = false;
        }
    }
}

