/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.client.PreviewParticleEngine;
import net.conczin.immersive_furniture.client.model.DynamicAtlas;
import net.conczin.immersive_furniture.client.model.FurnitureModelBaker;
import net.conczin.immersive_furniture.client.model.MaterialRegistry;
import net.conczin.immersive_furniture.client.model.MergedBakedModel;
import net.conczin.immersive_furniture.client.model.TransparencyManager;
import net.conczin.immersive_furniture.client.renderer.FurnitureBlockEntityRenderer;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public abstract class ArtisansWorkstationScreen
extends Screen {
    public static final Component TITLE = Component.m_237115_((String)"item.immersive_furniture.artisans_workstation");
    public static final ResourceLocation TEXTURE = Common.locate("textures/gui/gui.png");
    public static final int TEXTURE_SIZE = 256;
    protected Component error;
    protected long lastErrorTime = 0L;
    protected long lastCriticalActionAttempt = 0L;
    int windowWidth = 280;
    int windowHeight = 180;
    int leftPos;
    int topPos;
    boolean nightMode = false;
    private static MergedBakedModel lastBakedModel = null;
    private static final Map<Object, PreviewParticleEngine> objectToParticleEngine = Collections.synchronizedMap(new LinkedHashMap<Object, PreviewParticleEngine>(30, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, PreviewParticleEngine> eldest) {
            return this.size() > 30;
        }
    });

    public ArtisansWorkstationScreen() {
        super(TITLE);
        if (MaterialRegistry.INSTANCE.materials.isEmpty()) {
            new Thread(MaterialRegistry.INSTANCE::sync).start();
        }
    }

    protected void drawRectangle(GuiGraphics graphics, int x, int y, int w, int h) {
        this.drawRectangle(graphics, x, y, w, h, 0, 0);
    }

    protected void drawRectangle(GuiGraphics graphics, int x, int y, int w, int h, int originY, int originX) {
        graphics.m_280163_(TEXTURE, x, y, (float)originX, (float)originY, 16, 16, 256, 256);
        graphics.m_280163_(TEXTURE, x + w - 16, y, (float)(originX + 32), (float)originY, 16, 16, 256, 256);
        graphics.m_280163_(TEXTURE, x + w - 16, y + h - 16, (float)(originX + 32), (float)(originY + 32), 16, 16, 256, 256);
        graphics.m_280163_(TEXTURE, x, y + h - 16, (float)originX, (float)(originY + 32), 16, 16, 256, 256);
        graphics.m_280411_(TEXTURE, x + 16, y, w - 32, 16, (float)(originX + 16), (float)originY, 16, 16, 256, 256);
        graphics.m_280411_(TEXTURE, x + 16, y + h - 16, w - 32, 16, (float)(originX + 16), (float)(originY + 32), 16, 16, 256, 256);
        graphics.m_280411_(TEXTURE, x, y + 16, 16, h - 32, (float)originX, (float)(originY + 16), 16, 16, 256, 256);
        graphics.m_280411_(TEXTURE, x + w - 16, y + 16, 16, h - 32, (float)(originX + 32), (float)(originY + 16), 16, 16, 256, 256);
        graphics.m_280411_(TEXTURE, x + 16, y + 16, w - 32, h - 32, (float)(originX + 16), (float)(originY + 16), 16, 16, 256, 256);
    }

    void renderModel(GuiGraphics graphics, FurnitureData data, double x, double y, double size, float yaw, float pitch) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_(x, y, 100.0);
        graphics.m_280168_().m_252931_(new Matrix4f().scaling((float)(size / Math.max(1.0, data.getSize() / 16.0) * 0.4)));
        graphics.m_280168_().m_252781_(new Quaternionf().rotateX(pitch).rotateY(yaw));
        graphics.m_280168_().m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        Vec3 center = data.boundingBox().m_82399_();
        graphics.m_280168_().m_85837_(-center.f_82479_ / 16.0, -center.f_82480_ / 16.0, -center.f_82481_ / 16.0);
        this.renderModel(graphics, data, yaw, pitch, false);
        graphics.m_280168_().m_85849_();
    }

    void renderModel(GuiGraphics graphics, FurnitureData data, float yaw, float pitch, boolean inEditor) {
        TransparencyManager.heySodiumImInUse(data);
        if (inEditor) {
            TransparencyManager.prepare(data);
        }
        MergedBakedModel bakedModel = FurnitureModelBaker.getAsyncModel(data, DynamicAtlas.SCRATCH);
        if (inEditor) {
            if (bakedModel == null) {
                bakedModel = lastBakedModel;
            } else {
                lastBakedModel = bakedModel;
            }
        }
        if (bakedModel != null) {
            int light = this.nightMode ? data.lightLevel : 15;
            FurnitureBlockEntityRenderer.renderFurniture(null, graphics.m_280168_(), (MultiBufferSource)graphics.m_280091_(), light << 20 | light << 4 | light, OverlayTexture.f_118083_, bakedModel, DynamicAtlas.SCRATCH);
        }
        long time = System.currentTimeMillis() / 50L;
        float partialTicks = (float)(System.currentTimeMillis() % 50L) / 50.0f;
        if (time != data.lastTick) {
            data.lastTick = time;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (level == null || player == null) {
                return;
            }
            if (level.m_213780_().m_188501_() < 0.2f) {
                data.tick((Level)level, player.m_20097_(), null, level.m_213780_(), ArtisansWorkstationScreen.getParticleEngine(data)::addParticle, true, inEditor);
            }
            ArtisansWorkstationScreen.getParticleEngine(data).tick();
        }
        ArtisansWorkstationScreen.getParticleEngine(data).renderParticles(graphics, yaw, pitch, partialTicks);
        graphics.m_280262_();
    }

    void line(GuiGraphics graphics, float x0, float y0, float z0, float x1, float y1, float z1, float width, boolean overlay, float r, float g, float b, float a) {
        float length = (float)Math.sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0));
        float nx = (y1 - y0) / length * width * 0.5f;
        float ny = (x0 - x1) / length * width * 0.5f;
        Matrix4f matrix4f = graphics.m_280168_().m_85850_().m_252922_();
        VertexConsumer vertexConsumer = graphics.m_280091_().m_6299_(overlay ? RenderType.m_286086_() : RenderType.m_285907_());
        float z = 2.0f;
        vertexConsumer.m_252986_(matrix4f, x1 - nx + 0.5f, y1 - ny + 0.5f, z1 + z).m_85950_(r, g, b, a).m_5752_();
        vertexConsumer.m_252986_(matrix4f, x1 + nx + 0.5f, y1 + ny + 0.5f, z1 + z).m_85950_(r, g, b, a).m_5752_();
        vertexConsumer.m_252986_(matrix4f, x0 + nx + 0.5f, y0 + ny + 0.5f, z0 + z).m_85950_(r, g, b, a).m_5752_();
        vertexConsumer.m_252986_(matrix4f, x0 - nx + 0.5f, y0 - ny + 0.5f, z0 + z).m_85950_(r, g, b, a).m_5752_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
    }

    protected void m_7856_() {
        this.m_169413_();
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.windowWidth) / 2;
        this.topPos = (this.f_96544_ - this.windowHeight) / 2;
    }

    public <T extends GuiEventListener & Renderable> T m_142416_(T widget) {
        return (T)super.m_142416_(widget);
    }

    public static PreviewParticleEngine getParticleEngine(FurnitureData data) {
        return objectToParticleEngine.computeIfAbsent(data, d -> new PreviewParticleEngine());
    }

    public void clearError() {
        this.error = null;
    }

    public void setError(String text) {
        this.error = Component.m_237115_((String)text);
        this.lastErrorTime = System.currentTimeMillis();
    }

    protected void renderError(GuiGraphics graphics, int y) {
        if (this.error == null) {
            return;
        }
        graphics.m_280509_(this.f_96543_ / 2 - 80, y - 3, this.f_96543_ / 2 + 80, y + 10, Integer.MIN_VALUE);
        graphics.m_280653_(this.f_96547_, this.error, this.f_96543_ / 2, y, -65536);
        if (System.currentTimeMillis() - this.lastErrorTime > 5000L) {
            this.clearError();
        }
    }
}

