/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.client.Utils;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationLibraryScreen;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationScreen;
import net.conczin.immersive_furniture.client.gui.components.EffectsComponent;
import net.conczin.immersive_furniture.client.gui.components.MaterialsComponent;
import net.conczin.immersive_furniture.client.gui.components.ModelComponent;
import net.conczin.immersive_furniture.client.gui.components.ParticlesComponent;
import net.conczin.immersive_furniture.client.gui.components.SettingsComponent;
import net.conczin.immersive_furniture.client.gui.components.SoundsComponent;
import net.conczin.immersive_furniture.client.gui.components.SpritesComponent;
import net.conczin.immersive_furniture.client.gui.widgets.StateImageButton;
import net.conczin.immersive_furniture.client.model.ClientModelUtils;
import net.conczin.immersive_furniture.config.Config;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.FurnitureDataManager;
import net.conczin.immersive_furniture.data.ModelUtils;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ArtisansWorkstationEditorScreen
extends ArtisansWorkstationScreen {
    public static final ResourceLocation TEXTURE_CHECKERPLANE = Common.locate("textures/gui/checkerplane.png");
    public static final int TOOLS_WIDTH = 100;
    float camYaw = -2.3561945f;
    float camPitch = -0.7853982f;
    float camZoom = 100.0f;
    public FurnitureData data;
    public List<FurnitureData.Element> selectedElements = new LinkedList<FurnitureData.Element>();
    public HoverResult hoverResult;
    static final int MAX_HISTORY_SIZE = 20;
    private String lastHistoryHash = "";
    private final Deque<CompoundTag> history = new ArrayDeque<CompoundTag>(20);
    private List<CompoundTag> copiedElements = new LinkedList<CompoundTag>();
    private long lastAutosaveTime = 0L;
    DraggingContext draggingContext;
    boolean isRotatingView;
    int lastMouseX;
    int lastMouseY;
    int elementShift = 0;
    final MaterialsComponent materialsComponent = new MaterialsComponent(this);
    final ParticlesComponent particlesComponent = new ParticlesComponent(this);
    final SoundsComponent poundsComponent = new SoundsComponent(this);
    final ModelComponent modelComponent = new ModelComponent(this);
    final EffectsComponent effectsComponent = new EffectsComponent(this);
    final SettingsComponent settingsComponent = new SettingsComponent(this);
    final SpritesComponent spritesComponent = new SpritesComponent(this);
    Page currentPage = Page.MODEL;
    boolean backwardsCheckerPlane = true;

    public ArtisansWorkstationEditorScreen(FurnitureData data) {
        this.data = data;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.f_96541_ = Minecraft.m_91087_();
        switch (this.currentPage) {
            case MODEL: {
                this.modelComponent.init(this.leftPos, this.topPos, 100, this.windowHeight);
                break;
            }
            case MATERIALS: {
                this.materialsComponent.init(this.leftPos, this.topPos, 100, this.windowHeight);
                break;
            }
            case PARTICLES: {
                this.particlesComponent.init(this.leftPos, this.topPos, 100, this.windowHeight);
                break;
            }
            case SOUNDS: {
                this.poundsComponent.init(this.leftPos, this.topPos, 100, this.windowHeight);
                break;
            }
            case EFFECTS: {
                this.effectsComponent.init(this.leftPos, this.topPos, 100, this.windowHeight);
                break;
            }
            case SETTINGS: {
                this.settingsComponent.init(this.leftPos, this.topPos, 100, this.windowHeight);
                break;
            }
            case SPRITES: {
                this.spritesComponent.init(this.leftPos, this.topPos, 100, this.windowHeight);
            }
        }
        MutableComponent text = Component.m_237115_((String)"gui.immersive_furniture.tab.cancel");
        StateImageButton button = new StateImageButton(this.leftPos + 4, this.topPos - 24, 26, 28, 130, 56, TEXTURE, 256, 256, b -> this.cancel(), (Component)text);
        button.m_257544_(Tooltip.m_257550_((Component)text));
        button.setEnabled(false);
        this.m_142416_(button);
        int x = 16;
        this.m_142416_(this.pagePageButton(Page.MODEL, x, 0));
        x += 26;
        if (this.isFirstElement(FurnitureData.ElementType.PARTICLE_EMITTER)) {
            this.m_142416_(this.pagePageButton(Page.PARTICLES, x, 156));
            x += 26;
        } else if (this.isFirstElement(FurnitureData.ElementType.SOUND_EMITTER)) {
            this.m_142416_(this.pagePageButton(Page.SOUNDS, x, 182));
            x += 26;
        } else if (this.isFirstElement(FurnitureData.ElementType.ELEMENT)) {
            this.m_142416_(this.pagePageButton(Page.MATERIALS, x, 26));
            this.m_142416_(this.pagePageButton(Page.EFFECTS, x += 26, 52));
            x += 26;
        } else if (this.isFirstElement(FurnitureData.ElementType.SPRITE)) {
            this.m_142416_(this.pagePageButton(Page.SPRITES, x, 104));
            this.m_142416_(this.pagePageButton(Page.EFFECTS, x += 26, 52));
            x += 26;
        }
        this.m_142416_(this.pagePageButton(Page.SETTINGS, x, 78));
        MutableComponent helpText = Component.m_237115_((String)"gui.immersive_furniture.tab.help");
        StateImageButton helpButton = new StateImageButton(this.leftPos + 240, this.topPos - 24, 26, 28, 208, 56, TEXTURE, 256, 256, b -> this.openHelp(), (Component)helpText);
        helpButton.setEnabled(false);
        helpButton.m_257544_(Tooltip.m_257550_((Component)helpText));
        this.m_142416_(helpButton);
        MutableComponent nightModeText = Component.m_237115_((String)(this.nightMode ? "gui.immersive_furniture.nightmode" : "gui.immersive_furniture.daymode"));
        StateImageButton nightModeButton = new StateImageButton(this.leftPos + this.windowWidth + 1, this.topPos + this.windowHeight - 19, 16, 16, 208, 160, TEXTURE, 256, 256, b -> {
            this.nightMode = !this.nightMode;
            this.m_7856_();
        }, (Component)nightModeText);
        nightModeButton.m_257544_(Tooltip.m_257550_((Component)nightModeText));
        nightModeButton.setEnabled(this.nightMode);
        this.m_142416_(nightModeButton);
        MutableComponent backwardsCheckerPlaneText = Component.m_237115_((String)"gui.immersive_furniture.backwards_checkerplane");
        StateImageButton backwardsCheckerButton = new StateImageButton(this.leftPos + this.windowWidth + 1, this.topPos + this.windowHeight - 36, 16, 16, 224, 160, TEXTURE, 256, 256, b -> {
            this.backwardsCheckerPlane = !this.backwardsCheckerPlane;
            this.m_7856_();
        }, (Component)backwardsCheckerPlaneText);
        backwardsCheckerButton.m_257544_(Tooltip.m_257550_((Component)backwardsCheckerPlaneText));
        backwardsCheckerButton.setEnabled(this.backwardsCheckerPlane);
        this.m_142416_(backwardsCheckerButton);
        this.addHistory();
    }

    private void cancel() {
        if (this.lastCriticalActionAttempt + 5000L > System.currentTimeMillis()) {
            Minecraft.m_91087_().m_91152_((Screen)new ArtisansWorkstationLibraryScreen());
        } else {
            this.lastCriticalActionAttempt = System.currentTimeMillis();
            this.setError("gui.immersive_furniture.cancel_confirm");
        }
    }

    private StateImageButton pagePageButton(Page page, int x, int u) {
        MutableComponent text = Component.m_237115_((String)("gui.immersive_furniture.tab." + page.name().toLowerCase(Locale.ROOT)));
        StateImageButton button = new StateImageButton(100 + (this.windowWidth - 100 - 26 * Page.values().length) / 2 + this.leftPos + x, this.topPos - 24, 26, 28, u, 56, TEXTURE, 256, 256, b -> {
            this.currentPage = page;
            this.m_7856_();
        }, (Component)text);
        button.m_257544_(Tooltip.m_257550_((Component)text));
        button.setEnabled(this.currentPage == page);
        return button;
    }

    private void openHelp() {
        try {
            Util.m_137581_().m_137646_("https://github.com/Luke100000/immersiveFurniture/wiki/Help");
        }
        catch (Exception e) {
            Common.logger.error((Object)e);
        }
    }

    public void m_280273_(GuiGraphics graphics) {
        super.m_280273_(graphics);
        this.drawRectangle(graphics, this.leftPos, this.topPos, 100, this.windowHeight);
        this.drawRectangle(graphics, this.leftPos + 100, this.topPos, this.windowWidth - 100, this.windowHeight);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.data.dirty();
        graphics.m_280588_(this.leftPos + 100 + 3, this.topPos + 3, this.leftPos + this.windowWidth - 3, this.topPos + this.windowHeight - 3);
        this.drawModel(graphics, this.data, this.leftPos + 100 + (this.windowWidth - 100) / 2, this.topPos + this.windowHeight / 2, this.camZoom, this.camYaw, this.camPitch, mouseX, mouseY);
        graphics.m_280618_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 2048.0f);
        switch (this.currentPage) {
            case MODEL: {
                this.modelComponent.render(graphics);
                break;
            }
            case MATERIALS: {
                this.materialsComponent.render(graphics);
                break;
            }
            case PARTICLES: {
                this.particlesComponent.render(graphics);
                break;
            }
            case SOUNDS: {
                this.poundsComponent.render(graphics);
                break;
            }
            case SETTINGS: {
                this.settingsComponent.render(graphics);
                break;
            }
            case SPRITES: {
                this.spritesComponent.render(graphics);
            }
        }
        this.renderError(graphics, this.f_96544_ / 2);
    }

    public Vector3f quantVector(Vector3f normal, float offset, boolean quantize) {
        normal.mul(offset);
        float stepSize = quantize ? 4.0f : 1.0f;
        normal.x = (float)Math.floor(normal.x * stepSize + 0.5f) / stepSize;
        normal.y = (float)Math.floor(normal.y * stepSize + 0.5f) / stepSize;
        normal.z = (float)Math.floor(normal.z * stepSize + 0.5f) / stepSize;
        return normal;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isRotatingView) {
            this.camYaw += (float)(dragX * (double)0.015f);
            this.camPitch -= (float)(dragY * (double)0.015f);
        }
        if (this.draggingContext != null) {
            Vector3f normal2;
            Vector3f normal;
            float offset = this.draggingContext.getOffset(mouseX, mouseY);
            Vector3f local = this.quantVector(this.draggingContext.direction.m_253071_(), offset, false);
            Vector3f global = this.quantVector(this.draggingContext.getNormal(), offset, ArtisansWorkstationEditorScreen.m_96637_() && !this.draggingContext.resize);
            if (this.draggingContext.resize) {
                if (ArtisansWorkstationEditorScreen.m_96638_()) {
                    normal = new Vector3f((Vector3fc)local);
                    normal2 = local.negate();
                } else {
                    Vector3f o = new Vector3f((Vector3fc)local).sub((Vector3fc)global).mul(0.5f);
                    normal = new Vector3f((Vector3fc)local).sub((Vector3fc)o);
                    normal2 = new Vector3f(0.0f).sub((Vector3fc)o);
                }
            } else {
                normal = global;
                normal2 = global;
            }
            for (FurnitureData.Element element : this.selectedElements) {
                if (!this.draggingContext.originalFrom.containsKey(element)) continue;
                Vector3f originalFrom = this.draggingContext.originalFrom.get(element);
                Vector3f originalTo = this.draggingContext.originalTo.get(element);
                Vector3f fNormal = new Vector3f((Vector3fc)normal);
                ModelUtils.rotate(fNormal, this.draggingContext.element.axis, -this.draggingContext.element.rotation);
                ModelUtils.rotate(fNormal, element.axis, element.rotation);
                Vector3f fNormal2 = new Vector3f((Vector3fc)normal2);
                ModelUtils.rotate(fNormal2, this.draggingContext.element.axis, -this.draggingContext.element.rotation);
                ModelUtils.rotate(fNormal2, element.axis, element.rotation);
                if (this.draggingContext.direction == Direction.DOWN || this.draggingContext.direction == Direction.WEST || this.draggingContext.direction == Direction.NORTH) {
                    element.from.x = Math.min(element.to.x, originalFrom.x + fNormal.x);
                    element.from.y = Math.min(element.to.y, originalFrom.y + fNormal.y);
                    element.from.z = Math.min(element.to.z, originalFrom.z + fNormal.z);
                    element.to.x = Math.max(element.from.x, originalTo.x + fNormal2.x);
                    element.to.y = Math.max(element.from.y, originalTo.y + fNormal2.y);
                    element.to.z = Math.max(element.from.z, originalTo.z + fNormal2.z);
                } else {
                    element.to.x = Math.max(element.from.x, originalTo.x + fNormal.x);
                    element.to.y = Math.max(element.from.y, originalTo.y + fNormal.y);
                    element.to.z = Math.max(element.from.z, originalTo.z + fNormal.z);
                    element.from.x = Math.min(element.to.x, originalFrom.x + fNormal2.x);
                    element.from.y = Math.min(element.to.y, originalFrom.y + fNormal2.y);
                    element.from.z = Math.min(element.to.z, originalFrom.z + fNormal2.z);
                }
                element.sanityCheck();
            }
            if (this.currentPage == Page.MODEL) {
                this.modelComponent.update();
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if ((button == 0 || button == 1) && this.hoverResult != null) {
            boolean doubleClick;
            boolean bl = doubleClick = this.lastMouseX == (int)mouseX && this.lastMouseY == (int)mouseY;
            if (button == 0 && ArtisansWorkstationEditorScreen.m_96638_() && this.selectedElements.contains(this.hoverResult.element)) {
                this.selectedElements.remove(this.hoverResult.element);
            } else {
                this.selectElement(this.hoverResult.element(), ArtisansWorkstationEditorScreen.m_96638_() || this.selectedElements.size() > 1 && !doubleClick);
            }
            if (this.currentPage == Page.MATERIALS || this.currentPage == Page.SOUNDS || this.currentPage == Page.PARTICLES || this.currentPage == Page.SPRITES) {
                if (this.isFirstElement(FurnitureData.ElementType.ELEMENT)) {
                    this.currentPage = Page.MATERIALS;
                } else if (this.isFirstElement(FurnitureData.ElementType.SOUND_EMITTER)) {
                    this.currentPage = Page.SOUNDS;
                } else if (this.isFirstElement(FurnitureData.ElementType.PARTICLE_EMITTER)) {
                    this.currentPage = Page.PARTICLES;
                } else if (this.isFirstElement(FurnitureData.ElementType.SPRITE)) {
                    this.currentPage = Page.SPRITES;
                }
            }
            this.draggingContext = new DraggingContext(this.hoverResult.element(), this.hoverResult.direction(), mouseX, mouseY, button == 1);
            this.isRotatingView = false;
            this.m_7856_();
        } else {
            this.isRotatingView = this.isOverRightWindow(mouseX, mouseY);
        }
        this.lastMouseX = (int)mouseX;
        this.lastMouseY = (int)mouseY;
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.draggingContext != null) {
            this.draggingContext = null;
        }
        if (!this.selectedElements.isEmpty() && this.hoverResult == null && this.lastMouseX == (int)mouseX && this.lastMouseY == (int)mouseY && this.isOverRightWindow(mouseX, mouseY)) {
            this.selectedElements.clear();
            this.m_7856_();
        }
        this.addHistory();
        return super.m_6348_(mouseX, mouseY, button);
    }

    private boolean isOverRightWindow(double mouseX, double mouseY) {
        return mouseX > (double)(this.leftPos + 100) && mouseX < (double)(this.leftPos + this.windowWidth) && mouseY > (double)this.topPos && mouseY < (double)(this.topPos + this.windowHeight);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (ArtisansWorkstationEditorScreen.m_96632_((int)keyCode)) {
            this.copiedElements = this.selectedElements.stream().map(FurnitureData.Element::toTag).toList();
        } else if (ArtisansWorkstationEditorScreen.m_96628_((int)keyCode)) {
            if (!this.selectedElements.isEmpty()) {
                this.copiedElements = this.selectedElements.stream().map(FurnitureData.Element::toTag).toList();
                this.data.elements.removeAll(this.selectedElements);
                this.selectedElements.clear();
                this.m_7856_();
            }
        } else if (ArtisansWorkstationEditorScreen.m_96630_((int)keyCode)) {
            if (!this.copiedElements.isEmpty()) {
                this.selectedElements.clear();
                for (CompoundTag copiedElement : this.copiedElements) {
                    FurnitureData.Element element = new FurnitureData.Element(copiedElement);
                    this.data.elements.add(element);
                    this.selectedElements.add(element);
                }
                this.m_7856_();
            }
        } else if (keyCode == 261) {
            if (!this.selectedElements.isEmpty() && this.isOverRightWindow(this.lastMouseX, this.lastMouseY)) {
                this.data.elements.removeAll(this.selectedElements);
                this.selectedElements.clear();
                this.m_7856_();
            }
        } else if (keyCode == 68 && ArtisansWorkstationEditorScreen.m_96637_() && !ArtisansWorkstationEditorScreen.m_96638_() && !ArtisansWorkstationEditorScreen.m_96639_()) {
            this.modelComponent.duplicateElements();
        } else if (keyCode == 65 && ArtisansWorkstationEditorScreen.m_96637_() && !ArtisansWorkstationEditorScreen.m_96638_() && !ArtisansWorkstationEditorScreen.m_96639_()) {
            this.selectedElements.clear();
            this.selectedElements.addAll(this.data.elements);
            this.m_7856_();
        } else if (keyCode == 77 && ArtisansWorkstationEditorScreen.m_96637_() && !ArtisansWorkstationEditorScreen.m_96638_() && !ArtisansWorkstationEditorScreen.m_96639_()) {
            if (!this.selectedElements.isEmpty() && !this.copiedElements.isEmpty()) {
                FurnitureData.Element element = new FurnitureData.Element(this.copiedElements.get(0));
                for (FurnitureData.Element selectedElement : this.selectedElements) {
                    selectedElement.material = new FurnitureData.Material(element.material);
                    selectedElement.color = element.color;
                    selectedElement.emission = element.emission;
                }
                this.m_7856_();
            }
        } else if (ArtisansWorkstationEditorScreen.isUndo(keyCode)) {
            CompoundTag oldData;
            if (!this.history.isEmpty() && this.lastHistoryHash.equals(this.data.getHash())) {
                this.history.removeFirst();
            }
            if (!this.history.isEmpty() && (oldData = this.history.removeFirst()) != null) {
                this.data = new FurnitureData(oldData);
                this.selectedElements.clear();
                this.m_7856_();
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public static boolean isUndo(int keyCode) {
        return (keyCode == 89 || keyCode == 90) && ArtisansWorkstationEditorScreen.m_96637_() && !ArtisansWorkstationEditorScreen.m_96638_() && !ArtisansWorkstationEditorScreen.m_96639_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (ArtisansWorkstationEditorScreen.m_96638_()) {
            this.elementShift += mouseY > 0.0 ? 1 : -1;
        } else {
            this.camZoom = Math.max(20.0f, Math.min(120.0f, this.camZoom + (float)delta * 0.1f * this.camZoom));
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public void m_94757_(double mouseX, double mouseY) {
        super.m_94757_(mouseX, mouseY);
        this.elementShift = 0;
    }

    protected void drawModel(GuiGraphics graphics, FurnitureData data, int x, int y, float size, float yaw, float pitch, int mouseX, int mouseY) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_((double)x, (double)y, 1024.0);
        graphics.m_280168_().m_252931_(new Matrix4f().scaling(size));
        graphics.m_280168_().m_252781_(new Quaternionf().rotateX(pitch).rotateY(yaw));
        graphics.m_280168_().m_252880_((float)(-data.size.x) / 2.0f, (float)data.size.y / 2.0f, (float)(-data.size.z) / 2.0f);
        graphics.m_280168_().m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        Lighting.m_252756_((Matrix4f)new Matrix4f().rotateX(pitch).rotateY(yaw));
        this.renderModel(graphics, data, yaw, pitch, true);
        Lighting.m_84931_();
        graphics.m_280168_().m_85836_();
        this.checkerPlane(graphics, data.size.x, data.size.z);
        graphics.m_280168_().m_252781_(new Quaternionf().rotateX(1.5707964f));
        graphics.m_280168_().m_252880_(0.0f, (float)data.size.z, 0.0f);
        graphics.m_280168_().m_85841_(1.0f, 1.0f, -1.0f);
        if (this.backwardsCheckerPlane) {
            this.checkerPlane(graphics, data.size.x, data.size.y);
        }
        graphics.m_280168_().m_85849_();
        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
        graphics.m_280168_().m_85849_();
        LinkedList<HoverResult> results = new LinkedList<HoverResult>();
        for (FurnitureData.Element element : data.elements) {
            Utils.Ray ray = Utils.inverseTransformRay(mouseX, mouseY, pose, element);
            Utils.RaycastResult raycastResult = Utils.raycast(ray, element);
            if (raycastResult == null) continue;
            results.add(new HoverResult(element, raycastResult.face(), raycastResult.distance()));
        }
        if (results.isEmpty() || !this.isOverRightWindow(mouseX, mouseY)) {
            this.hoverResult = null;
        } else {
            results.sort((a, b) -> Float.compare(b.depth, a.depth));
            int index = 0;
            if (!(this.selectedElements.isEmpty() || ArtisansWorkstationEditorScreen.m_96638_() && this.selectedElements.size() > 1)) {
                for (int i = 0; i < results.size(); ++i) {
                    if (!this.selectedElements.contains(((HoverResult)results.get(i)).element())) continue;
                    index = i;
                    break;
                }
            }
            this.hoverResult = (HoverResult)results.get((index + this.elementShift) % results.size());
            float selectionWidth = this.selectedElements.contains(this.hoverResult.element()) ? 1.25f : 1.0f;
            this.drawSelection(graphics, this.hoverResult.element(), pose, selectionWidth, false);
        }
        graphics.m_280262_();
        for (FurnitureData.Element selectedElement : this.selectedElements) {
            this.drawSelection(graphics, selectedElement, pose, 0.6f, true);
        }
        for (FurnitureData.Element element : data.elements) {
            if (element.type == FurnitureData.ElementType.ELEMENT || element.type == FurnitureData.ElementType.SPRITE) continue;
            this.drawSelection(graphics, element, pose, 0.4f, true);
        }
    }

    void checkerPlane(GuiGraphics graphics, float w, float h) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_CHECKERPLANE);
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Matrix4f matrix4f = graphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        builder.m_252986_(matrix4f, 0.0f, 0.001f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.001f, h).m_7421_(0.0f, h / 8.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_5752_();
        builder.m_252986_(matrix4f, w, 0.001f, h).m_7421_(w / 8.0f, h / 8.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_5752_();
        builder.m_252986_(matrix4f, w, 0.001f, 0.0f).m_7421_(w / 8.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
    }

    void drawSelection(GuiGraphics graphics, FurnitureData.Element element, Matrix4f pose, float width, boolean overlay) {
        float[] fs = ClientModelUtils.getShapeData(element);
        for (Direction facing : Direction.values()) {
            Vector3f[] vertices = ClientModelUtils.getVertices(element, facing, fs, pose);
            for (int i = 0; i < 4; ++i) {
                Vector3f vertex = vertices[i];
                Vector3f nextVertex = vertices[(i + 1) % 4];
                float adjustedWidth = element.type == FurnitureData.ElementType.PLAYER_POSE && facing == Direction.NORTH ? 1.5f + width * 0.5f : width;
                this.line(graphics, vertex.x(), vertex.y(), vertex.z(), nextVertex.x(), nextVertex.y(), nextVertex.z(), adjustedWidth, overlay, 0.0f, 0.0f, 0.0f, 1.0f);
            }
        }
    }

    public boolean m_6913_() {
        return false;
    }

    public void addHistory() {
        String hash = this.data.getHash();
        if (!this.lastHistoryHash.equals(hash)) {
            long currentTime;
            this.lastHistoryHash = hash;
            if (this.history.size() >= 20) {
                this.history.removeLast();
            }
            this.history.addFirst(this.data.toTag());
            int autosaveInterval = Config.getInstance().autosaveInterval;
            if (autosaveInterval >= 0 && (currentTime = System.currentTimeMillis()) - this.lastAutosaveTime > (long)autosaveInterval * 1000L) {
                FurnitureDataManager.save(this.data, new ResourceLocation("local", "autosave"));
                this.lastAutosaveTime = currentTime;
            }
        }
    }

    public Optional<FurnitureData.Element> getFirstElement() {
        return this.selectedElements.isEmpty() ? Optional.empty() : Optional.of(this.selectedElements.get(0));
    }

    public boolean isFirstElement(FurnitureData.ElementType type) {
        return this.getFirstElement().filter(e -> e.type == type).isPresent();
    }

    public void selectElement(FurnitureData.Element element, boolean add) {
        if (!add) {
            this.selectedElements.clear();
        }
        if (!this.selectedElements.contains(element)) {
            this.selectedElements.add(element);
        }
    }

    public static enum Page {
        MODEL,
        MATERIALS,
        PARTICLES,
        SOUNDS,
        EFFECTS,
        SETTINGS,
        SPRITES;

    }

    final class DraggingContext {
        private final FurnitureData.Element element;
        private Direction direction;
        private boolean autoDirectionLock;
        private final double x;
        private final double y;
        private final boolean resize;
        private final Map<FurnitureData.Element, Vector3f> originalFrom = new HashMap<FurnitureData.Element, Vector3f>();
        private final Map<FurnitureData.Element, Vector3f> originalTo = new HashMap<FurnitureData.Element, Vector3f>();
        private final boolean isFlat;

        DraggingContext(FurnitureData.Element element, Direction direction, double x, double y, boolean resize) {
            this.element = element;
            this.direction = direction;
            this.x = x;
            this.y = y;
            this.resize = resize;
            for (FurnitureData.Element e : ArtisansWorkstationEditorScreen.this.selectedElements) {
                this.originalFrom.put(e, new Vector3f((Vector3fc)e.from));
                this.originalTo.put(e, new Vector3f((Vector3fc)e.to));
            }
            this.isFlat = element.isFlat();
        }

        public float getOffset(double mouseX, double mouseY) {
            Vector3f normal = this.getNormal();
            Quaternionf q = new Quaternionf().rotateX(ArtisansWorkstationEditorScreen.this.camPitch).rotateY(ArtisansWorkstationEditorScreen.this.camYaw);
            q.transform(normal.mul(1.0f, -1.0f, 1.0f)).normalize();
            Vector3f screenNormal = new Vector3f(normal.x, normal.y, 0.0f).normalize();
            Vector3f drag = new Vector3f((float)(mouseX - this.x), (float)(mouseY - this.y), 0.0f);
            float proj = drag.dot((Vector3fc)screenNormal);
            if ((this.isFlat || Screen.m_96639_()) && drag.lengthSquared() > 2.0f) {
                Direction bestDirection = this.direction;
                float bestDot = 0.0f;
                for (Direction value : Direction.values()) {
                    if (this.autoDirectionLock && value != this.direction && value != this.direction.m_122424_()) continue;
                    Vector3f directionNormal = this.element.getGlobalDirectionNormal(value);
                    q.transform(directionNormal.mul(1.0f, -1.0f, 1.0f)).normalize();
                    Vector3f directionScreenNormal = directionNormal.normalize();
                    float dot = directionScreenNormal.dot((Vector3fc)drag);
                    if (!(dot > bestDot)) continue;
                    bestDirection = value;
                    bestDot = dot;
                }
                this.direction = bestDirection;
                this.autoDirectionLock = true;
            }
            float viewDot = (float)Math.sqrt(1.0f - normal.z * normal.z);
            return proj / ArtisansWorkstationEditorScreen.this.camZoom * 16.0f / viewDot;
        }

        private Vector3f getNormal() {
            return this.element.getGlobalDirectionNormal(this.direction);
        }
    }

    public record HoverResult(FurnitureData.Element element, Direction direction, float depth) {
    }
}

