/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.block.entity;

import net.conczin.immersive_furniture.block.entity.BlockEntityTypes;
import net.conczin.immersive_furniture.config.Config;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.FurnitureDataManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FurnitureBlockEntity
extends BlockEntity
implements Container,
MenuProvider {
    private String hash;
    private FurnitureData data;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)81, (Object)ItemStack.f_41583_);

    public FurnitureBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntityTypes.FURNITURE, pos, blockState);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        if (tag.m_128441_("Furniture")) {
            this.data = new FurnitureData(tag.m_128469_("Furniture"));
        } else if (tag.m_128441_("FurnitureHash")) {
            this.hash = tag.m_128461_("FurnitureHash");
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        if (this.data != null) {
            if (Config.getInstance().saveAsHash) {
                FurnitureDataManager.saveHashData(this.data);
                tag.m_128359_("FurnitureHash", this.data.getHash());
            } else {
                tag.m_128365_("Furniture", (Tag)this.data.toTag());
            }
        } else if (this.hash != null) {
            tag.m_128359_("FurnitureHash", this.hash);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public FurnitureData getData() {
        if (this.hash != null) {
            this.data = this.f_58857_ != null && this.f_58857_.f_46443_ ? FurnitureDataManager.getCachedData(this.hash) : FurnitureDataManager.getData(this.hash);
            if (this.data != null) {
                this.hash = null;
            }
        }
        return this.data;
    }

    public int m_6643_() {
        return this.getData().inventorySize * 9;
    }

    public void m_6211_() {
        this.getItems().clear();
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.getItems()) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.getItems(), (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.getItems(), (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public Component m_5446_() {
        FurnitureData d = this.getData();
        return d == null ? Component.m_237115_((String)"gui.immersive_furniture.furniture") : Component.m_237113_((String)d.name);
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        FurnitureData data = this.getData();
        if (data == null) {
            return null;
        }
        int rows = data.inventorySize;
        if (rows == 0) {
            return null;
        }
        MenuType menuType = switch (rows) {
            case 6 -> MenuType.f_39962_;
            case 5 -> MenuType.f_39961_;
            case 4 -> MenuType.f_39960_;
            case 3 -> MenuType.f_39959_;
            case 2 -> MenuType.f_39958_;
            default -> MenuType.f_39957_;
        };
        return new ChestMenu(menuType, containerId, inventory, (Container)this, rows);
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.playSound(SoundEvents.f_11725_);
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.playSound(SoundEvents.f_11724_);
        }
    }

    void playSound(SoundEvent sound) {
        if (this.f_58857_ == null) {
            return;
        }
        double d = (double)this.f_58858_.m_123341_() + 0.5;
        double e = (double)this.f_58858_.m_123342_() + 0.5;
        double f = (double)this.f_58858_.m_123343_() + 0.5;
        this.f_58857_.m_6263_(null, d, e, f, sound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public void m_7651_() {
        super.m_7651_();
    }
}

