/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.piece_figure.menus;

import andrews.table_top_craft.block_entities.ChessPieceFigureBlockEntity;
import andrews.table_top_craft.registry.TTCBlocks;
import andrews.table_top_craft.screens.base.BaseScreen;
import andrews.table_top_craft.screens.chess.sliders.ChessBlueColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessGreenColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessRedColorSlider;
import andrews.table_top_craft.screens.piece_figure.buttons.ChessPieceFigureConfirmColorButton;
import andrews.table_top_craft.screens.piece_figure.buttons.ChessPieceFigureConfirmScaleButton;
import andrews.table_top_craft.screens.piece_figure.buttons.ChessPieceFigureResetColorButton;
import andrews.table_top_craft.screens.piece_figure.buttons.ChessPieceFigureRotateButton;
import andrews.table_top_craft.screens.piece_figure.buttons.creative_mode.ChessPieceFigureNextSetButton;
import andrews.table_top_craft.screens.piece_figure.buttons.creative_mode.ChessPieceFigureNextTypeButton;
import andrews.table_top_craft.screens.piece_figure.buttons.creative_mode.ChessPieceFigurePreviousSetButton;
import andrews.table_top_craft.screens.piece_figure.buttons.creative_mode.ChessPieceFigurePreviousTypeButton;
import andrews.table_top_craft.screens.piece_figure.sliders.ChessPieceFigureScaleSlider;
import andrews.table_top_craft.screens.piece_figure.util.ColorPickerToggleButton;
import andrews.table_top_craft.screens.piece_figure.util.IColorPicker;
import andrews.table_top_craft.screens.piece_figure.util.SaturationSlider;
import andrews.table_top_craft.screens.piece_figure.util.TTCColorPicker;
import andrews.table_top_craft.util.Color;
import andrews.table_top_craft.util.NBTColorSaving;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.gui.widget.ForgeSlider;

public class ChessPieceFigureSettingsScreen
extends BaseScreen
implements IColorPicker {
    private static final ResourceLocation TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/menus/chess_piece_figure_menu.png");
    private static final ResourceLocation COLOR_PICKER_FRAME_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/color_picker/color_picker_frame.png");
    private static final Component TITLE = Component.m_237115_((String)"gui.table_top_craft.piece_figure.piece_settings");
    private static final Component TOGGLE_PIECE_ROT_TXT = Component.m_237115_((String)"gui.table_top_craft.piece_figure.toggle_rotation");
    private final ChessPieceFigureBlockEntity chessPieceFigureBlockEntity;
    private final ChessPieceFigureBlockEntity previewBlockEntity;
    private final ItemStack chessPieceFigureStack;
    private ChessRedColorSlider redColorSlider;
    private ChessGreenColorSlider greenColorSlider;
    private ChessBlueColorSlider blueColorSlider;
    private SaturationSlider saturationSlider;
    private ChessPieceFigureScaleSlider scaleSlider;
    public TTCColorPicker colorPicker;
    public boolean isColorPickerActive;

    public ChessPieceFigureSettingsScreen(ChessPieceFigureBlockEntity chessPieceFigureBlockEntity, boolean isColorPickerActive) {
        super(TEXTURE, 177, 158, TITLE);
        this.chessPieceFigureBlockEntity = chessPieceFigureBlockEntity;
        this.isColorPickerActive = isColorPickerActive;
        this.previewBlockEntity = new ChessPieceFigureBlockEntity(BlockPos.f_121853_, ((Block)TTCBlocks.CHESS_PIECE_FIGURE.get()).m_49966_());
        this.chessPieceFigureStack = new ItemStack((ItemLike)((Block)TTCBlocks.CHESS_PIECE_FIGURE.get()).m_5456_());
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ChessPieceFigurePreviousSetButton(this.chessPieceFigureBlockEntity, this.x + 5, this.y + 22));
        this.m_142416_((GuiEventListener)new ChessPieceFigurePreviousTypeButton(this.chessPieceFigureBlockEntity, this.x + 5, this.y + 38));
        this.m_142416_((GuiEventListener)new ChessPieceFigureNextSetButton(this.chessPieceFigureBlockEntity, this.x + (this.textureWidth - 31), this.y + 22));
        this.m_142416_((GuiEventListener)new ChessPieceFigureNextTypeButton(this.chessPieceFigureBlockEntity, this.x + (this.textureWidth - 31), this.y + 38));
        this.m_142416_((GuiEventListener)new ChessPieceFigureRotateButton(this.chessPieceFigureBlockEntity, this.x + 5, this.y + 60));
        this.m_142416_((GuiEventListener)new ColorPickerToggleButton(this.chessPieceFigureBlockEntity, this, false, this.x + 159, this.y + 60));
        this.redColorSlider = new ChessRedColorSlider(this.x + 5, this.y + 74, 167, 12, NBTColorSaving.getRed(this.chessPieceFigureBlockEntity.getPieceColor()), this);
        this.m_142416_((GuiEventListener)this.redColorSlider);
        this.greenColorSlider = new ChessGreenColorSlider(this.x + 5, this.y + 87, 167, 12, NBTColorSaving.getGreen(this.chessPieceFigureBlockEntity.getPieceColor()), this);
        this.m_142416_((GuiEventListener)this.greenColorSlider);
        this.blueColorSlider = new ChessBlueColorSlider(this.x + 5, this.y + 100, 167, 12, NBTColorSaving.getBlue(this.chessPieceFigureBlockEntity.getPieceColor()), this);
        this.m_142416_((GuiEventListener)this.blueColorSlider);
        this.m_142416_((GuiEventListener)new ChessPieceFigureResetColorButton(this, this.x + 5, this.y + 113));
        this.m_142416_((GuiEventListener)new ChessPieceFigureConfirmColorButton(this.chessPieceFigureBlockEntity, this.redColorSlider, this.greenColorSlider, this.blueColorSlider, this.x + 90, this.y + 113));
        this.scaleSlider = new ChessPieceFigureScaleSlider(this.x + 5, this.y + 127, 167, 12, this.chessPieceFigureBlockEntity.getPieceScale());
        this.m_142416_((GuiEventListener)this.scaleSlider);
        this.m_142416_((GuiEventListener)new ChessPieceFigureConfirmScaleButton(this.chessPieceFigureBlockEntity, this.scaleSlider, this.x + 5, this.y + 140));
        if (this.isColorPickerActive) {
            Color color = new Color(this.redColorSlider.getValueInt(), this.greenColorSlider.getValueInt(), this.blueColorSlider.getValueInt());
            this.colorPicker = new TTCColorPicker(this.x - 131, this.y + 8, this, color.getHue() / 360.0f, 1.0f - color.getValue());
            this.m_142416_((GuiEventListener)this.colorPicker);
            float saturation = color.getSaturation() * 100.0f;
            this.saturationSlider = new SaturationSlider(this.x - 132, this.y + 138, 130, 12, Math.round(saturation), this);
            this.m_142416_((GuiEventListener)this.saturationSlider);
        }
    }

    @Override
    public void renderScreenContents(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.isColorPickerActive) {
            graphics.m_280218_(COLOR_PICKER_FRAME_TEXTURE, this.x - 136, this.y + 3, 0, 0, 136, 151);
        }
        this.drawCenteredString(TITLE, this.f_96543_ / 2 + (this.isColorPickerActive ? 68 : 0), this.y + 6, 0x404040, false, graphics);
        graphics.m_280614_(this.f_96547_, TOGGLE_PIECE_ROT_TXT, this.x + 20, this.y + 63, 0, false);
        this.previewBlockEntity.setPieceSet(this.chessPieceFigureBlockEntity.getPieceSet());
        this.previewBlockEntity.setPieceType(this.chessPieceFigureBlockEntity.getPieceType());
        this.previewBlockEntity.setPieceColor(NBTColorSaving.saveColor(this.redColorSlider.getValueInt(), this.greenColorSlider.getValueInt(), this.blueColorSlider.getValueInt()));
        this.previewBlockEntity.setRotateChessPieceFigure(this.chessPieceFigureBlockEntity.getRotateChessPieceFigure());
        this.previewBlockEntity.m_187476_(this.chessPieceFigureStack);
        this.renderChessPiece(graphics.m_280168_(), this.chessPieceFigureStack, this.x + this.textureWidth / 2, this.y + 33, 52);
    }

    private void renderChessPiece(PoseStack poseStack, ItemStack itemStack, int pX, int pY, int size) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel itemBakedModel = itemRenderer.m_174264_(itemStack, null, null, 0);
        Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_252880_((float)pX, (float)pY, 100.0f);
        poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        poseStack.m_85841_((float)size, (float)size, (float)size);
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Lighting.m_84930_();
        itemRenderer.m_115143_(itemStack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, itemBakedModel);
        bufferSource.m_109911_();
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    @Override
    public int offsetX() {
        return this.isColorPickerActive ? 136 : super.offsetX();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        super.m_7933_(keyCode, scanCode, modifiers);
        if (this.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
        }
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    public static void open(ChessPieceFigureBlockEntity chessPieceFigureBlockEntity) {
        Minecraft.m_91087_().m_91152_((Screen)new ChessPieceFigureSettingsScreen(chessPieceFigureBlockEntity, false));
    }

    @Override
    public TTCColorPicker getColorPicker() {
        return this.colorPicker;
    }

    @Override
    public ForgeSlider getRedSlider() {
        return this.redColorSlider;
    }

    @Override
    public ForgeSlider getGreenSlider() {
        return this.greenColorSlider;
    }

    @Override
    public ForgeSlider getBlueSlider() {
        return this.blueColorSlider;
    }

    @Override
    public ForgeSlider getSaturationSlider() {
        return this.saturationSlider;
    }

    @Override
    public boolean isColorPickerActive() {
        return this.isColorPickerActive;
    }
}

