/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.chess.menus;

import andrews.table_top_craft.block_entities.ChessBlockEntity;
import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.screens.base.BaseScreen;
import andrews.table_top_craft.screens.chess.buttons.colors.ChessBoardColorSettingsButton;
import andrews.table_top_craft.screens.chess.buttons.pieces.ChessBoardPieceSettingsButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessBoardSettingsButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessCopyFENButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessEvaluateBoardButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessLoadFENButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessMoveLogDownButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessMoveLogUpButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessNewGameButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessShowAvailableMovesButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessShowPreviousMoveButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessShowTileInfoButton;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ChessBoardSettingsScreen
extends BaseScreen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/menus/chess_menu.png");
    private static final ResourceLocation MOVE_LOG_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/menus/move_log.png");
    private static final Component TITLE = Component.m_237115_((String)"gui.table_top_craft.chess.board_settings");
    private static final Component MOVE_LOG_TXT = Component.m_237115_((String)"gui.table_top_craft.chess.move_log");
    private static final Component MOVE_LOG_WHITE_TXT = Component.m_237115_((String)"gui.table_top_craft.chess.move_log.white");
    private static final Component MOVE_LOG_BLACK_TXT = Component.m_237115_((String)"gui.table_top_craft.chess.move_log.black");
    private static final Component SHOW_TILE_INFO_TXT = Component.m_237115_((String)"gui.table_top_craft.chess.show_tile_info");
    private static final Component SHOW_AVAILABLE_MOVES_TXT = Component.m_237115_((String)"gui.table_top_craft.chess.show_available_moves");
    private static final Component SHOW_PREVIOUS_MOVE_TXT = Component.m_237115_((String)"gui.table_top_craft.chess.show_previous_move");
    private final ChessBlockEntity chessBlockEntity;
    private int moveLogOffset;

    public ChessBoardSettingsScreen(ChessBlockEntity chessBlockEntity) {
        super(TEXTURE, 177, 198, TITLE);
        this.chessBlockEntity = chessBlockEntity;
        this.moveLogOffset = 0;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ChessBoardSettingsButton(this.chessBlockEntity, this.x - 24, this.y + 16));
        this.m_142416_((GuiEventListener)new ChessBoardColorSettingsButton(this.chessBlockEntity, this.x - 24, this.y + 42));
        this.m_142416_((GuiEventListener)new ChessBoardPieceSettingsButton(this.chessBlockEntity, this.x - 24, this.y + 68));
        this.m_142416_((GuiEventListener)new ChessNewGameButton(this.chessBlockEntity.m_58899_(), this.x + 5, this.y + 16));
        this.m_142416_((GuiEventListener)new ChessEvaluateBoardButton(this.chessBlockEntity, this.x + 90, this.y + 16));
        this.m_142416_((GuiEventListener)new ChessCopyFENButton(this.chessBlockEntity, this.x + 5, this.y + 31));
        this.m_142416_((GuiEventListener)new ChessLoadFENButton(this.chessBlockEntity, this.x + 90, this.y + 31));
        this.m_142416_((GuiEventListener)new ChessShowTileInfoButton(this.chessBlockEntity, this.x + 5, this.y + 46));
        this.m_142416_((GuiEventListener)new ChessShowAvailableMovesButton(this.chessBlockEntity, this.x + 5, this.y + 60));
        this.m_142416_((GuiEventListener)new ChessShowPreviousMoveButton(this.chessBlockEntity, this.x + 5, this.y + 74));
        this.m_142416_((GuiEventListener)new ChessMoveLogDownButton(this.x + 161, this.y + 112, this));
        this.m_142416_((GuiEventListener)new ChessMoveLogUpButton(this.x + 161, this.y + 167, this, this.chessBlockEntity));
    }

    @Override
    public void renderScreenContents(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280218_(TEXTURE, this.x, this.y + 15, 0, 198, 3, 26);
        graphics.m_280218_(MOVE_LOG_TEXTURE, this.x + 5, this.y + 101, 0, 0, 155, 89);
        for (int i = 0; i < (this.moveLogOffset % 2 != 0 ? 3 : 4); ++i) {
            graphics.m_280218_(MOVE_LOG_TEXTURE, this.x + 6, this.y + 124 + i * 22 - (this.moveLogOffset % 2 != 0 ? 0 : 11), 0, 89, 153, 10);
        }
        this.drawCenteredString(TITLE, this.f_96543_ / 2, this.y + 6, 0x404040, false, graphics);
        this.drawCenteredString(MOVE_LOG_TXT, this.f_96543_ / 2, this.y + 90, 0x404040, false, graphics);
        graphics.m_280614_(this.f_96547_, SHOW_TILE_INFO_TXT, this.x + 20, this.y + 49, 0, false);
        graphics.m_280614_(this.f_96547_, SHOW_AVAILABLE_MOVES_TXT, this.x + 20, this.y + 63, 0, false);
        graphics.m_280614_(this.f_96547_, SHOW_PREVIOUS_MOVE_TXT, this.x + 20, this.y + 77, 0, false);
        this.drawCenteredString(MOVE_LOG_WHITE_TXT, this.x + 54, this.y + 103, 0, false, graphics);
        this.drawCenteredString(MOVE_LOG_BLACK_TXT, this.x + 124, this.y + 103, 0, false, graphics);
        int offset = 0;
        int currentMoveId = 1;
        if (this.chessBlockEntity.getMoveLog() != null) {
            offset -= this.moveLogOffset * 11;
            for (int i = 0; i < this.chessBlockEntity.getMoveLog().getMoves().size(); ++i) {
                PieceColor pieceColor = this.chessBlockEntity.getMoveLog().getMoves().get(i).getMovedPiece().getPieceColor();
                String moveName = this.chessBlockEntity.getMoveLog().getMoves().get(i).toString();
                if (this.moveLogOffset * 2 <= i && this.moveLogOffset * 2 + 14 > i) {
                    graphics.m_280056_(this.f_96547_, moveName, this.x - moveName.length() * 6 / 2 + 54 + (pieceColor == PieceColor.WHITE ? 0 : 70), this.y + 114 + offset, 0, false);
                    if (i % 2 == 0) {
                        graphics.m_280056_(this.f_96547_, String.valueOf(currentMoveId + this.moveLogOffset), this.x + 7 + (currentMoveId + this.moveLogOffset > 9 ? 0 : 3), this.y + 114 + offset, 0, false);
                        ++currentMoveId;
                    }
                }
                if (i % 2 == 0) continue;
                offset += 11;
            }
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        super.m_7933_(keyCode, scanCode, modifiers);
        if (this.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
        }
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    public int getMoveLogOffset() {
        return this.moveLogOffset;
    }

    public void decreaseMoveLogOffset() {
        if (this.moveLogOffset > 0) {
            --this.moveLogOffset;
        }
    }

    public void increaseMoveLogOffset() {
        ++this.moveLogOffset;
    }

    public static void open(ChessBlockEntity chessBlockEntity) {
        Minecraft.m_91087_().m_91152_((Screen)new ChessBoardSettingsScreen(chessBlockEntity));
    }
}

