/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.chess.menus;

import andrews.table_top_craft.block_entities.ChessBlockEntity;
import andrews.table_top_craft.game_logic.chess.player.ai.StandardBoardEvaluator;
import andrews.table_top_craft.screens.base.BaseScreen;
import andrews.table_top_craft.screens.chess.buttons.ChessCancelButton;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ChessBoardEvaluatorScreen
extends BaseScreen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/menus/chess_menu.png");
    private static final Component TITLE = Component.m_237115_((String)"gui.table_top_craft.chess.board_evaluator");
    private static final Component WHITE_PLAYER_TXT = Component.m_237115_((String)"gui.table_top_craft.chess.evaluation.white_player");
    private static final Component BLACK_PLAYER_TXT = Component.m_237115_((String)"gui.table_top_craft.chess.evaluation.black_player");
    private static final Component CURRENT_SCORE_TXT = Component.m_237115_((String)"gui.table_top_craft.chess.evaluation.current_score");
    private final String boardEvaluationText;
    private final ChessBlockEntity chessBlockEntity;
    private final LocalPlayer clientPlayer;

    public ChessBoardEvaluatorScreen(ChessBlockEntity chessBlockEntity) {
        super(TEXTURE, 177, 198, TITLE);
        this.chessBlockEntity = chessBlockEntity;
        this.boardEvaluationText = StandardBoardEvaluator.get().evaluationDetails(chessBlockEntity.getBoard(), 0);
        this.clientPlayer = Minecraft.m_91087_().f_91074_;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ChessCancelButton(this.chessBlockEntity, ChessCancelButton.ChessCancelMenuTarget.CHESS_BOARD_SETTINGS, ChessCancelButton.ChessCancelButtonText.BACK, this.x + this.textureWidth / 2 - 41, this.y + 180));
    }

    @Override
    public void renderScreenContents(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280218_(TEXTURE, this.x + 5, this.y + 152, 0, 224, 167, 12);
        int offset = StandardBoardEvaluator.get().evaluate(this.chessBlockEntity.getBoard(), 1) / 23;
        offset = Mth.m_14045_((int)offset, (int)-80, (int)84);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)offset, 0.0f, 0.0f);
        if (this.clientPlayer.f_19797_ % 16 <= 8) {
            graphics.m_280218_(TEXTURE, this.x + 83, this.y + 162, 3, 198, 7, 5);
        }
        graphics.m_280168_().m_85849_();
        offset = Mth.m_14045_((int)offset, (int)(-82 + this.f_96547_.m_92852_((FormattedText)CURRENT_SCORE_TXT) / 2), (int)(88 - this.f_96547_.m_92852_((FormattedText)CURRENT_SCORE_TXT) / 2));
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)offset, 0.0f, 0.0f);
        this.drawCenteredString(CURRENT_SCORE_TXT, this.x + 86, this.y + 168, 0, false, graphics);
        graphics.m_280168_().m_85849_();
        this.drawCenteredString(TITLE, this.f_96543_ / 2, this.y + 6, 0x404040, false, graphics);
        graphics.m_280614_(this.f_96547_, BLACK_PLAYER_TXT, this.x + 7, this.y + 154, 0xFFFFFF, false);
        graphics.m_280614_(this.f_96547_, WHITE_PLAYER_TXT, this.x + this.textureWidth - (this.f_96547_.m_92852_((FormattedText)WHITE_PLAYER_TXT) + 6), this.y + 154, 0, false);
        this.renderEvaluationText(graphics, this.x, this.y);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        super.m_7933_(keyCode, scanCode, modifiers);
        if (this.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
        }
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    private void renderEvaluationText(GuiGraphics graphics, int x, int y) {
        String[] evaluationLines;
        for (String evaluationLine : evaluationLines = this.boardEvaluationText.split("\n")) {
            graphics.m_280056_(this.f_96547_, evaluationLine, x + 5, y + 17, 0, false);
            y += 9;
        }
    }
}

