/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.player;

import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.board.moves.CastleMove;
import andrews.table_top_craft.game_logic.chess.board.moves.KingSideCastleMove;
import andrews.table_top_craft.game_logic.chess.board.moves.QueenSideCastleMove;
import andrews.table_top_craft.game_logic.chess.board.tiles.BaseChessTile;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.pieces.RookPiece;
import andrews.table_top_craft.game_logic.chess.player.BaseChessPlayer;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;

public class WhiteChessPlayer
extends BaseChessPlayer {
    public WhiteChessPlayer(Board board, Collection<BaseMove> whiteStandardLegalMoves, Collection<BaseMove> blackStandardLegalMoves) {
        super(board, whiteStandardLegalMoves, blackStandardLegalMoves);
    }

    @Override
    public Collection<BasePiece> getActivePieces() {
        return this.board.getWhitePieces();
    }

    @Override
    public PieceColor getPieceColor() {
        return PieceColor.WHITE;
    }

    @Override
    public BaseChessPlayer getOpponent() {
        return this.board.getBlackChessPlayer();
    }

    @Override
    public boolean isCastled() {
        return this.playerKing.isCastled();
    }

    @Override
    protected Collection<BaseMove> calculateKingCastles(Collection<BaseMove> playerLegals, Collection<BaseMove> opponentsLegals) {
        ArrayList<CastleMove> kingCastles = new ArrayList<CastleMove>();
        if (this.playerKing.isFirstMove() && !this.isInCheck()) {
            BaseChessTile rookTile;
            if (!this.board.getTile(61).isTileOccupied() && !this.board.getTile(62).isTileOccupied() && (rookTile = this.board.getTile(63)).isTileOccupied() && rookTile.getPiece().isFirstMove() && BaseChessPlayer.calculateAttacksOnTile(61, opponentsLegals).isEmpty() && BaseChessPlayer.calculateAttacksOnTile(62, opponentsLegals).isEmpty() && rookTile.getPiece().getPieceType().isRook() && this.playerKing.isKingSideCastleCapable()) {
                kingCastles.add(new KingSideCastleMove(this.board, this.playerKing, 62, (RookPiece)rookTile.getPiece(), rookTile.getTileCoordinate(), 61));
            }
            if (!this.board.getTile(59).isTileOccupied() && !this.board.getTile(58).isTileOccupied() && !this.board.getTile(57).isTileOccupied() && (rookTile = this.board.getTile(56)).isTileOccupied() && rookTile.getPiece().isFirstMove() && BaseChessPlayer.calculateAttacksOnTile(58, opponentsLegals).isEmpty() && BaseChessPlayer.calculateAttacksOnTile(59, opponentsLegals).isEmpty() && rookTile.getPiece().getPieceType().isRook() && this.playerKing.isQueenSideCastleCapable()) {
                kingCastles.add(new QueenSideCastleMove(this.board, this.playerKing, 58, (RookPiece)rookTile.getPiece(), rookTile.getTileCoordinate(), 59));
            }
        }
        return ImmutableList.copyOf(kingCastles);
    }

    public String toString() {
        return PieceColor.WHITE.toString();
    }
}

