/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.board.moves;

import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.BoardUtils;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.pieces.PawnPiece;

public final class PawnJumpMove
extends BaseMove {
    public PawnJumpMove(Board board, BasePiece movedPiece, int destinationCoordinate) {
        super(board, movedPiece, destinationCoordinate);
    }

    @Override
    public Board execute() {
        Board.Builder builder = new Board.Builder();
        for (BasePiece piece : this.board.getCurrentChessPlayer().getActivePieces()) {
            if (this.movedPiece.equals(piece)) continue;
            builder.setPiece(piece);
        }
        for (BasePiece piece : this.board.getCurrentChessPlayer().getOpponent().getActivePieces()) {
            builder.setPiece(piece);
        }
        PawnPiece movedPawn = (PawnPiece)this.movedPiece.movePiece(this);
        builder.setPiece(movedPawn);
        builder.setEnPassantPawn(movedPawn);
        builder.setMoveMaker(this.board.getCurrentChessPlayer().getOpponent().getPieceColor());
        return builder.build();
    }

    public String toString() {
        return BoardUtils.getPositionAtCoordinate(this.destinationCoordinate);
    }

    @Override
    public String saveToNBT() {
        return "pawn_jump/" + this.getColorForPiece(this.movedPiece) + "/" + this.movedPiece.getPiecePosition() + "/" + this.destinationCoordinate;
    }
}

