/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.board.moves;

import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.moves.PawnAttackMove;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;

public final class PawnEnPassantAttackMove
extends PawnAttackMove {
    public PawnEnPassantAttackMove(Board board, BasePiece movedPiece, int destinationCoordinate, BasePiece attackedPiece) {
        super(board, movedPiece, destinationCoordinate, attackedPiece);
    }

    @Override
    public boolean equals(Object object) {
        return this == object || object instanceof PawnEnPassantAttackMove && super.equals(object);
    }

    @Override
    public Board execute() {
        Board.Builder builder = new Board.Builder();
        for (BasePiece piece : this.board.getCurrentChessPlayer().getActivePieces()) {
            if (this.movedPiece.equals(piece)) continue;
            builder.setPiece(piece);
        }
        for (BasePiece piece : this.board.getCurrentChessPlayer().getOpponent().getActivePieces()) {
            if (piece.equals(this.attackedPiece)) continue;
            builder.setPiece(piece);
        }
        builder.setPiece(this.movedPiece.movePiece(this));
        builder.setMoveMaker(this.board.getCurrentChessPlayer().getOpponent().getPieceColor());
        return builder.build();
    }

    @Override
    public boolean isEnPassantMove() {
        return true;
    }

    @Override
    public String saveToNBT() {
        return "pawn_enpassant/" + this.getColorForPiece(this.movedPiece) + "/" + this.movedPiece.getPiecePosition() + "/" + this.destinationCoordinate + "/" + this.attackedPiece.getPiecePosition();
    }
}

