/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.animation.system.core.util;

import andrews.table_top_craft.shadowed.objecthunter.exp4j.Expression;
import andrews.table_top_craft.shadowed.objecthunter.exp4j.ExpressionBuilder;
import andrews.table_top_craft.shadowed.objecthunter.exp4j.function.Function;
import com.google.common.collect.Maps;
import java.util.Map;

public class DynamicExpression {
    Map<String, Double> variables = Maps.newHashMap();
    Function dcos = new Function("dcos", 1){

        @Override
        public double apply(double ... args) {
            return Math.cos(args[0] / 180.0 * Math.PI);
        }
    };
    Function dsin = new Function("dsin", 1){

        @Override
        public double apply(double ... args) {
            return Math.sin(args[0] / 180.0 * Math.PI);
        }
    };
    private Expression expression;
    private final boolean useQuickValue;
    float quickValue;

    public DynamicExpression(String expression) {
        this.useQuickValue = this.useQuickValue(expression);
        if (!this.useQuickValue) {
            ExpressionBuilder builder = new ExpressionBuilder(expression);
            builder.function(this.dcos);
            builder.function(this.dsin);
            builder.variable("anim_time");
            this.expression = builder.build();
            this.initVariables();
        }
    }

    public void updateVariable(QueryTypes type, double value) {
        if (!this.useQuickValue) {
            switch (type) {
                case ANIM_TIME: {
                    this.variables.put(QueryTypes.ANIM_TIME.getKey(), value);
                }
            }
        }
    }

    public double getValue() {
        if (!this.useQuickValue) {
            this.expression.setVariables(this.variables);
            return this.expression.evaluate();
        }
        return this.quickValue;
    }

    private void initVariables() {
        for (String key : this.expression.getVariableNames()) {
            this.expression.setVariable(key, 0.0);
        }
    }

    private boolean useQuickValue(String expression) {
        try {
            this.quickValue = Float.parseFloat(expression);
        }
        catch (Exception ignored) {
            return false;
        }
        return true;
    }

    public static enum QueryTypes {
        ANIM_TIME("anim_time");

        private final String key;

        private QueryTypes(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

