/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.server;

import ht.treechop.common.network.CustomPacket;
import ht.treechop.common.network.ForgePacketHandler;
import ht.treechop.common.settings.ChoppingEntity;
import ht.treechop.common.settings.SyncedChopData;
import ht.treechop.server.Server;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgeServer
extends Server {
    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
    }

    @Override
    public void broadcast(ServerLevel level, BlockPos pos, CustomPacket packet) {
        ForgePacketHandler.HANDLER.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), (Object)packet);
    }

    @Override
    public void sendTo(ServerPlayer player, CustomPacket packet) {
        ForgePacketHandler.HANDLER.sendTo((Object)packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    static {
        Server.instance = new ForgeServer();
    }

    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onPlayerCloned(PlayerEvent.Clone event) {
            if (event.isWasDeath()) {
                Player oldPlayer = event.getOriginal();
                Player newPlayer = event.getEntity();
                SyncedChopData chopSettings = Server.instance.getPlayerChopData(oldPlayer);
                ((ChoppingEntity)newPlayer).setChopData(chopSettings);
            }
        }
    }
}

