/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.helpers.recipe;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.mcreator.ars_technica.common.entity.fusion.ArcaneFusionType;
import net.mcreator.ars_technica.common.entity.fusion.fluids.FluidSourceProvider;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class MixingRecipeHelpers {
    public static Optional<MixingRecipeResult> getMixingRecipe(List<ItemEntity> items, List<FluidSourceProvider> fluids, Level world, ArcaneFusionType fusionType) {
        RecipeManager recipeManager = world.m_7465_();
        List<MixingRecipe> mixingRecipes = recipeManager.m_44013_(AllRecipeTypes.MIXING.getType()).stream().filter(MixingRecipe.class::isInstance).map(MixingRecipe.class::cast).filter(x -> x.getRequiredHeat() == fusionType.getSuppliedHeat()).toList();
        for (MixingRecipe mixingRecipe : mixingRecipes) {
            ArrayList<FluidSourceProvider> usedFluids;
            ArrayList<ItemEntity> usedEntities;
            boolean matches = MixingRecipeHelpers.mixingRecipeIngredientsMatch(mixingRecipe, items, fluids, usedEntities = new ArrayList<ItemEntity>(), usedFluids = new ArrayList<FluidSourceProvider>());
            if (!matches) continue;
            MixingRecipeResult result = new MixingRecipeResult(mixingRecipe, usedEntities, usedFluids);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private static boolean mixingRecipeIngredientsMatch(MixingRecipe recipe, List<ItemEntity> availableItems, List<FluidSourceProvider> availableFluids, List<ItemEntity> usedEntities, List<FluidSourceProvider> usedFluids) {
        HashMap<ItemEntity, Integer> usageMap = new HashMap<ItemEntity, Integer>();
        block0: for (Ingredient itemIngredient : recipe.m_7527_()) {
            for (ItemStack ingredientVariant : itemIngredient.m_43908_()) {
                Optional<ItemEntity> itemCandidate = availableItems.stream().filter(item -> item.m_32055_().m_41720_() == ingredientVariant.m_41720_()).findFirst();
                if (!itemCandidate.isPresent()) continue;
                ItemEntity candidateUnwrapped = itemCandidate.get();
                int usedCount = usageMap.getOrDefault(candidateUnwrapped, 0);
                int candidateItemCount = candidateUnwrapped.m_32055_().m_41613_();
                if (candidateItemCount < ingredientVariant.m_41613_() || candidateItemCount <= usedCount) continue;
                usedEntities.add(candidateUnwrapped);
                usageMap.put(candidateUnwrapped, usedCount + 1);
                continue block0;
            }
        }
        if (usedEntities.size() < recipe.m_7527_().size()) {
            return false;
        }
        block2: for (FluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            for (FluidStack ingredientVariant : fluidIngredient.getMatchingFluidStacks()) {
                FluidSourceProvider candidateUnwrapped;
                Optional<FluidSourceProvider> fluidCandidate = availableFluids.stream().filter(fluid -> fluid.getFluidStack().getFluid() == ingredientVariant.getFluid()).findFirst();
                if (!fluidCandidate.isPresent() || (candidateUnwrapped = fluidCandidate.get()).getMbAmount() < ingredientVariant.getAmount()) continue;
                usedFluids.add(candidateUnwrapped);
                continue block2;
            }
        }
        return usedEntities.size() == recipe.m_7527_().size() && usedFluids.size() == recipe.getFluidIngredients().size();
    }

    public static class MixingRecipeResult {
        public MixingRecipe recipe;
        public List<ItemEntity> usedEntities;
        public List<FluidSourceProvider> usedFluids;

        public MixingRecipeResult(MixingRecipe recipe, List<ItemEntity> usedEntities, List<FluidSourceProvider> usedFluids) {
            this.recipe = recipe;
            this.usedEntities = usedEntities;
            this.usedFluids = usedFluids;
        }
    }
}

