/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.entity;

import com.hollingsworth.arsnouveau.common.block.tile.PortalTile;
import net.mcreator.ars_technica.common.helpers.ConsumptionHelper;
import net.mcreator.ars_technica.common.helpers.ProjectileHelper;
import net.mcreator.ars_technica.setup.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;

public class ItemProjectileEntity
extends Entity {
    private ItemStack itemStack = ItemStack.f_41583_;
    private Vec3 velocity = Vec3.f_82478_;
    private final Level world;
    private static final EntityDataAccessor<ItemStack> ITEM_STACK = SynchedEntityData.m_135353_(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final int MAXIMUM_LIFE_TIME_TICKS = 200;
    private int ticks = 0;

    public ItemStack getStack() {
        return this.itemStack;
    }

    public ItemProjectileEntity(EntityType<ItemProjectileEntity> type, Level world) {
        super(type, world);
        this.world = world;
    }

    public ItemProjectileEntity(Level world, Vec3 position, Vec3 direction, ItemStack itemStack) {
        this((EntityType<ItemProjectileEntity>)((EntityType)EntityRegistry.ITEM_PROJECTILE_ENTITY.get()), world);
        this.m_146884_(position);
        this.velocity = direction.m_82490_(0.2);
        this.itemStack = itemStack.m_41777_();
        this.f_19804_.m_135381_(ITEM_STACK, (Object)itemStack);
    }

    public void m_8119_() {
        HitResult rayTrace;
        super.m_8119_();
        ++this.ticks;
        if (this.ticks >= 200) {
            this.m_146870_();
        }
        this.m_20256_(this.velocity);
        this.m_6478_(MoverType.SELF, this.velocity);
        if (!this.world.f_46443_ && (rayTrace = ProjectileHelper.getHitResult(this, this::shouldEntityCollide, this::shouldBlockEntityCollide)) != null) {
            this.onImpact(rayTrace);
            this.m_146870_();
        }
        if (!this.world.m_46739_(this.m_20183_())) {
            this.m_146870_();
        }
    }

    private boolean shouldEntityCollide(Entity entity) {
        return entity instanceof LivingEntity;
    }

    private <T extends CapabilityProvider<?>> boolean shouldBlockEntityCollide(T entity) {
        if (entity instanceof PortalTile) {
            return false;
        }
        boolean isItemHandler = entity.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent();
        boolean isFluidHandler = entity.getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent();
        return !isItemHandler && !isFluidHandler;
    }

    private void onImpact(HitResult hitResult) {
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHit = (EntityHitResult)hitResult;
            this.handleEntityImpact(entityHit.m_82443_());
        } else if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hitResult;
            this.handleBlockImpact(blockHit.m_82425_());
        }
    }

    private void handleEntityImpact(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (ConsumptionHelper.tryUseEdibleItem(target, this.itemStack, this.world)) {
                return;
            }
            if (ConsumptionHelper.tryUseConsumableItem(target, this.itemStack, this.world, true)) {
                return;
            }
        }
    }

    private void handleBlockImpact(BlockPos pos) {
        this.m_146870_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (ITEM_STACK.equals(key)) {
            this.itemStack = (ItemStack)this.f_19804_.m_135370_(ITEM_STACK);
        }
    }

    protected void m_7378_(CompoundTag tag) {
        this.itemStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128365_("Item", (Tag)this.itemStack.m_41739_(new CompoundTag()));
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

