/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class Inventories {
    public static boolean areItemStacksIdentical(ItemStack a, ItemStack b) {
        return a.m_41720_() == b.m_41720_() && ItemStack.m_150942_((ItemStack)a, (ItemStack)b);
    }

    public static boolean areItemStacksDifferent(ItemStack a, ItemStack b) {
        return a.m_41720_() != b.m_41720_() || !ItemStack.m_150942_((ItemStack)a, (ItemStack)b);
    }

    public static boolean isItemStackableOn(ItemStack a, ItemStack b) {
        return !a.m_41619_() && ItemStack.m_41656_((ItemStack)a, (ItemStack)b) && a.m_41782_() == b.m_41782_() && (!a.m_41782_() || a.m_41783_().equals((Object)b.m_41783_()));
    }

    public static ItemStack extract(Player player, @Nullable ItemStack match, int amount, boolean simulate) {
        if (amount <= 0) {
            return ItemStack.f_41583_;
        }
        InventoryRange ir = InventoryRange.fromPlayerInventory(player);
        if (match == null) {
            return ir.extract(amount, false, simulate);
        }
        ItemStack mstack = match.m_41777_();
        mstack.m_41764_(amount);
        return ir.extract(mstack, simulate);
    }

    public static ItemStack insert(Player player, ItemStack stack, boolean simulate) {
        return InventoryRange.fromPlayerInventory(player).insert(stack, simulate);
    }

    private static ItemStack checked(ItemStack stack) {
        return stack.m_41619_() ? ItemStack.f_41583_ : stack;
    }

    public static Container copyOf(Container src) {
        int size = src.m_6643_();
        SimpleContainer dst = new SimpleContainer(size);
        for (int i = 0; i < size; ++i) {
            dst.m_6836_(i, src.m_8020_(i).m_41777_());
        }
        return dst;
    }

    public static ItemStack insert(InventoryRange[] to_ranges, ItemStack stack) {
        ItemStack remaining = stack.m_41777_();
        for (InventoryRange range : to_ranges) {
            if (!(remaining = range.insert(remaining, false, 0, false, true)).m_41619_()) continue;
            return remaining;
        }
        return remaining;
    }

    public static void give(Player entity, ItemStack stack) {
        entity.m_150109_().m_150079_(stack);
    }

    public static class InventoryRange
    implements Container,
    Iterable<ItemStack> {
        protected final Container inventory_;
        protected final int offset_;
        protected final int size_;
        protected final int num_rows;
        protected int max_stack_size_ = 64;
        protected BiPredicate<Integer, ItemStack> validator_ = (index, stack) -> true;

        public static InventoryRange fromPlayerHotbar(Player player) {
            return new InventoryRange((Container)player.m_150109_(), 0, 9, 1);
        }

        public static InventoryRange fromPlayerStorage(Player player) {
            return new InventoryRange((Container)player.m_150109_(), 9, 27, 3);
        }

        public static InventoryRange fromPlayerInventory(Player player) {
            return new InventoryRange((Container)player.m_150109_(), 0, 36, 4);
        }

        public InventoryRange(Container inventory, int offset, int size, int num_rows) {
            this.inventory_ = inventory;
            this.offset_ = Mth.m_14045_((int)offset, (int)0, (int)(inventory.m_6643_() - 1));
            this.size_ = Mth.m_14045_((int)size, (int)0, (int)(inventory.m_6643_() - this.offset_));
            this.num_rows = num_rows;
        }

        public InventoryRange(Container inventory, int offset, int size) {
            this(inventory, offset, size, 1);
        }

        public InventoryRange(Container inventory) {
            this(inventory, 0, inventory.m_6643_(), 1);
        }

        public final Container inventory() {
            return this.inventory_;
        }

        public final int size() {
            return this.size_;
        }

        public final int offset() {
            return this.offset_;
        }

        public final ItemStack get(int index) {
            return this.inventory_.m_8020_(this.offset_ + index);
        }

        public final void set(int index, ItemStack stack) {
            this.inventory_.m_6836_(this.offset_ + index, stack);
        }

        public final InventoryRange setValidator(BiPredicate<Integer, ItemStack> validator) {
            this.validator_ = validator;
            return this;
        }

        public final BiPredicate<Integer, ItemStack> getValidator() {
            return this.validator_;
        }

        public final InventoryRange setMaxStackSize(int count) {
            this.max_stack_size_ = Math.max(count, 1);
            return this;
        }

        public void m_6211_() {
            for (int i = 0; i < this.size_; ++i) {
                this.m_6836_(i, ItemStack.f_41583_);
            }
        }

        public int m_6643_() {
            return this.size_;
        }

        public boolean m_7983_() {
            for (int i = 0; i < this.size_; ++i) {
                if (this.inventory_.m_8020_(this.offset_ + i).m_41619_()) continue;
                return false;
            }
            return true;
        }

        public ItemStack m_8020_(int index) {
            return this.inventory_.m_8020_(this.offset_ + index);
        }

        public ItemStack m_7407_(int index, int count) {
            return this.inventory_.m_7407_(this.offset_ + index, count);
        }

        public ItemStack m_8016_(int index) {
            return this.inventory_.m_8016_(this.offset_ + index);
        }

        public void m_6836_(int index, ItemStack stack) {
            this.inventory_.m_6836_(this.offset_ + index, stack);
        }

        public int m_6893_() {
            return Math.min(this.max_stack_size_, this.inventory_.m_6893_());
        }

        public void m_6596_() {
            this.inventory_.m_6596_();
        }

        public boolean m_6542_(Player player) {
            return this.inventory_.m_6542_(player);
        }

        public void m_5856_(Player player) {
            this.inventory_.m_5856_(player);
        }

        public void m_5785_(Player player) {
            this.inventory_.m_5785_(player);
        }

        public boolean m_7013_(int index, ItemStack stack) {
            return this.validator_.test(this.offset_ + index, stack) && this.inventory_.m_7013_(this.offset_ + index, stack);
        }

        public boolean iterate(BiPredicate<Integer, ItemStack> fn) {
            for (int i = 0; i < this.size_; ++i) {
                if (!fn.test(i, this.m_8020_(i))) continue;
                return true;
            }
            return false;
        }

        public boolean contains(ItemStack stack) {
            for (int i = 0; i < this.size_; ++i) {
                if (!Inventories.areItemStacksIdentical(stack, this.m_8020_(i))) continue;
                return true;
            }
            return false;
        }

        public int indexOf(ItemStack stack) {
            for (int i = 0; i < this.size_; ++i) {
                if (!Inventories.areItemStacksIdentical(stack, this.m_8020_(i))) continue;
                return i;
            }
            return -1;
        }

        public <T> Optional<T> find(BiFunction<Integer, ItemStack, Optional<T>> fn) {
            for (int i = 0; i < this.size_; ++i) {
                Optional<T> r = fn.apply(i, this.m_8020_(i));
                if (!r.isPresent()) continue;
                return r;
            }
            return Optional.empty();
        }

        public <T> List<T> collect(BiFunction<Integer, ItemStack, Optional<T>> fn) {
            ArrayList data = new ArrayList();
            for (int i = 0; i < this.size_; ++i) {
                fn.apply(i, this.m_8020_(i)).ifPresent(data::add);
            }
            return data;
        }

        public Stream<ItemStack> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        public Iterator<ItemStack> iterator() {
            return new InventoryRangeIterator(this);
        }

        public int stackMatchCount(ItemStack ref_stack) {
            int n = 0;
            for (int i = 0; i < this.size_; ++i) {
                if (!Inventories.areItemStacksIdentical(ref_stack, this.m_8020_(i))) continue;
                ++n;
            }
            return n;
        }

        public int totalMatchingItemCount(ItemStack ref_stack) {
            int n = 0;
            for (int i = 0; i < this.size_; ++i) {
                ItemStack stack = this.m_8020_(i);
                if (!Inventories.areItemStacksIdentical(ref_stack, stack)) continue;
                n += stack.m_41613_();
            }
            return n;
        }

        public ItemStack insert(ItemStack input_stack, boolean only_fillup, int limit, boolean reverse, boolean force_group_stacks) {
            int nmax;
            ItemStack stack;
            int sno;
            int i;
            ItemStack mvstack = input_stack.m_41777_();
            if (mvstack.m_41619_()) {
                return Inventories.checked(mvstack);
            }
            int limit_left = limit > 0 ? Math.min(limit, mvstack.m_41741_()) : mvstack.m_41741_();
            boolean[] matches = new boolean[this.size_];
            boolean[] empties = new boolean[this.size_];
            int num_matches = 0;
            for (i = 0; i < this.size_; ++i) {
                sno = reverse ? this.size_ - 1 - i : i;
                stack = this.m_8020_(sno);
                if (stack.m_41619_()) {
                    empties[sno] = true;
                    continue;
                }
                if (!Inventories.areItemStacksIdentical(stack, mvstack)) continue;
                matches[sno] = true;
                ++num_matches;
            }
            for (i = 0; i < this.size_; ++i) {
                int n = sno = reverse ? this.size_ - 1 - i : i;
                if (empties[sno] || !matches[sno]) continue;
                stack = this.m_8020_(sno);
                nmax = Math.min(limit_left, stack.m_41741_() - stack.m_41613_());
                if (mvstack.m_41613_() <= nmax) {
                    stack.m_41764_(stack.m_41613_() + mvstack.m_41613_());
                    this.m_6836_(sno, stack);
                    return ItemStack.f_41583_;
                }
                mvstack.m_41774_(nmax);
                limit_left -= nmax;
                stack.m_41769_(nmax);
                this.m_6836_(sno, stack);
            }
            if (only_fillup) {
                return Inventories.checked(mvstack);
            }
            if (num_matches > 0 && (force_group_stacks || this.inventory_ instanceof Inventory)) {
                int sno2;
                int i2;
                int insert_start = -1;
                int insert_end = -1;
                for (i2 = 1; i2 < this.size_ - 1; ++i2) {
                    int n = sno2 = reverse ? this.size_ - 1 - i2 : i2;
                    if (insert_start < 0) {
                        if (!matches[sno2]) continue;
                        insert_start = sno2;
                        continue;
                    }
                    if (!matches[sno2]) continue;
                    insert_end = sno2;
                }
                for (i2 = insert_start; i2 < insert_end; ++i2) {
                    int n = sno2 = reverse ? this.size_ - 1 - i2 : i2;
                    if (!empties[sno2] || !this.m_7013_(sno2, mvstack)) continue;
                    int nmax2 = Math.min(limit_left, mvstack.m_41613_());
                    ItemStack moved = mvstack.m_41777_();
                    moved.m_41764_(nmax2);
                    mvstack.m_41774_(nmax2);
                    this.m_6836_(sno2, moved);
                    return Inventories.checked(mvstack);
                }
                for (i = 1; i < this.size_ - 1; ++i) {
                    int ii;
                    int n = sno = reverse ? this.size_ - 1 - i : i;
                    if (!matches[sno]) continue;
                    int n2 = empties[sno - 1] ? sno - 1 : (ii = empties[sno + 1] ? sno + 1 : -1);
                    if (ii < 0 || !this.m_7013_(ii, mvstack)) continue;
                    nmax = Math.min(limit_left, mvstack.m_41613_());
                    ItemStack moved = mvstack.m_41777_();
                    moved.m_41764_(nmax);
                    mvstack.m_41774_(nmax);
                    this.m_6836_(ii, moved);
                    return Inventories.checked(mvstack);
                }
            }
            for (i = 0; i < this.size_; ++i) {
                int n = sno = reverse ? this.size_ - 1 - i : i;
                if (!empties[sno] || !this.m_7013_(sno, mvstack)) continue;
                int nmax3 = Math.min(limit_left, mvstack.m_41613_());
                ItemStack placed = mvstack.m_41777_();
                placed.m_41764_(nmax3);
                mvstack.m_41774_(nmax3);
                this.m_6836_(sno, placed);
                return Inventories.checked(mvstack);
            }
            return Inventories.checked(mvstack);
        }

        public ItemStack insert(ItemStack input_stack, boolean simulate) {
            if (input_stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (!simulate) {
                return this.insert(input_stack);
            }
            input_stack = input_stack.m_41777_();
            for (ItemStack stack : this) {
                if (stack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                int nleft = stack.m_41613_() - stack.m_41741_();
                if (nleft <= 0 || !Inventories.isItemStackableOn(stack, input_stack)) continue;
                if (nleft >= input_stack.m_41613_()) {
                    return ItemStack.f_41583_;
                }
                input_stack.m_41774_(nleft);
            }
            return input_stack;
        }

        public ItemStack insert(ItemStack stack_to_move) {
            return this.insert(stack_to_move, false, 0, false, true);
        }

        public ItemStack insert(int index, ItemStack stack_to_move) {
            if (stack_to_move.m_41619_()) {
                return stack_to_move;
            }
            ItemStack stack = this.m_8020_(index);
            int limit = Math.min(this.m_6893_(), stack.m_41741_());
            if (stack.m_41619_()) {
                this.m_6836_(index, stack_to_move.m_41777_());
                return ItemStack.f_41583_;
            }
            if (stack.m_41613_() >= limit || !Inventories.areItemStacksIdentical(stack, stack_to_move)) {
                return stack_to_move;
            }
            int amount = Math.min(limit - stack.m_41613_(), stack_to_move.m_41613_());
            ItemStack remaining = stack_to_move.m_41777_();
            remaining.m_41774_(amount);
            stack.m_41769_(amount);
            return remaining.m_41619_() ? ItemStack.f_41583_ : remaining;
        }

        public ItemStack extract(int amount) {
            return this.extract(amount, false);
        }

        public ItemStack extract(int amount, boolean random) {
            return this.extract(amount, false, false);
        }

        public ItemStack extract(int amount, boolean random, boolean simulate) {
            ItemStack out_stack = ItemStack.f_41583_;
            int offset = random ? (int)(Math.random() * (double)this.size_) : 0;
            for (int k = 0; k < this.size_; ++k) {
                int i = (offset + k) % this.size_;
                ItemStack stack = this.m_8020_(i);
                if (stack.m_41619_()) continue;
                if (out_stack.m_41619_()) {
                    if (stack.m_41613_() < amount) {
                        out_stack = stack;
                        if (!simulate) {
                            this.m_6836_(i, ItemStack.f_41583_);
                        }
                        if (!out_stack.m_41753_()) break;
                        amount -= out_stack.m_41613_();
                        continue;
                    }
                    if (!simulate) {
                        out_stack = stack.m_41620_(amount);
                        break;
                    }
                    out_stack = stack.m_41777_();
                    out_stack.m_41764_(amount);
                    break;
                }
                if (!Inventories.areItemStacksIdentical(stack, out_stack)) continue;
                if (stack.m_41613_() <= amount) {
                    out_stack.m_41769_(stack.m_41613_());
                    amount -= stack.m_41613_();
                    if (simulate) continue;
                    this.m_6836_(i, ItemStack.f_41583_);
                    continue;
                }
                out_stack.m_41769_(amount);
                if (simulate) break;
                stack.m_41774_(amount);
                if (!stack.m_41619_()) break;
                this.m_6836_(i, ItemStack.f_41583_);
                break;
            }
            if (!out_stack.m_41619_() && !simulate) {
                this.m_6596_();
            }
            return out_stack;
        }

        public ItemStack extract(ItemStack request_stack) {
            return this.extract(request_stack, false);
        }

        public ItemStack extract(ItemStack request_stack, boolean simulate) {
            ItemStack stack;
            if (request_stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            ArrayList<ItemStack> matches = new ArrayList<ItemStack>();
            for (int i = 0; i < this.size_; ++i) {
                stack = this.m_8020_(i);
                if (stack.m_41619_() || !Inventories.areItemStacksIdentical(stack, request_stack)) continue;
                if (stack.m_41782_()) {
                    CompoundTag nbt = stack.m_41784_();
                    int n = nbt.m_128440_();
                    if (n > 0 && nbt.m_128441_("Damage")) {
                        --n;
                    }
                    if (n > 0) continue;
                }
                matches.add(stack);
            }
            matches.sort(Comparator.comparingInt(ItemStack::m_41613_));
            if (matches.isEmpty()) {
                return ItemStack.f_41583_;
            }
            if (!simulate) {
                ItemStack stack2;
                int n_left = request_stack.m_41613_();
                ItemStack fetched_stack = ((ItemStack)matches.get(0)).m_41620_(n_left);
                n_left -= fetched_stack.m_41613_();
                for (int i = 1; i < matches.size() && n_left > 0; n_left -= stack2.m_41613_(), ++i) {
                    stack2 = ((ItemStack)matches.get(i)).m_41620_(n_left);
                    fetched_stack.m_41769_(stack2.m_41613_());
                }
                return Inventories.checked(fetched_stack);
            }
            int amount = 0;
            for (ItemStack match : matches) {
                amount += match.m_41613_();
            }
            if (amount == 0) {
                return ItemStack.f_41583_;
            }
            stack = request_stack.m_41777_();
            if (amount < stack.m_41613_()) {
                stack.m_41764_(amount);
            }
            return stack;
        }

        public boolean move(int index, InventoryRange target_range, boolean all_identical_stacks, boolean only_fillup, boolean reverse, boolean force_group_stacks) {
            ItemStack source_stack = this.m_8020_(index);
            if (source_stack.m_41619_()) {
                return false;
            }
            if (!all_identical_stacks) {
                ItemStack remaining = target_range.insert(source_stack, only_fillup, 0, reverse, force_group_stacks);
                this.m_6836_(index, remaining);
                return remaining.m_41613_() != source_stack.m_41613_();
            }
            ItemStack remaining = source_stack.m_41777_();
            this.m_6836_(index, ItemStack.f_41583_);
            ItemStack ref_stack = remaining.m_41777_();
            ref_stack.m_41764_(ref_stack.m_41741_());
            for (int i = this.size_; i > 0 && !remaining.m_41619_() && (remaining = target_range.insert(remaining, only_fillup, 0, reverse, force_group_stacks)).m_41619_(); --i) {
                remaining = this.extract(ref_stack);
            }
            if (!remaining.m_41619_()) {
                this.m_6836_(index, remaining);
            }
            return remaining.m_41613_() != source_stack.m_41613_();
        }

        public boolean move(int index, InventoryRange target_range) {
            return this.move(index, target_range, false, false, false, true);
        }

        public boolean move(InventoryRange target_range, boolean only_fillup, boolean reverse, boolean force_group_stacks) {
            boolean changed = false;
            for (int i = 0; i < this.size_; ++i) {
                changed |= this.move(i, target_range, false, only_fillup, reverse, force_group_stacks);
            }
            return changed;
        }

        public boolean move(InventoryRange target_range, boolean only_fillup) {
            return this.move(target_range, only_fillup, false, true);
        }

        public boolean move(InventoryRange target_range) {
            return this.move(target_range, false, false, true);
        }

        public static class InventoryRangeIterator
        implements Iterator<ItemStack> {
            private final InventoryRange parent_;
            private int index = 0;

            public InventoryRangeIterator(InventoryRange range) {
                this.parent_ = range;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.parent_.size_;
            }

            @Override
            public ItemStack next() {
                if (this.index >= this.parent_.size_) {
                    throw new NoSuchElementException();
                }
                return this.parent_.m_8020_(this.index++);
            }
        }
    }
}

