/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.redstonepen.libmc.Auxiliaries;

public class BasicButton {

    public static class BasicButtonBlock
    extends ButtonBlock {
        public final Config config;

        public BasicButtonBlock(Config conf, BlockBehaviour.Properties properties) {
            super(properties, BlockSetType.f_271100_, conf.active_time(), true);
            this.config = conf;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
            Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult bhr) {
            if (((Boolean)state.m_61143_((Property)f_51045_)).booleanValue()) {
                return InteractionResult.CONSUME;
            }
            this.m_51116_(state, world, pos);
            this.m_51067_(player, (LevelAccessor)world, pos, true);
            world.m_142346_((Entity)player, GameEvent.f_223702_, pos);
            if (world.f_46443_) {
                BasicButtonBlock.makeParticle(state, (LevelAccessor)world, pos, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }

        protected void m_51067_(@Nullable Player player, LevelAccessor world, BlockPos pos, boolean on) {
            world.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, on ? this.config.sound_pitch_powered() : this.config.sound_pitch_unpowered());
        }

        private static void makeParticle(BlockState state, LevelAccessor world, BlockPos pos, float f) {
            for (int i = 0; i < 3; ++i) {
                Vec3 vpos = Vec3.m_82512_((Vec3i)pos).m_82549_(Vec3.m_82539_((Vec3i)((Direction)state.m_61143_((Property)f_54117_)).m_122424_().m_122436_()).m_82490_(0.1)).m_82549_(Vec3.m_82528_((Vec3i)LeverBlock.m_53200_((BlockState)state).m_122424_().m_122436_()).m_82490_(0.4));
                world.m_7106_((ParticleOptions)new DustParticleOptions(DustParticleOptions.f_175788_, f), vpos.m_7096_(), vpos.m_7098_(), vpos.m_7094_(), 0.0, 0.0, 0.0);
            }
        }

        public record Config(float sound_pitch_unpowered, float sound_pitch_powered, int active_time) {
        }
    }
}

