/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class MultiblockBEType<T extends BlockEntity>
implements BiFunction<BlockPos, BlockState, T> {
    private final RegistryObject<BlockEntityType<T>> master;
    private final RegistryObject<BlockEntityType<T>> dummy;
    private final Predicate<BlockState> isMaster;

    public MultiblockBEType(String name, DeferredRegister<BlockEntityType<?>> register, BEWithTypeConstructor<T> make, Supplier<? extends Block> block, Predicate<BlockState> isMaster) {
        this.isMaster = isMaster;
        this.master = register.register(name + "_master", MultiblockBEType.makeType(make, block));
        this.dummy = register.register(name + "_dummy", MultiblockBEType.makeType(make, block));
    }

    @Override
    @Nullable
    public T apply(BlockPos pos, BlockState state) {
        if (this.isMaster.test(state)) {
            return (T)((BlockEntityType)this.master.get()).m_155264_(pos, state);
        }
        return (T)((BlockEntityType)this.dummy.get()).m_155264_(pos, state);
    }

    public static <T extends BlockEntity> Supplier<BlockEntityType<T>> makeType(BEWithTypeConstructor<T> create, Supplier<? extends Block> valid) {
        return () -> {
            MutableObject typeMutable = new MutableObject();
            BlockEntityType type = new BlockEntityType((arg_0, arg_1) -> MultiblockBEType.lambda$makeType$0(create, (Mutable)typeMutable, arg_0, arg_1), (Set)ImmutableSet.of((Object)((Block)valid.get())), null);
            typeMutable.setValue((Object)type);
            return type;
        };
    }

    public BlockEntityType<T> master() {
        return (BlockEntityType)this.master.get();
    }

    public BlockEntityType<T> dummy() {
        return (BlockEntityType)this.dummy.get();
    }

    public RegistryObject<BlockEntityType<T>> dummyHolder() {
        return this.dummy;
    }

    public RegistryObject<BlockEntityType<T>> masterHolder() {
        return this.master;
    }

    private static /* synthetic */ BlockEntity lambda$makeType$0(BEWithTypeConstructor create, Mutable typeMutable, BlockPos pos, BlockState state) {
        return create.create((BlockEntityType)typeMutable.getValue(), pos, state);
    }

    public static interface BEWithTypeConstructor<T extends BlockEntity> {
        public T create(BlockEntityType<T> var1, BlockPos var2, BlockState var3);
    }
}

