/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.minersdelight.repack.registrate.providers;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.sammy.minersdelight.repack.registrate.AbstractRegistrate;
import com.sammy.minersdelight.repack.registrate.providers.ProviderType;
import com.sammy.minersdelight.repack.registrate.providers.RegistrateProvider;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistrateAdvancementProvider
implements RegistrateProvider,
Consumer<Advancement> {
    private static final Logger log = LogManager.getLogger(RegistrateAdvancementProvider.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final AbstractRegistrate<?> owner;
    private final PackOutput packOutput;
    private final CompletableFuture<HolderLookup.Provider> registriesLookup;
    private final List<CompletableFuture<?>> advancementsToSave = Lists.newArrayList();
    @Nullable
    private CachedOutput cache;
    private Set<ResourceLocation> seenAdvancements = new HashSet<ResourceLocation>();

    public RegistrateAdvancementProvider(AbstractRegistrate<?> owner, PackOutput packOutputIn, CompletableFuture<HolderLookup.Provider> registriesLookupIn) {
        this.owner = owner;
        this.packOutput = packOutputIn;
        this.registriesLookup = registriesLookupIn;
    }

    @Override
    public LogicalSide getSide() {
        return LogicalSide.SERVER;
    }

    public MutableComponent title(String category, String name, String title) {
        return this.owner.addLang("advancements", new ResourceLocation(category, name), "title", title);
    }

    public MutableComponent desc(String category, String name, String desc) {
        return this.owner.addLang("advancements", new ResourceLocation(category, name), "description", desc);
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        return this.registriesLookup.thenCompose(lookup -> {
            this.advancementsToSave.clear();
            try {
                this.cache = cache;
                this.seenAdvancements.clear();
                this.owner.genData(ProviderType.ADVANCEMENT, this);
            }
            finally {
                this.cache = null;
            }
            return CompletableFuture.allOf((CompletableFuture[])this.advancementsToSave.toArray(CompletableFuture[]::new));
        });
    }

    @Override
    public void accept(@Nullable Advancement t) {
        CachedOutput cache = this.cache;
        if (cache == null) {
            throw new IllegalStateException("Cannot accept advancements outside of act");
        }
        Objects.requireNonNull(t, "Cannot accept a null advancement");
        Path path = this.packOutput.m_245114_();
        if (!this.seenAdvancements.add(t.m_138327_())) {
            throw new IllegalStateException("Duplicate advancement " + t.m_138327_());
        }
        Path path1 = RegistrateAdvancementProvider.getPath(path, t);
        this.advancementsToSave.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)t.m_138313_().m_138400_(), (Path)path1));
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.m_138327_().m_135827_() + "/advancements/" + advancementIn.m_138327_().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Advancements";
    }
}

