/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SkullEntitySpawnPacket {
    private ClientLevel client;
    private Entity entity;
    private UUID entityUUID;
    private int entityID;
    private double x;
    private double y;
    private double z;
    private float pitch;
    private float yaw;

    public SkullEntitySpawnPacket(FriendlyByteBuf buf) {
        Minecraft minecraftClient = Minecraft.m_91087_();
        this.client = minecraftClient.f_91073_;
        this.entity = minecraftClient.f_91073_.m_6815_(buf.readInt());
        this.entityUUID = buf.m_130259_();
        this.entityID = buf.m_130242_();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.pitch = buf.readByte();
        this.yaw = buf.readByte();
    }

    public SkullEntitySpawnPacket(Entity entity, UUID uuid, int entityID, double x, double y, double z, float pitch, float yaw) {
        this.entity = entity;
        this.entityUUID = uuid;
        this.entityID = entityID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(BuiltInRegistries.f_256780_.m_7447_((Object)this.entity.m_6095_()));
        buf.m_130077_(this.entity.m_20148_());
        buf.m_130130_(this.entity.m_19879_());
        buf.writeDouble(this.entity.m_20185_());
        buf.writeDouble(this.entity.m_20186_());
        buf.writeDouble(this.entity.m_20189_());
        buf.writeByte(Mth.m_14143_((float)(this.entity.m_146909_() * 256.0f / 360.0f)));
        buf.writeByte(Mth.m_14143_((float)(this.entity.m_146908_() * 256.0f / 360.0f)));
        buf.writeFloat(this.entity.m_146909_());
        buf.writeFloat(this.entity.m_146908_());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (this.entity != null) {
                this.entity.m_20248_(this.x, this.y, this.z);
                this.entity.m_217006_(this.x, this.y, this.z);
                this.entity.m_146926_(this.pitch);
                this.entity.m_146922_(this.yaw);
                this.entity.m_20234_(this.entityID);
                this.entity.m_20084_(this.entityUUID);
                world.m_104627_(this.entityID, this.entity);
            }
        }));
        context.get().setPacketHandled(true);
    }
}

