/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.entities;

import com.lion.graveyard.entities.HostileGraveyardEntity;
import com.lion.graveyard.entities.ai.goals.NightmareMeleeAttackGoal;
import com.lion.graveyard.init.TGAdvancements;
import com.lion.graveyard.init.TGSounds;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NightmareEntity
extends HostileGraveyardEntity
implements GeoEntity,
NeutralMob {
    private AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation DEATH_ANIMATION = RawAnimation.begin().then("death", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation IDLE_ANIMATION = RawAnimation.begin().then("idle", Animation.LoopType.LOOP);
    private final RawAnimation WALK_ANIMATION = RawAnimation.begin().then("walk", Animation.LoopType.LOOP);
    private final RawAnimation ATTACK_ANIMATION = RawAnimation.begin().then("attack", Animation.LoopType.LOOP);
    protected static final byte ANIMATION_IDLE = 0;
    protected static final byte ANIMATION_WALK = 1;
    protected static final byte ANIMATION_DEATH = 3;
    protected static final byte ANIMATION_ATTACK = 5;
    protected static final EntityDataAccessor<Byte> ANIMATION = SynchedEntityData.m_135353_(NightmareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ATTACK_ANIM_TIMER = SynchedEntityData.m_135353_(NightmareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final int ATTACK_ANIMATION_DURATION = 20;
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.m_135353_(NightmareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PROVOKED = SynchedEntityData.m_135353_(NightmareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UniformInt ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private UUID target;
    private int angerTime;
    private int ageWhenTargetSet;

    public NightmareEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world, "nightmare");
        this.m_274367_(1.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGRY, (Object)false);
        this.f_19804_.m_135372_(PROVOKED, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)0);
        this.f_19804_.m_135372_(ATTACK_ANIM_TIMER, (Object)0);
    }

    public int getAnimationState() {
        return ((Byte)this.f_19804_.m_135370_(ANIMATION)).byteValue();
    }

    public void setState(byte time) {
        this.f_19804_.m_135381_(ANIMATION, (Object)time);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ChasePlayerGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new NightmareMeleeAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new TeleportTowardsPlayerGoal(this, arg_0 -> ((NightmareEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    protected void m_8024_() {
        float f;
        if (this.getAttackAnimTimer() == 20) {
            this.setAnimation((byte)5);
        }
        if (this.getAttackAnimTimer() > 0) {
            int animTimer = this.getAttackAnimTimer() - 1;
            this.setAttackAnimTimer(animTimer);
        }
        if (this.m_20193_().m_46461_() && this.f_19797_ >= this.ageWhenTargetSet + 600 && (f = this.m_213856_()) > 0.5f && this.m_20193_().m_45527_(this.m_20183_()) && this.f_19796_.m_188501_() * 30.0f < (f - 0.4f) * 2.0f) {
            this.m_6710_(null);
            this.teleportRandomly();
        }
        super.m_8024_();
    }

    @Override
    public void m_8107_() {
        this.f_20899_ = false;
        if (!this.m_20193_().f_46443_) {
            if (this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) >= 1024.0) {
                this.m_21662_();
            }
            this.m_21666_((ServerLevel)this.m_20193_(), true);
        }
        super.m_8107_();
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.m_21678_(nbt);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.m_147285_(this.m_20193_(), nbt);
    }

    public static AttributeSupplier.Builder createNightmareAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 45.0).m_22268_(Attributes.f_22284_, 3.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22279_, 0.19).m_22268_(Attributes.f_22277_, 64.0);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 28 && !this.m_20193_().m_5776_()) {
            this.m_20193_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public byte getAnimation() {
        return (Byte)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public int getAttackAnimTimer() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_ANIM_TIMER);
    }

    public void setAttackAnimTimer(int time) {
        this.f_19804_.m_135381_(ATTACK_ANIM_TIMER, (Object)time);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, event -> {
            if (this.m_21224_()) {
                event.getController().setAnimation(this.DEATH_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 5 && this.getAttackAnimTimer() == 19 && this.m_5912_() && !this.m_21224_() && !((double)this.m_21223_() < 0.01)) {
                this.setAttackAnimTimer(18);
                event.getController().setAnimation(this.ATTACK_ANIMATION);
                return PlayState.CONTINUE;
            }
            if ((this.getAnimationState() == 1 || event.isMoving()) && this.getAttackAnimTimer() <= 0) {
                event.getController().setAnimation(this.WALK_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 0 && this.getAttackAnimTimer() <= 0 && !event.isMoving()) {
                event.getController().setAnimation(this.IDLE_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 0 && this.getAttackAnimTimer() > 0) {
                this.setAnimation((byte)5);
                return PlayState.STOP;
            }
            if (this.getAttackAnimTimer() <= 0 && !this.m_21224_() && !((double)this.m_21223_() < 0.01)) {
                this.setAnimation((byte)0);
                return PlayState.STOP;
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void m_8032_() {
        this.m_5496_(TGSounds.NIGHTMARE_AMBIENT.get(), 1.0f, -10.0f);
    }

    protected void m_6677_(DamageSource source) {
        this.m_5496_(TGSounds.NIGHTMARE_HURT.get(), 1.0f, -10.0f);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.m_5496_(TGSounds.NIGHTMARE_DEATH.get(), 1.0f, -10.0f);
    }

    boolean isPlayerStaring(Player player) {
        ItemStack itemStack = (ItemStack)player.m_150109_().f_35975_.get(3);
        if (itemStack.m_150930_(Blocks.f_50143_.m_5456_())) {
            return false;
        }
        Vec3 vec3d = player.m_20252_(1.0f).m_82541_();
        Vec3 vec3d2 = new Vec3(this.m_20185_() - player.m_20185_(), this.m_20188_() - player.m_20188_(), this.m_20189_() - player.m_20189_());
        double d = vec3d2.m_82553_();
        double e = vec3d.m_82526_(vec3d2 = vec3d2.m_82541_());
        if (e > 1.0 - 0.025 / d) {
            return player.m_142582_((Entity)this);
        }
        return false;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 2.55f;
    }

    boolean teleportTo(Entity entity) {
        Vec3 vec3d = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20227_(0.5) - entity.m_20188_(), this.m_20189_() - entity.m_20189_());
        vec3d = vec3d.m_82541_();
        double e = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 2.0 - vec3d.f_82479_ * 16.0;
        double f = this.m_20186_() + (double)(this.f_19796_.m_188503_(4) - 2) - vec3d.f_82480_ * 16.0;
        double g = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 2.0 - vec3d.f_82481_ * 16.0;
        return this.teleportTo(e, f, g);
    }

    private boolean teleportTo(double x, double y, double z) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(x, y, z);
        while (mutable.m_123342_() > this.m_20193_().m_141937_() && !this.m_20193_().m_8055_((BlockPos)mutable).m_280555_()) {
            mutable.m_122173_(Direction.DOWN);
        }
        BlockState blockState = this.m_20193_().m_8055_((BlockPos)mutable);
        boolean bl = blockState.m_280555_();
        boolean bl2 = blockState.m_60819_().m_205070_(FluidTags.f_13131_);
        if (bl && !bl2) {
            boolean bl3 = this.m_20984_(x, y, z, false);
            if (bl3 && !this.m_20067_()) {
                this.m_5496_(SoundEvents.f_11852_, 1.0f, -10.0f);
            }
            return bl3;
        }
        return false;
    }

    protected boolean teleportRandomly() {
        if (!this.m_20193_().m_5776_() && this.m_6084_()) {
            double d = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            double e = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
            double f = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            return this.teleportTo(d, e, f);
        }
        return false;
    }

    public boolean m_21660_() {
        return (Boolean)this.f_19804_.m_135370_(ANGRY);
    }

    public void m_7870_(int ticks) {
        this.angerTime = ticks;
    }

    public int m_6784_() {
        return this.angerTime;
    }

    public void setProvoked() {
        this.f_19804_.m_135381_(PROVOKED, (Object)true);
    }

    @Nullable
    public UUID m_6120_() {
        return this.target;
    }

    public void m_6925_(@Nullable UUID uuid) {
        this.target = uuid;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_6710_(@Nullable LivingEntity target) {
        super.m_6710_(target);
        if (target == null) {
            this.ageWhenTargetSet = 0;
            this.f_19804_.m_135381_(ANGRY, (Object)false);
            this.m_7870_(0);
            this.f_19804_.m_135381_(PROVOKED, (Object)false);
        } else {
            this.ageWhenTargetSet = this.f_19797_;
            this.f_19804_.m_135381_(ANGRY, (Object)true);
        }
    }

    protected void m_21268_(@Nullable LivingEntity adversary) {
        ServerPlayer player;
        if (adversary instanceof ServerPlayer && (player = (ServerPlayer)adversary).m_21023_(MobEffects.f_19610_)) {
            TGAdvancements.KILL_WHILE_BLINDED.trigger(player);
        }
        super.m_21268_(adversary);
    }

    static class ChasePlayerGoal
    extends Goal {
        private final NightmareEntity nightmare;
        @Nullable
        private LivingEntity target;

        public ChasePlayerGoal(NightmareEntity nightmare) {
            this.nightmare = nightmare;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.target = this.nightmare.m_5448_();
            if (!(this.target instanceof Player)) {
                return false;
            }
            double d = this.target.m_20280_((Entity)this.nightmare);
            return d > 256.0 ? false : this.nightmare.isPlayerStaring((Player)this.target);
        }

        public void m_8056_() {
            this.nightmare.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.nightmare.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
        }
    }

    static class TeleportTowardsPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final NightmareEntity nightmare;
        @Nullable
        private Player targetPlayer;
        private int lookAtPlayerWarmup;
        private int ticksSinceUnseenTeleport;
        private final TargetingConditions staringPlayerPredicate;
        private final TargetingConditions validTargetPredicate = TargetingConditions.m_148352_().m_148355_();

        public TeleportTowardsPlayerGoal(NightmareEntity nightmare, @Nullable Predicate<LivingEntity> targetPredicate) {
            super((Mob)nightmare, Player.class, 10, false, false, targetPredicate);
            this.nightmare = nightmare;
            this.staringPlayerPredicate = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(playerEntity -> nightmare.isPlayerStaring((Player)playerEntity));
        }

        public boolean m_8036_() {
            this.targetPlayer = this.nightmare.m_20193_().m_45946_(this.staringPlayerPredicate, (LivingEntity)this.nightmare);
            return this.targetPlayer != null;
        }

        public void m_8056_() {
            this.lookAtPlayerWarmup = this.m_183277_(5);
            this.ticksSinceUnseenTeleport = 0;
            this.nightmare.setProvoked();
        }

        public void m_8041_() {
            this.targetPlayer = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.targetPlayer != null) {
                if (!this.nightmare.isPlayerStaring(this.targetPlayer)) {
                    return false;
                }
                this.nightmare.m_21391_((Entity)this.targetPlayer, 10.0f, 10.0f);
                return true;
            }
            return this.f_26050_ != null && this.validTargetPredicate.m_26885_((LivingEntity)this.nightmare, this.f_26050_) ? true : super.m_8045_();
        }

        public void m_8037_() {
            if (this.nightmare.m_5448_() == null) {
                super.m_26070_((LivingEntity)null);
            }
            if (this.targetPlayer != null) {
                if (--this.lookAtPlayerWarmup <= 0) {
                    this.f_26050_ = this.targetPlayer;
                    this.targetPlayer = null;
                    super.m_8056_();
                }
            } else {
                if (this.f_26050_ != null && !this.nightmare.m_20159_()) {
                    if (this.nightmare.isPlayerStaring((Player)this.f_26050_)) {
                        if (this.f_26050_.m_20280_((Entity)this.nightmare) <= 384.0 && this.f_26050_ != null && this.f_26050_.m_20280_((Entity)this.nightmare) > 24.0) {
                            this.f_26050_.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100));
                            this.nightmare.teleportTo((Entity)this.f_26050_);
                        }
                        this.ticksSinceUnseenTeleport = 0;
                    } else if (this.f_26050_.m_20280_((Entity)this.nightmare) > 256.0 && this.ticksSinceUnseenTeleport++ >= this.m_183277_(80) && this.nightmare.teleportTo((Entity)this.f_26050_)) {
                        this.ticksSinceUnseenTeleport = 0;
                    }
                }
                super.m_8037_();
            }
        }
    }
}

