/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox.client;

import com.mojang.blaze3d.vertex.PoseStack;
import commoble.hyperbox.blocks.HyperboxBlockEntity;
import commoble.hyperbox.client.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class HyperboxBlockEntityRenderer
implements BlockEntityRenderer<HyperboxBlockEntity> {
    public HyperboxBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(HyperboxBlockEntity hyperbox, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        Component customName = hyperbox.m_7770_();
        if (player != null && customName != null && HyperboxBlockEntityRenderer.shouldRenderNameplate(hyperbox, player)) {
            HyperboxBlockEntityRenderer.renderName(mc, hyperbox, customName, matrixStackIn, bufferIn, combinedLightIn);
        }
    }

    public static boolean shouldRenderNameplate(HyperboxBlockEntity hyperbox, LocalPlayer player) {
        double boxZ;
        double boxY;
        double radius = player.m_6047_() ? (Double)ClientProxy.clientConfig.nameplateSneakingRenderDistance.get() : (Double)ClientProxy.clientConfig.nameplateRenderDistance.get();
        if (radius <= 0.0) {
            return false;
        }
        BlockPos boxPos = hyperbox.m_58899_();
        double boxX = (double)boxPos.m_123341_() + 0.5;
        double distanceSquared = player.m_20275_(boxX, boxY = (double)boxPos.m_123342_() + 0.5, boxZ = (double)boxPos.m_123343_() + 0.5);
        return distanceSquared < radius * radius;
    }

    public static void renderName(Minecraft mc, HyperboxBlockEntity hyperbox, Component displayNameIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Font fontRenderer = mc.f_91062_;
        Quaternionf cameraRotation = mc.m_91290_().m_253208_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_252880_(0.5f, 1.4f, 0.5f);
        matrixStackIn.m_252781_(cameraRotation);
        matrixStackIn.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = matrixStackIn.m_85850_().m_252922_();
        float backgroundOpacity = mc.f_91066_.m_92141_(0.25f);
        int alpha = (int)(backgroundOpacity * 255.0f) << 24;
        float textOffset = -fontRenderer.m_92852_((FormattedText)displayNameIn) / 2;
        bufferIn = Minecraft.m_91087_().m_91269_().m_110109_();
        fontRenderer.m_272077_(displayNameIn, textOffset, 0.0f, 0x20FFFFFF, false, matrix4f, bufferIn, Font.DisplayMode.SEE_THROUGH, alpha, 0xFFFFFF);
        fontRenderer.m_272077_(displayNameIn, textOffset, 0.0f, -1, false, matrix4f, bufferIn, Font.DisplayMode.NORMAL, 0, 0xFFFFFF);
        matrixStackIn.m_85849_();
    }
}

