/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopeedge;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.block.IComplexSlopeSource;
import xfacthd.framedblocks.common.blockentity.doubled.FramedElevatedDoubleSlopeEdgeBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.util.DoubleBlockTopInteractionMode;

public class FramedElevatedDoubleSlopeEdgeBlock
extends AbstractFramedDoubleBlock
implements IComplexSlopeSource {
    public FramedElevatedDoubleSlopeEdgeBlock() {
        super(BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_EDGE);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.SLOPE_TYPE, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ExtPlacementStateBuilder.of(this, ctx).withHorizontalFacingAndSlopeType().build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE && face.m_122434_() == dir.m_122434_()) {
            return (BlockState)state.m_61122_(PropertyHolder.SLOPE_TYPE);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (state.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return Utils.mirrorCornerBlock(state, mirror);
        }
        return Utils.mirrorFaceBlock(state, mirror);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedElevatedDoubleSlopeEdgeBlockEntity(pos, state);
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        if (type == SlopeType.TOP) {
            return DoubleBlockTopInteractionMode.FIRST;
        }
        return DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        boolean ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
        SlopeType oppositeType = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case SlopeType.BOTTOM -> SlopeType.TOP;
            case SlopeType.HORIZONTAL -> SlopeType.HORIZONTAL;
            case SlopeType.TOP -> SlopeType.BOTTOM;
        };
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_ELEVATED_SLOPE_EDGE.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir)).m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)type))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLOPE_EDGE.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir.m_122424_())).m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)oppositeType))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == dir) {
            return SolidityCheck.FIRST;
        }
        SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        Direction dirTwo = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case SlopeType.BOTTOM -> Direction.DOWN;
            case SlopeType.HORIZONTAL -> dir.m_122428_();
            case SlopeType.TOP -> Direction.UP;
        };
        return side == dirTwo ? SolidityCheck.FIRST : SolidityCheck.BOTH;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction dirTwo;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == dir) {
            return CamoGetter.FIRST;
        }
        SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case BOTTOM: {
                Direction direction = Direction.DOWN;
                break;
            }
            case HORIZONTAL: {
                Direction direction = dir.m_122428_();
                break;
            }
            case TOP: {
                Direction direction = dirTwo = Direction.UP;
            }
        }
        if (side == dirTwo) {
            return CamoGetter.FIRST;
        }
        if (side == dirTwo.m_122424_()) {
            if (edge == dir) {
                return CamoGetter.FIRST;
            }
            if (edge == dir.m_122424_()) {
                return CamoGetter.SECOND;
            }
            return CamoGetter.NONE;
        }
        if (side == dir.m_122424_()) {
            if (edge == dirTwo) {
                return CamoGetter.FIRST;
            }
            if (edge == dirTwo.m_122424_()) {
                return CamoGetter.SECOND;
            }
            return CamoGetter.NONE;
        }
        if (edge == dir || edge == dirTwo) {
            return CamoGetter.FIRST;
        }
        return CamoGetter.NONE;
    }

    @Override
    public boolean isHorizontalSlope(BlockState state) {
        return state.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL;
    }

    public static BlockState itemModelSource() {
        return (BlockState)((Block)FBContent.BLOCK_FRAMED_ELEVATED_DOUBLE_SLOPE_EDGE.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

