/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.fullData;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.DataCorruptedException;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataOutputStream;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FullDataPointIdMap {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean RUN_SERIALIZATION_DUPLICATE_VALIDATION = false;
    private static final String BLOCK_STATE_SEPARATOR_STRING = "_DH-BSW_";
    private long pos;
    private final ArrayList<Entry> entryList = new ArrayList();
    private final ConcurrentHashMap<Entry, Integer> idMap = new ConcurrentHashMap();
    private int cachedHashCode = 0;

    public FullDataPointIdMap(long pos) {
        this.pos = pos;
    }

    public IBiomeWrapper getBiomeWrapper(int id) throws IndexOutOfBoundsException {
        return this.getEntry((int)id).biome;
    }

    public IBlockStateWrapper getBlockStateWrapper(int id) throws IndexOutOfBoundsException {
        return this.getEntry((int)id).blockState;
    }

    private Entry getEntry(int id) throws IndexOutOfBoundsException {
        Entry entry;
        try {
            entry = this.entryList.get(id);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("FullData ID Map out of sync for pos: " + this.pos + ". ID: [" + id + "] greater than the number of known ID's: [" + this.entryList.size() + "].");
        }
        return entry;
    }

    public int getMaxValidId() {
        return this.entryList.size() - 1;
    }

    public int size() {
        return this.entryList.size();
    }

    public boolean isEmpty() {
        return this.entryList.isEmpty();
    }

    public long getPos() {
        return this.pos;
    }

    public int addIfNotPresentAndGetId(IBiomeWrapper biome, IBlockStateWrapper blockState) {
        return this.addIfNotPresentAndGetId(Entry.getEntry(biome, blockState));
    }

    private int addIfNotPresentAndGetId(Entry biomeBlockStateEntry) {
        Integer nullableId = this.idMap.get(biomeBlockStateEntry);
        if (nullableId != null) {
            return nullableId;
        }
        return this.idMap.compute(biomeBlockStateEntry, (newBiomeBlockStateEntry, currentId) -> {
            if (currentId != null) {
                return currentId;
            }
            currentId = this.entryList.size();
            this.entryList.add(biomeBlockStateEntry);
            this.cachedHashCode = 0;
            return currentId;
        });
    }

    public void addAll(FullDataPointIdMap inputMap) {
        ArrayList<Entry> entriesToMerge = inputMap.entryList;
        for (int i = 0; i < entriesToMerge.size(); ++i) {
            Entry entity = entriesToMerge.get(i);
            this.add(entity);
        }
    }

    private void add(Entry biomeBlockStateEntry) {
        int id = this.entryList.size();
        this.entryList.add(biomeBlockStateEntry);
        this.idMap.put(biomeBlockStateEntry, id);
        this.cachedHashCode = 0;
    }

    public int[] mergeAndReturnRemappedEntityIds(FullDataPointIdMap inputMap) {
        ArrayList<Entry> entriesToMerge = inputMap.entryList;
        int[] remappedEntryIds = new int[entriesToMerge.size()];
        for (int i = 0; i < entriesToMerge.size(); ++i) {
            int id;
            Entry entity = entriesToMerge.get(i);
            remappedEntryIds[i] = id = this.addIfNotPresentAndGetId(entity);
        }
        return remappedEntryIds;
    }

    public void clear(long pos) {
        this.pos = pos;
        this.entryList.clear();
        this.idMap.clear();
        this.cachedHashCode = 0;
    }

    public void serialize(DhDataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.entryList.size());
        HashMap dataPointEntryBySerialization = new HashMap();
        for (Entry entry : this.entryList) {
            String entryString = entry.serialize();
            outputStream.writeUTF(entryString);
        }
    }

    public static FullDataPointIdMap deserialize(DhDataInputStream inputStream, long pos, ILevelWrapper levelWrapper) throws IOException, InterruptedException, DataCorruptedException {
        int entityCount = inputStream.readInt();
        if (entityCount < 0) {
            throw new DataCorruptedException("FullDataPointIdMap deserialize entry count should have a number greater than or equal to 0, returned value [" + entityCount + "].");
        }
        HashMap dataPointEntryBySerialization = new HashMap();
        FullDataPointIdMap newMap = new FullDataPointIdMap(pos);
        for (int i = 0; i < entityCount; ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException(FullDataPointIdMap.class.getSimpleName() + " task interrupted.");
            }
            String entryString = inputStream.readUTF();
            Entry newEntry = Entry.deserialize(entryString, levelWrapper);
            newMap.entryList.add(newEntry);
        }
        if (newMap.size() != entityCount) {
            LodUtil.assertNotReach("ID maps failed to deserialize for pos: [" + DhSectionPos.toString(pos) + "], incorrect entity count. Expected count [" + entityCount + "], actual count [" + newMap.size() + "]");
        }
        return newMap;
    }

    public boolean equals(Object other) {
        return other == this;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.generateHashCode();
        }
        return this.cachedHashCode;
    }

    private void generateHashCode() {
        int result = DhSectionPos.hashCode(this.pos);
        for (int i = 0; i < this.entryList.size(); ++i) {
            result = 31 * result + this.entryList.hashCode();
        }
        this.cachedHashCode = result;
    }

    private static final class Entry {
        private static final IWrapperFactory WRAPPER_FACTORY = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
        private static final ConcurrentHashMap<IBiomeWrapper, ConcurrentHashMap<IBlockStateWrapper, Entry>> ENTRY_BY_BLOCKSTATE_BY_BIOMEWRAPPER = new ConcurrentHashMap();
        public final IBiomeWrapper biome;
        public final IBlockStateWrapper blockState;
        private int hashCode = 0;
        private boolean hashGenerated = false;
        private String serialString = null;

        public static Entry getEntry(IBiomeWrapper biome, IBlockStateWrapper blockState) {
            Entry entry;
            ConcurrentHashMap<IBlockStateWrapper, Entry> entryByBlockState = ENTRY_BY_BLOCKSTATE_BY_BIOMEWRAPPER.get(biome);
            if (entryByBlockState != null && (entry = entryByBlockState.get(blockState)) != null) {
                return entry;
            }
            return ENTRY_BY_BLOCKSTATE_BY_BIOMEWRAPPER.computeIfAbsent(biome, newBiome -> new ConcurrentHashMap()).computeIfAbsent(blockState, newBlockState -> new Entry(biome, blockState));
        }

        private Entry(IBiomeWrapper biome, IBlockStateWrapper blockState) {
            this.biome = biome;
            this.blockState = blockState;
        }

        public int hashCode() {
            if (!this.hashGenerated) {
                this.hashCode = Entry.generateHashCode(this);
                this.hashGenerated = true;
            }
            return this.hashCode;
        }

        private static int generateHashCode(Entry entry) {
            return Entry.generateHashCode(entry.biome, entry.blockState);
        }

        private static int generateHashCode(IBiomeWrapper biome, IBlockStateWrapper blockState) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (biome == null ? 0 : biome.hashCode());
            result = 31 * result + (blockState == null ? 0 : blockState.hashCode());
            return result;
        }

        public boolean equals(Object otherObj) {
            if (otherObj == this) {
                return true;
            }
            if (!(otherObj instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)otherObj;
            return other.biome.getSerialString().equals(this.biome.getSerialString()) && other.blockState.getSerialString().equals(this.blockState.getSerialString());
        }

        public String toString() {
            return this.serialize();
        }

        public String serialize() {
            if (this.serialString == null) {
                this.serialString = this.biome.getSerialString() + FullDataPointIdMap.BLOCK_STATE_SEPARATOR_STRING + this.blockState.getSerialString();
            }
            return this.serialString;
        }

        public static Entry deserialize(String str, ILevelWrapper levelWrapper) throws DataCorruptedException {
            int separatorIndex = str.indexOf(FullDataPointIdMap.BLOCK_STATE_SEPARATOR_STRING);
            if (separatorIndex == -1) {
                throw new DataCorruptedException("Failed to deserialize BiomeBlockStateEntry [" + str + "], unable to find separator.");
            }
            IBiomeWrapper biome = WRAPPER_FACTORY.deserializeBiomeWrapperOrGetDefault(str.substring(0, separatorIndex), levelWrapper);
            IBlockStateWrapper blockState = WRAPPER_FACTORY.deserializeBlockStateWrapperOrGetDefault(str.substring(separatorIndex + FullDataPointIdMap.BLOCK_STATE_SEPARATOR_STRING.length()), levelWrapper);
            return Entry.getEntry(biome, blockState);
        }
    }
}

