/*
 * Decompiled with CFR 0.152.
 */
package net.glad0s.bobberdetector.ponder;

import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.glad0s.bobberdetector.content.entity.BobberDetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BobberPonder {
    public static void bobberBasic(SceneBuilder sceneBuilder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(sceneBuilder);
        scene.title("detector", "Automatic Fishing");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        scene.world().showSection(util.select().layer(1), Direction.UP);
        scene.world().showSection(util.select().layer(2), Direction.UP);
        BlockPos deployerPos = util.grid().at(3, 2, 6);
        BlockPos detectorPos = util.grid().at(6, 2, 3);
        BlockPos bobberPos = util.grid().at(3, 1, 3);
        BlockPos link1 = util.grid().at(6, 1, 3);
        BlockPos link2 = util.grid().at(1, 2, 0);
        BlockPos redstoneTorch = util.grid().at(1, 1, 1);
        BlockPos redstoneRepeater = util.grid().at(1, 1, 2);
        BlockPos searchArea1 = util.grid().at(5, -2, 1);
        BlockPos searchArea2 = util.grid().at(0, 2, 4);
        BlockPos smallCogwheel = util.grid().at(2, 0, 7);
        Selection deployerSelection = util.select().position(deployerPos);
        Selection detectorSelection = util.select().position(detectorPos);
        Selection link1Selection = util.select().position(link1);
        Selection link2Selection = util.select().position(link2);
        Selection redstoneTorchSelection = util.select().position(redstoneTorch);
        Selection redstoneRepeaterSelection = util.select().position(redstoneRepeater);
        Selection searchArea1Selection = util.select().position(searchArea1);
        Selection searchArea2Selection = util.select().position(searchArea2);
        Selection smallCogwheelSelection = util.select().position(smallCogwheel);
        Vec3 bobberParticles = util.vector().topOf(3, 1, 3);
        Vec3 itemMovement = util.vector().of(-0.2, 0.6, 0.0);
        scene.idle(30);
        scene.world().setKineticSpeed(smallCogwheelSelection, 64.0f);
        ElementLink bobber = scene.world().createEntity(w -> {
            FishingHook entity = (FishingHook)EntityType.f_20533_.m_20615_(w);
            Vec3 p = util.vector().topOf(util.grid().at(3, 1, 3));
            entity.m_6034_(p.f_82479_, p.f_82480_, p.f_82481_);
            entity.f_19854_ = p.f_82479_;
            entity.f_19855_ = p.f_82480_;
            entity.f_19856_ = p.f_82481_;
            return entity;
        });
        Class<DeployerBlockEntity> deployerType = DeployerBlockEntity.class;
        Class<BobberDetectorBlockEntity> detectorType = BobberDetectorBlockEntity.class;
        ItemStack fishing_rod = new ItemStack((ItemLike)Items.f_42523_);
        scene.world().modifyBlockEntityNBT(deployerSelection, deployerType, nbt -> nbt.m_128365_("HeldItem", (Tag)fishing_rod.m_41784_()));
        scene.overlay().showText(80).text("Deployers can be given fishing rods to fish for you").placeNearTarget().attachKeyFrame().pointAt(util.vector().topOf(deployerPos));
        scene.idle(30);
        scene.world().moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.effects().emitParticles(bobberParticles, scene.effects().simpleParticleEmitter((ParticleOptions)ParticleTypes.f_123795_, Vec3.f_82478_), 0.2f, 390);
        scene.effects().emitParticles(bobberParticles, scene.effects().simpleParticleEmitter((ParticleOptions)ParticleTypes.f_123769_, Vec3.f_82478_), 0.3f, 390);
        scene.world().modifyBlocks(detectorSelection, s -> {
            s = (BlockState)s.m_61122_((Property)BlockStateProperties.f_61443_);
            return s;
        }, false);
        scene.world().moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(50);
        scene.overlay().showText(80).text("Sadly you wont be able to see the fishing bobber in the water, only the particles").placeNearTarget().attachKeyFrame().pointAt(util.vector().topOf(bobberPos));
        scene.idle(100);
        scene.overlay().showText(80).text("But whenever a bobber is inside it\u00b4s range the bobber detector lights up").placeNearTarget().attachKeyFrame().pointAt(util.vector().topOf(detectorPos));
        AABB box = new AABB(searchArea1).m_82367_(new AABB(searchArea2));
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, Object.class, box, 80);
        scene.idle(140);
        scene.world().setKineticSpeed(smallCogwheelSelection, 128.0f);
        scene.overlay().showText(80).attachKeyFrame().text("When a fish is being caught the detector emits a redstone signal").pointAt(util.vector().topOf(detectorPos)).placeNearTarget();
        scene.idle(100);
        scene.effects().emitParticles(bobberParticles, scene.effects().simpleParticleEmitter((ParticleOptions)ParticleTypes.f_123769_, Vec3.f_82478_), 1.2f, 20);
        scene.effects().emitParticles(bobberParticles, scene.effects().particleEmitterWithinBlockSpace((ParticleOptions)ParticleTypes.f_123769_, Vec3.f_82478_), 0.2f, 20);
        scene.effects().emitParticles(bobberParticles, scene.effects().particleEmitterWithinBlockSpace((ParticleOptions)ParticleTypes.f_123795_, Vec3.f_82478_), 0.2f, 20);
        scene.world().modifyBlocks(detectorSelection, s -> {
            s = (BlockState)s.m_61122_((Property)BlockStateProperties.f_61448_);
            return s;
        }, false);
        scene.world().toggleRedstonePower(redstoneTorchSelection);
        scene.world().toggleRedstonePower(redstoneRepeaterSelection);
        scene.world().toggleRedstonePower(link1Selection);
        scene.world().toggleRedstonePower(link2Selection);
        scene.idle(5);
        scene.world().moveDeployer(deployerPos, 1.0f, 15);
        scene.idle(16);
        scene.world().modifyBlocks(detectorSelection, s -> {
            s = (BlockState)s.m_61122_((Property)BlockStateProperties.f_61443_);
            return s;
        }, false);
        ItemStack stack = new ItemStack((ItemLike)Items.f_42526_, 1);
        scene.world().createItemEntity(bobberParticles, itemMovement, stack);
        scene.world().moveDeployer(deployerPos, -1.0f, 15);
        scene.idle(10);
        scene.world().modifyBlocks(detectorSelection, s -> {
            s = (BlockState)s.m_61122_((Property)BlockStateProperties.f_61448_);
            return s;
        }, false);
        scene.world().toggleRedstonePower(redstoneTorchSelection);
        scene.world().toggleRedstonePower(redstoneRepeaterSelection);
        scene.world().toggleRedstonePower(link1Selection);
        scene.world().toggleRedstonePower(link2Selection);
        scene.idle(50);
        scene.overlay().showText(80).text("You will have to figure out how to pickup the items though").pointAt(util.vector().blockSurface(deployerPos, Direction.WEST)).placeNearTarget();
        scene.idle(80);
    }
}

