/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.mixin;

import javax.annotation.Nullable;
import net.lyof.phantasm.effect.ModEffects;
import net.lyof.phantasm.item.ModItems;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    public abstract boolean m_21023_(MobEffect var1);

    @Shadow
    @Nullable
    public abstract MobEffectInstance m_21124_(MobEffect var1);

    public LivingEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Redirect(method={"eat"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V"))
    public void keepOblifruit(ItemStack instance, int amount) {
        if (instance.m_150930_((Item)ModItems.OBLIFRUIT.get()) && Math.random() < 0.05 && instance.m_41613_() < instance.m_41741_()) {
            instance.m_41769_(1);
            return;
        }
        if (instance.m_150930_((Item)ModItems.OBLIFRUIT.get()) && Math.random() < 0.4) {
            return;
        }
        instance.m_41774_(1);
    }

    @Inject(method={"getDamageAfterMagicAbsorb"}, at={@At(value="RETURN")}, cancellable=true)
    public void applyVulnerability(DamageSource source, float amount, CallbackInfoReturnable<Float> cir) {
        if (!this.m_21023_((MobEffect)ModEffects.CORROSION.get())) {
            return;
        }
        int i = this.m_21124_((MobEffect)ModEffects.CORROSION.get()).m_19564_() + 1;
        cir.setReturnValue((Object)Float.valueOf(amount * (1.0f + 0.2f * (float)i)));
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void cancelDamage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity attacker;
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity).m_21023_((MobEffect)ModEffects.CHARM.get())) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getSpeed"}, at={@At(value="HEAD")}, cancellable=true)
    public void charmMovementSpeed(CallbackInfoReturnable<Float> cir) {
        if (this.m_21023_((MobEffect)ModEffects.CHARM.get())) {
            cir.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="HEAD")}, cancellable=true)
    public void charmMovement(CallbackInfo ci) {
        if (this.m_21023_((MobEffect)ModEffects.CHARM.get())) {
            ci.cancel();
        }
    }
}

