/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.item.custom;

import java.util.List;
import net.lyof.phantasm.Phantasm;
import net.lyof.phantasm.config.ConfigEntries;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class ShatteredPendantItem
extends Item {
    public ShatteredPendantItem(Item.Properties properties) {
        super(properties.m_41497_(Rarity.RARE).m_41487_(1).m_41503_(ConfigEntries.shatteredPendantDurability).m_41486_());
    }

    public int m_142159_(ItemStack stack) {
        return 3447176;
    }

    public static boolean canSeeSky(BlockPos pos, Level level) {
        int top = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_());
        return top <= pos.m_123342_();
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, level, entity, slot, selected);
        if (entity.f_19797_ % 20 == 0 && entity.m_20096_() && ShatteredPendantItem.canSeeSky(entity.m_20097_(), level)) {
            stack.m_41784_().m_128405_("SavedX", entity.m_146903_());
            stack.m_41784_().m_128405_("SavedY", entity.m_146904_());
            stack.m_41784_().m_128405_("SavedZ", entity.m_146907_());
            stack.m_41784_().m_128359_("SavedDim", level.m_46472_().toString());
        } else if (entity instanceof LivingEntity) {
            Player player;
            LivingEntity living = (LivingEntity)entity;
            if (entity.f_19797_ % 20 == 0 && entity.m_20186_() <= 0.0 && level.m_46472_().m_135782_().toString().equals("minecraft:the_end") && (!(entity instanceof Player) || !(player = (Player)entity).m_36335_().m_41519_((Item)this))) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 20, 0, true, false));
                this.m_5922_(stack, level, living);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        return super.m_7203_(level, player, hand);
    }

    public int m_8105_(ItemStack stack) {
        return 30;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPYGLASS;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity user) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128451_("SavedX") == 0 && nbt.m_128451_("SavedY") == 0 && nbt.m_128451_("SavedZ") == 0) {
            Phantasm.log("naah");
            return super.m_5922_(stack, level, user);
        }
        if (level.m_46472_().toString().equals(nbt.m_128461_("SavedDim"))) {
            user.f_19789_ = 0.0f;
            user.m_6021_((double)nbt.m_128451_("SavedX"), (double)nbt.m_128451_("SavedY"), (double)nbt.m_128451_("SavedZ"));
            if (user instanceof Player) {
                Player player = (Player)user;
                player.m_36335_().m_41524_((Item)this, 200);
                stack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21166_(user.m_7655_() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND));
            }
            user.m_5496_(SoundEvents.f_11887_, 1.0f, 2.0f);
        }
        return super.m_5922_(stack, level, user);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        String[] txt;
        super.m_7373_(stack, level, components, tooltipFlag);
        for (String t : txt = Component.m_237115_((String)"item.phantasm.shattered_pendant.desc").getString().split("\\n")) {
            components.add((Component)Component.m_237113_((String)t).m_130940_(ChatFormatting.GRAY));
        }
    }

    public void m_5929_(Level level, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        super.m_5929_(level, user, stack, remainingUseTicks);
        float sin = (float)Math.sin((double)remainingUseTicks * Math.PI / 10.0);
        float cos = (float)Math.cos((double)remainingUseTicks * Math.PI / 10.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, user.m_20185_() + (double)sin, user.m_20188_() - 0.5, user.m_20189_() + (double)cos, 0.0, 0.0, 0.0);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }
}

