/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.entities.custom;

import net.lyof.phantasm.client.particles.ModParticles;
import net.lyof.phantasm.config.ConfigEntries;
import net.lyof.phantasm.entities.ModEntities;
import net.lyof.phantasm.entities.animations.BehemothAnimation;
import net.lyof.phantasm.entities.goals.BehemothAttackGoal;
import net.lyof.phantasm.entities.goals.SleepGoal;
import net.lyof.phantasm.setup.ModSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BehemothEntity
extends Monster
implements Enemy {
    public static final EntityDimensions SLEEPING_DIMENSIONS = EntityDimensions.m_20398_((float)1.5f, (float)1.0f);
    public static final EntityDimensions STANDARD_DIMENSIONS = EntityDimensions.m_20398_((float)0.95f, (float)1.95f);
    public int angryTicks = 0;
    public int animTicks = 0;
    public BehemothAnimation animation = BehemothAnimation.SLEEPING;
    public static int MAX_ANGRY_TICKS = 600;

    public BehemothEntity(EntityType<? extends BehemothEntity> type, Level level) {
        super((EntityType)ModEntities.BEHEMOTH.get(), level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SleepGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new BehemothAttackGoal(this, 1.0, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22278_, 10.0);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.animation == BehemothAnimation.SLEEPING ? SLEEPING_DIMENSIONS : STANDARD_DIMENSIONS;
    }

    public float getStepHeight() {
        return 1.0f;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return ModSounds.BEHEMOTH_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return ModSounds.BEHEMOTH_DYING;
    }

    public boolean isAngry() {
        return this.m_5448_() != null;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Player player;
        if (source.m_269014_()) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player && !(player = (Player)entity).m_7500_() && !player.m_5833_()) {
            this.m_6710_((LivingEntity)player);
            this.angryTicks = MAX_ANGRY_TICKS;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (target == null && this.isAngry()) {
            this.setAnimation(BehemothAnimation.WAKING_DOWN);
        } else if (target != null && !this.isAngry()) {
            this.setAnimation(BehemothAnimation.WAKING_UP);
            this.m_5496_(SoundEvents.f_11894_, 1.0f, 1.0f);
        }
        super.m_6710_(target);
        this.angryTicks = target == null ? 0 : MAX_ANGRY_TICKS;
    }

    public void setAnimation(BehemothAnimation anim) {
        if (anim != this.animation) {
            this.animTicks = 0;
        }
        this.animation = anim;
    }

    public void m_8119_() {
        Player player;
        super.m_8119_();
        if (this.f_19797_ % 20 == 0) {
            this.m_6210_();
        }
        ++this.animTicks;
        if (this.animation.maxTime > 0 && this.animTicks > this.animation.maxTime) {
            if (this.isAngry()) {
                this.setAnimation(BehemothAnimation.WALKING);
            } else {
                this.setAnimation(BehemothAnimation.SLEEPING);
            }
        }
        if (this.angryTicks > 0) {
            --this.angryTicks;
        } else if (this.isAngry()) {
            this.m_6710_(null);
        } else if (!(this.f_19797_ % 20 != 0 || (player = this.m_9236_().m_45930_((Entity)this, (double)ConfigEntries.behemothAggroRange)) == null || player.m_7500_() || player.m_5833_() || player.m_6047_() && !(this.m_20270_((Entity)player) < (float)ConfigEntries.behemothAggroRangeSneaking))) {
            this.m_6710_((LivingEntity)player);
        }
        if (this.m_5448_() != null && (this.m_5448_().m_20270_((Entity)this) > 16.0f || !this.m_5448_().m_6084_())) {
            this.m_6710_(null);
        }
        if (!this.isAngry() && this.f_19797_ % 20 == 0) {
            this.m_5496_(SoundEvents.f_271283_, 2.0f, 1.0f);
            if (this.m_9236_().m_5776_() && this.m_217043_().m_188503_(2) == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ModParticles.ZZZ.get(), this.m_20185_() - Math.sin((double)(-this.m_146908_()) * Math.PI / 180.0), this.m_20186_() + 0.3, this.m_20189_() - Math.cos((double)this.m_146908_() * Math.PI / 180.0), 0.0, 0.05, 0.0);
            }
        }
    }
}

