/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.block.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DirectionalBlock
extends Block {
    public static final DirectionProperty FACING = DirectionProperty.m_156003_((String)"facing");
    public static final Map<Direction, VoxelShape> SHAPES = Map.of(Direction.DOWN, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Direction.UP, Block.m_49796_((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Direction.NORTH, Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)10.0), Direction.SOUTH, Block.m_49796_((double)3.0, (double)3.0, (double)6.0, (double)13.0, (double)13.0, (double)16.0), Direction.EAST, Block.m_49796_((double)6.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), Direction.WEST, Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)10.0, (double)13.0, (double)13.0));

    public DirectionalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.DOWN));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        BlockPos blockPos = pos.m_121945_((Direction)state.m_61143_((Property)FACING));
        BlockState support = reader.m_8055_(blockPos);
        return support.m_60783_((BlockGetter)reader, blockPos, (Direction)state.m_61143_((Property)FACING));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState other, LevelAccessor accessor, BlockPos pos, BlockPos otherPos) {
        BlockState result = super.m_7417_(state, direction, other, accessor, pos, otherPos);
        if (!result.m_60713_((Block)this)) {
            return result;
        }
        return this.m_7898_(state, (LevelReader)accessor, pos) ? result : Blocks.f_50016_.m_49966_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    public BlockState getPlacementState(LevelReader world, BlockPos pos) {
        ArrayList<Direction> possible = new ArrayList<Direction>();
        for (Direction dir : Direction.values()) {
            if (!this.m_7898_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)dir), world, pos)) continue;
            possible.add(dir);
        }
        Collections.shuffle(possible);
        if (possible.isEmpty()) {
            return Blocks.f_50016_.m_49966_();
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)possible.get(0)));
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (random.m_188503_(20) == 0) {
            world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_276532_, SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
        super.m_214162_(state, world, pos, random);
    }
}

