/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.BlockUtil;
import com.teamabnormals.neapolitan.common.block.BananaFrondBlock;
import com.teamabnormals.neapolitan.common.entity.animal.Chimpanzee;
import com.teamabnormals.neapolitan.core.NeapolitanConfig;
import com.teamabnormals.neapolitan.core.other.NeapolitanLootTables;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanBiomeTags;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.teamabnormals.neapolitan.core.registry.NeapolitanEntityTypes;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BananaPlantFeature
extends Feature<NoneFeatureConfiguration> {
    public BananaPlantFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos;
        RandomSource random = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        BlockPos blockPos = pos = context.m_159777_();
        ArrayList<BlockPos> stalks = new ArrayList<BlockPos>();
        int size = 3 + random.m_188503_(4);
        HashMap<BlockPos, Direction> smallFronds = new HashMap<BlockPos, Direction>();
        HashMap<BlockPos, Direction> fronds = new HashMap<BlockPos, Direction>();
        HashMap<BlockPos, Direction> largeFronds = new HashMap<BlockPos, Direction>();
        for (int i = 0; i < size; ++i) {
            stalks.add(blockPos);
            blockPos = blockPos.m_7494_();
        }
        BlockPos bundle = null;
        BlockPos upFrond = blockPos;
        int i = 0;
        if (!BananaPlantFeature.isValidGround(level, pos.m_7495_())) {
            return false;
        }
        for (BlockPos stalk : stalks) {
            if (i >= size - 3) {
                for (Direction direction : Direction.values()) {
                    if (!direction.m_122434_().m_122479_()) continue;
                    if (i == size - 1) {
                        if (random.m_188503_(4) != 0) {
                            largeFronds.put(stalk.m_121945_(direction), direction);
                            continue;
                        }
                        fronds.put(stalk.m_121945_(direction), direction);
                        continue;
                    }
                    if (i == size - 2) {
                        if (random.m_188499_()) {
                            fronds.put(stalk.m_121945_(direction), direction);
                            continue;
                        }
                        if (random.m_188503_(4) == 0 && bundle == null) {
                            bundle = stalk.m_121945_(direction);
                            continue;
                        }
                        smallFronds.put(stalk.m_121945_(direction), direction);
                        continue;
                    }
                    if (i != size - 3 || random.m_188503_(3) == 0) continue;
                    smallFronds.put(stalk.m_121945_(direction), direction);
                }
            }
            ++i;
        }
        if (BananaPlantFeature.isAirAt((LevelSimulatedReader)level, pos, size) && pos.m_123342_() < level.m_151558_() - size) {
            boolean canSpawnChimps = level.m_204166_(pos).m_203656_(NeapolitanBiomeTags.HAS_CHIMPANZEE);
            boolean suspicious = canSpawnChimps && BananaPlantFeature.isGrass((LevelSimulatedReader)level, pos.m_7495_()) && (Boolean)NeapolitanConfig.COMMON.suspiciousBananaPlants.get() != false && (double)random.m_188501_() < (Double)NeapolitanConfig.COMMON.suspiciousBananaPlantChance.get();
            for (BlockPos blockPos2 : stalks) {
                boolean carved = suspicious && random.m_188499_();
                level.m_7731_(blockPos2, ((Block)(carved ? NeapolitanBlocks.CARVED_BANANA_STALK : NeapolitanBlocks.BANANA_STALK).get()).m_49966_(), 19);
            }
            level.m_7731_(upFrond, ((Block)NeapolitanBlocks.LARGE_BANANA_FROND.get()).m_49966_(), 19);
            if (bundle != null) {
                level.m_7731_(bundle, ((Block)NeapolitanBlocks.BANANA_BUNDLE.get()).m_49966_(), 19);
                if (random.m_188500_() < (Double)NeapolitanConfig.COMMON.chimpanzeeGroupChance.get() && canSpawnChimps) {
                    BananaPlantFeature.spawnChimps(level, pos);
                }
            }
            for (BlockPos blockPos2 : smallFronds.keySet()) {
                level.m_7731_(blockPos2, (BlockState)((Block)NeapolitanBlocks.SMALL_BANANA_FROND.get()).m_49966_().m_61124_((Property)BananaFrondBlock.FACING, (Comparable)((Direction)smallFronds.get(blockPos2))), 19);
            }
            for (BlockPos blockPos2 : fronds.keySet()) {
                level.m_7731_(blockPos2, (BlockState)((Block)NeapolitanBlocks.BANANA_FROND.get()).m_49966_().m_61124_((Property)BananaFrondBlock.FACING, (Comparable)((Direction)fronds.get(blockPos2))), 19);
            }
            for (BlockPos blockPos2 : largeFronds.keySet()) {
                level.m_7731_(blockPos2, (BlockState)((Block)NeapolitanBlocks.LARGE_BANANA_FROND.get()).m_49966_().m_61124_((Property)BananaFrondBlock.FACING, (Comparable)((Direction)largeFronds.get(blockPos2))), 19);
            }
            if (BananaPlantFeature.isGrass((LevelSimulatedReader)level, pos.m_7495_())) {
                level.m_7731_(pos.m_7495_(), Blocks.f_49994_.m_49966_(), 19);
                boolean chimpHead = suspicious && random.m_188501_() < 0.25f;
                int horizontalRange = (suspicious ? 3 : 2) + random.m_188503_(2);
                int verticalMin = suspicious ? -8 : -2;
                int rareSusGravel = 0;
                int commonSusGravel = 0;
                int rareSusGravelMax = (Integer)NeapolitanConfig.COMMON.rareSuspiciousGravelMin.get() + random.m_188503_(2);
                int susGravelAmount = 8 + random.m_188503_(3) + random.m_188503_(2);
                if (chimpHead) {
                    int moreGravel = 2 + random.m_188503_(3);
                    rareSusGravelMax += moreGravel;
                    susGravelAmount += moreGravel - 1;
                    Direction facing = Direction.Plane.HORIZONTAL.m_235690_(random);
                    BananaPlantFeature.generateChimpHead(level, pos.m_5484_(facing, random.m_188503_(2)).m_5484_(facing.m_122427_(), 1 + random.m_188503_(2)).m_6625_(3 + random.m_188503_(3)), facing, random);
                }
                for (int x = -horizontalRange; x <= horizontalRange; ++x) {
                    for (int y = verticalMin; y < 2; ++y) {
                        for (int z = -horizontalRange; z <= horizontalRange; ++z) {
                            BlockPos offsetPos;
                            int dist;
                            if (Mth.m_14040_((int)x) == Math.abs(z) && Mth.m_14040_((int)x) == horizontalRange || y < -3 && (Math.abs(x) >= horizontalRange || Math.abs(z) >= horizontalRange) || y < -6 && (Math.abs(x) >= horizontalRange - 1 || Math.abs(z) >= horizontalRange - 1)) continue;
                            int clamped = Math.max(1, Math.min(y >= -1 || Math.abs(x) < 3 && Math.abs(z) < 3 ? 3 : dist, dist = (int)Mth.m_14116_((float)((float)(offsetPos = pos.m_7918_(x, y, z)).m_123331_((Vec3i)pos))))) + (suspicious ? 0 : random.m_188503_(2));
                            if (random.m_188503_(clamped) != 0 || (!suspicious || !BananaPlantFeature.m_159747_((BlockState)level.m_8055_(offsetPos))) && !BananaPlantFeature.isDirt((LevelSimulatedReader)level, offsetPos)) continue;
                            if (!suspicious) {
                                level.m_7731_(offsetPos, Blocks.f_49994_.m_49966_(), 19);
                            } else if (commonSusGravel + rareSusGravel < susGravelAmount && random.m_188501_() < 0.05f * (float)(Math.abs(y) + 1)) {
                                boolean rare;
                                level.m_7731_(offsetPos, Blocks.f_276445_.m_49966_(), 19);
                                boolean bl = rare = rareSusGravel < rareSusGravelMax && random.m_188503_(3) == 0 || commonSusGravel == susGravelAmount - rareSusGravelMax;
                                if (rare) {
                                    ++rareSusGravel;
                                } else {
                                    ++commonSusGravel;
                                }
                                level.m_141902_(offsetPos, BlockEntityType.f_271323_).ifPresent(block -> block.m_277049_(rare ? NeapolitanLootTables.BANANA_PLANT_ARCHAEOLOGY_RARE : NeapolitanLootTables.BANANA_PLANT_ARCHAEOLOGY_COMMON, offsetPos.m_121878_()));
                            } else {
                                level.m_7731_(offsetPos, Blocks.f_49994_.m_49966_(), 19);
                            }
                            if (level.m_7433_(offsetPos.m_7494_(), state -> state.m_60710_((LevelReader)level, offsetPos.m_7494_()))) continue;
                            level.m_7731_(offsetPos.m_7494_(), Blocks.f_50016_.m_49966_(), 19);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static void generateChimpHead(WorldGenLevel level, BlockPos origin, Direction facing, RandomSource random) {
        BlockPos.m_121990_((BlockPos)origin, (BlockPos)origin.m_6625_(3).m_5484_(facing.m_122424_(), 2).m_5484_(facing.m_122428_(), 3)).map(BlockPos::m_7949_).forEach(pos -> BananaPlantFeature.placeMossyBlock(level, random, null, pos, 0, 0, 0, Blocks.f_50652_.m_49966_()));
        BananaPlantFeature.placeMossyBlock(level, random, facing, origin, -1, -1, -1, Blocks.f_50652_.m_49966_());
        BananaPlantFeature.placeMossyBlock(level, random, facing, origin, 4, -1, -1, Blocks.f_50652_.m_49966_());
        BananaPlantFeature.placeMossyBlock(level, random, facing, origin, -1, 0, -1, Blocks.f_50409_.m_49966_());
        BananaPlantFeature.placeMossyBlock(level, random, facing, origin, 4, 0, -1, Blocks.f_50409_.m_49966_());
        BananaPlantFeature.placeMossyBlock(level, random, facing, origin, 1, -1, -1, Blocks.f_50268_.m_49966_());
        BananaPlantFeature.placeMossyBlock(level, random, facing, origin, 2, -1, -1, Blocks.f_50268_.m_49966_());
        BananaPlantFeature.placeMossyBlock(level, random, facing, origin, 1, -1, 0, (BlockState)Blocks.f_50157_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)facing.m_122428_()));
        BananaPlantFeature.placeMossyBlock(level, random, facing, origin, 2, -1, 0, (BlockState)Blocks.f_50157_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)facing.m_122427_()));
        BananaPlantFeature.placeMossyBlock(level, random, facing, origin, 1, -1, 1, Blocks.f_50409_.m_49966_());
        BananaPlantFeature.placeMossyBlock(level, random, facing, origin, 2, -1, 1, Blocks.f_50409_.m_49966_());
        BananaPlantFeature.placeMossyBlock(level, random, facing, origin, 1, -2, 1, (BlockState)((BlockState)Blocks.f_50157_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)facing.m_122427_())).m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP));
        BananaPlantFeature.placeMossyBlock(level, random, facing, origin, 2, -2, 1, (BlockState)((BlockState)Blocks.f_50157_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)facing.m_122428_())).m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP));
        BananaPlantFeature.placeMossyBlock(level, random, facing, origin, 1, -3, 1, Blocks.f_50652_.m_49966_());
        BananaPlantFeature.placeMossyBlock(level, random, facing, origin, 2, -3, 1, Blocks.f_50652_.m_49966_());
    }

    private static void placeMossyBlock(WorldGenLevel level, RandomSource random, Direction facing, BlockPos pos, int x, int y, int z, BlockState state) {
        if (state.m_60713_(Blocks.f_50268_)) {
            if (random.m_188499_()) {
                return;
            }
        } else if (random.m_188501_() < 0.4f) {
            Block block = state.m_60713_(Blocks.f_50652_) ? Blocks.f_50079_ : (state.m_60713_(Blocks.f_50409_) ? Blocks.f_50647_ : Blocks.f_50633_);
            state = BlockUtil.transferAllBlockStates((BlockState)state, (BlockState)block.m_49966_());
        }
        if (facing != null) {
            if (facing.m_122434_() == Direction.Axis.X) {
                int temp = x;
                x = z;
                z = temp - 3;
                if (state.m_61138_((Property)StairBlock.f_56841_)) {
                    state = (BlockState)state.m_61124_((Property)StairBlock.f_56841_, (Comparable)((Direction)state.m_61143_((Property)StairBlock.f_56841_)).m_122424_());
                }
            }
            x *= facing.m_122421_().m_122540_();
            z *= facing.m_122421_().m_122540_();
        }
        level.m_7731_(pos.m_7918_(x, y, z), state, 19);
    }

    private static void spawnChimps(WorldGenLevel level, BlockPos pos) {
        RandomSource random = level.m_213780_();
        int minSpawnAttempts = (Integer)NeapolitanConfig.COMMON.chimpanzeeMinSpawnAttempts.get();
        int maxSpawnAttempts = (Integer)NeapolitanConfig.COMMON.chimpanzeeMaxSpawnAttempts.get();
        if (maxSpawnAttempts < minSpawnAttempts || maxSpawnAttempts <= 0 || minSpawnAttempts < 0) {
            return;
        }
        int spawnCount = minSpawnAttempts + random.m_188503_(maxSpawnAttempts - minSpawnAttempts);
        int spawnedChimps = 0;
        for (int i = 0; i < spawnCount; ++i) {
            Chimpanzee chimp;
            int spawnRange = 4;
            double d0 = (double)pos.m_123341_() + (random.m_188500_() - random.m_188500_()) * (double)spawnRange + 0.5;
            double d1 = pos.m_123342_() + random.m_188503_(3) - 1;
            double d2 = (double)pos.m_123343_() + (random.m_188500_() - random.m_188500_()) * (double)spawnRange + 0.5;
            if (!level.m_45772_(((EntityType)NeapolitanEntityTypes.CHIMPANZEE.get()).m_20585_(d0, d1, d2)) || spawnedChimps >= (Integer)NeapolitanConfig.COMMON.chimpanzeeMaxGroupSize.get() || (chimp = (Chimpanzee)((EntityType)NeapolitanEntityTypes.CHIMPANZEE.get()).m_20615_((Level)level.m_6018_())) == null) continue;
            chimp.m_7678_(d0, d1, d2, level.m_213780_().m_188501_() * 360.0f, 0.0f);
            chimp.m_6518_((ServerLevelAccessor)level, level.m_6436_(chimp.m_20183_()), MobSpawnType.STRUCTURE, null, null);
            chimp.m_6863_(random.m_188503_(4) == 0);
            level.m_7967_((Entity)chimp);
            chimp.m_21373_();
            ++spawnedChimps;
        }
    }

    private static boolean isAirAt(LevelSimulatedReader level, BlockPos origin, int size) {
        BlockPos pos = origin.m_7494_();
        for (int i = 0; i < size + 1; ++i) {
            if (!TreeFeature.m_67267_((LevelSimulatedReader)level, (BlockPos)pos)) {
                return false;
            }
            for (Direction direction : Direction.values()) {
                if (!direction.m_122434_().m_122479_() || level.m_7433_(pos.m_121945_(direction), BlockBehaviour.BlockStateBase::m_60795_)) continue;
                return false;
            }
            pos = pos.m_7494_();
        }
        return true;
    }

    public static boolean isValidGround(WorldGenLevel level, BlockPos pos) {
        return level.m_7433_(pos, state -> level.m_204166_(pos).containsTag(NeapolitanBiomeTags.BANANA_PLANT_REQUIRES_SAND) && state.m_60713_(Blocks.f_49992_) || state.m_60713_(Blocks.f_49994_) || state.m_60713_(Blocks.f_50440_));
    }

    public static boolean isGrass(LevelSimulatedReader worldIn, BlockPos pos) {
        return worldIn.m_7433_(pos, state -> state.m_60713_(Blocks.f_50440_));
    }

    public static boolean isDirt(LevelSimulatedReader worldIn, BlockPos pos) {
        return worldIn.m_7433_(pos, state -> state.m_204336_(BlockTags.f_144274_));
    }
}

