/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.block;

import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.neapolitan.common.block.BeanstalkThornsBlock;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MagicBeansBlock
extends DirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0)};

    public MagicBeansBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.m_61143_((Property)f_52588_)).m_122411_()];
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)f_52588_);
        BlockPos blockpos = pos.m_121945_(direction.m_122424_());
        return level.m_8055_(blockpos).m_60783_((BlockGetter)level, blockpos, direction);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean moving) {
        level.m_186460_(pos, (Block)this, 50);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        } else {
            MagicBeansBlock.growBeanstalk((Level)level, pos, (Direction)state.m_61143_((Property)f_52588_));
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction == ((Direction)state.m_61143_((Property)f_52588_)).m_122424_() && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, offsetState, level, pos, offsetPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelaccessor = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)f_52588_, (Comparable)context.m_43719_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_, WATERLOGGED});
    }

    private static void growBeanstalk(Level level, BlockPos origin, Direction direction) {
        RandomSource random = level.m_213780_();
        ArrayList<BlockPos> beanstalkPositions = new ArrayList<BlockPos>();
        ArrayList<Direction> offsetDirections = new ArrayList<Direction>();
        for (Direction.Axis axis : Direction.Axis.values()) {
            if (axis == direction.m_122434_()) continue;
            Direction[] directionArray = Direction.values();
            int n = directionArray.length;
            for (int i = 0; i < n; ++i) {
                Direction direction1 = directionArray[i];
                if (direction1.m_122434_() != axis) continue;
                offsetDirections.add(direction1);
            }
        }
        for (Direction direction1 : offsetDirections) {
            BlockPos blockPos = origin.m_121945_(direction1);
            beanstalkPositions.add(blockPos);
            BlockPos cornerPos = blockPos.m_121945_(MagicBeansBlock.rotate(direction.m_122434_(), direction1));
            if (random.m_188503_(3) != 0) continue;
            beanstalkPositions.add(cornerPos);
        }
        Direction startingDirection = (Direction)offsetDirections.get(random.m_188503_(4));
        BlockPos blockPos = origin;
        level.m_5594_(null, origin, SoundEvents.f_144074_, SoundSource.BLOCKS, 1.0f, 1.0f);
        block3: for (int i = 0; i < 3 + random.m_188503_(4); ++i) {
            for (int j = 0; j < 3 + random.m_188503_(3); ++j) {
                if (j != 0) {
                    blockPos = blockPos.m_121945_(direction);
                }
                if (!level.m_8055_(blockPos).m_247087_() && !blockPos.equals((Object)origin)) break block3;
                beanstalkPositions.add(blockPos);
            }
            startingDirection = MagicBeansBlock.rotate(direction.m_122434_(), startingDirection);
            blockPos = blockPos.m_121945_(startingDirection);
        }
        for (BlockPos blockPos1 : beanstalkPositions) {
            if (!level.m_8055_(blockPos1).m_247087_() && !blockPos1.equals((Object)origin)) continue;
            level.m_46597_(blockPos1, (BlockState)((Block)NeapolitanBlocks.BEANSTALK.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()));
            for (int i = 0; i < 3; ++i) {
                double d0 = random.m_188583_() * 0.02;
                double d1 = random.m_188583_() * 0.02;
                double d2 = random.m_188583_() * 0.02;
                NetworkUtil.spawnParticle((String)"minecraft:happy_villager", (double)((double)blockPos1.m_123341_() - 0.1 + random.m_188500_() * 1.2), (double)((double)blockPos1.m_123342_() - 0.1 + random.m_188500_() * 1.2), (double)((double)blockPos1.m_123343_() - 0.1 + random.m_188500_() * 1.2), (double)d0, (double)d1, (double)d2);
            }
        }
        for (BlockPos blockPos1 : beanstalkPositions) {
            for (Direction direction1 : Direction.values()) {
                BlockPos thornPos = blockPos1.m_121945_(direction1);
                BlockState beanState = (BlockState)((BlockState)((Block)NeapolitanBlocks.BEANSTALK_THORNS.get()).m_49966_().m_61124_((Property)BeanstalkThornsBlock.FACING, (Comparable)direction1)).m_61124_((Property)BeanstalkThornsBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(thornPos).m_76152_() == Fluids.f_76193_));
                if (!level.m_8055_(blockPos1).m_60713_((Block)NeapolitanBlocks.BEANSTALK.get()) || !level.m_8055_(thornPos).m_247087_() || random.m_188503_(4) != 0 || !beanState.m_60710_((LevelReader)level, thornPos)) continue;
                level.m_46597_(thornPos, beanState);
            }
        }
    }

    private static Direction rotate(Direction.Axis axis, Direction face) {
        if (axis == Direction.Axis.Y) {
            return switch (face) {
                case Direction.NORTH -> Direction.EAST;
                case Direction.SOUTH -> Direction.WEST;
                case Direction.WEST -> Direction.NORTH;
                case Direction.EAST -> Direction.SOUTH;
                default -> throw new IllegalStateException("Unable to get rotated facing of " + face);
            };
        }
        if (axis == Direction.Axis.Z) {
            return switch (face) {
                case Direction.UP -> Direction.EAST;
                case Direction.DOWN -> Direction.WEST;
                case Direction.WEST -> Direction.UP;
                case Direction.EAST -> Direction.DOWN;
                default -> throw new IllegalStateException("Unable to get rotated facing of " + face);
            };
        }
        if (axis == Direction.Axis.X) {
            return switch (face) {
                case Direction.UP -> Direction.NORTH;
                case Direction.DOWN -> Direction.SOUTH;
                case Direction.SOUTH -> Direction.UP;
                case Direction.NORTH -> Direction.DOWN;
                default -> throw new IllegalStateException("Unable to get rotated facing of " + face);
            };
        }
        return face;
    }
}

