/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.registries;

import elucent.eidolon.common.entity.BonechillProjectileEntity;
import elucent.eidolon.common.entity.ChantCasterEntity;
import elucent.eidolon.common.entity.GiantSkeletonEntity;
import elucent.eidolon.common.entity.NecromancerEntity;
import elucent.eidolon.common.entity.NecromancerSpellEntity;
import elucent.eidolon.common.entity.RavenEntity;
import elucent.eidolon.common.entity.SlimySlugEntity;
import elucent.eidolon.common.entity.SoulfireProjectileEntity;
import elucent.eidolon.common.entity.WraithEntity;
import elucent.eidolon.common.entity.ZombieBruteEntity;
import elucent.eidolon.registries.Registry;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class EidolonEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"eidolon");
    public static final RegistryObject<EntityType<ZombieBruteEntity>> ZOMBIE_BRUTE = EidolonEntities.addEntity("zombie_brute", 7969893, 44975, 1.2f, 2.5f, ZombieBruteEntity::new, MobCategory.MONSTER);
    public static final RegistryObject<EntityType<GiantSkeletonEntity>> GIANT_SKEL = EidolonEntities.addEntity("giant_skeleton", 7368299, 11381949, 1.2f, 2.75f, GiantSkeletonEntity::new, MobCategory.MONSTER);
    public static final RegistryObject<EntityType<WraithEntity>> WRAITH = EidolonEntities.addEntity("wraith", 7368299, 11381949, 0.6f, 1.9f, WraithEntity::new, MobCategory.MONSTER);
    public static final RegistryObject<EntityType<SoulfireProjectileEntity>> SOULFIRE_PROJECTILE = EidolonEntities.addEntity("soulfire_projectile", 0.4f, 0.4f, SoulfireProjectileEntity::new, MobCategory.MISC);
    public static final RegistryObject<EntityType<BonechillProjectileEntity>> BONECHILL_PROJECTILE = EidolonEntities.addEntity("bonechill_projectile", 0.4f, 0.4f, BonechillProjectileEntity::new, MobCategory.MISC);
    public static final RegistryObject<EntityType<NecromancerSpellEntity>> NECROMANCER_SPELL = EidolonEntities.addEntity("necromancer_spell", 0.4f, 0.4f, NecromancerSpellEntity::new, MobCategory.MISC);
    public static final RegistryObject<EntityType<ChantCasterEntity>> CHANT_CASTER = EidolonEntities.addEntity("chant_caster", 0.1f, 0.1f, ChantCasterEntity::new, MobCategory.MISC);
    public static final RegistryObject<EntityType<NecromancerEntity>> NECROMANCER = EidolonEntities.addEntity("necromancer", 6890846, 10283263, 0.6f, 2.2f, NecromancerEntity::new, MobCategory.MONSTER);
    public static final RegistryObject<EntityType<RavenEntity>> RAVEN = EidolonEntities.addEntity("raven", 1974052, 4214630, 0.375f, 0.5f, RavenEntity::new, MobCategory.CREATURE);
    public static final RegistryObject<EntityType<SlimySlugEntity>> SLIMY_SLUG = EidolonEntities.addEntity("slimy_slug", 14410632, 6266434, 0.5f, 0.25f, SlimySlugEntity::new, MobCategory.CREATURE);

    static <T extends Entity> RegistryObject<EntityType<T>> addEntity(String name, float width, float height, EntityType.EntityFactory<T> factory, MobCategory kind) {
        return ENTITIES.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)kind).setTrackingRange(64).setUpdateInterval(1).m_20699_(width, height).m_20712_("eidolon:" + name));
    }

    static <T extends Mob> RegistryObject<EntityType<T>> addEntity(String name, int color1, int color2, float width, float height, EntityType.EntityFactory<T> factory, MobCategory kind) {
        RegistryObject type = ENTITIES.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)kind).setTrackingRange(64).setUpdateInterval(1).m_20699_(width, height).m_20712_("eidolon:" + name));
        Registry.ITEMS.register("spawn_" + name, () -> new ForgeSpawnEggItem((Supplier)type, color1, color2, new Item.Properties()));
        return type;
    }
}

