/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.datagen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.util.DamageTypeData;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class EidDamageProvider {

    public static class DamageTypeTagGen
    extends TagsProvider<DamageType> {
        private final String namespace;

        public DamageTypeTagGen(String namespace, PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pLookupProvider, ExistingFileHelper existingFileHelper) {
            super(pOutput, Registries.f_268580_, pLookupProvider, namespace, existingFileHelper);
            this.namespace = namespace;
        }

        public DamageTypeTagGen(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pLookupProvider, ExistingFileHelper existingFileHelper) {
            this("eidolon", pOutput, pLookupProvider, existingFileHelper);
        }

        protected void m_6577_(@NotNull HolderLookup.Provider provider) {
            this.m_206424_(Registry.FORGE_MAGIC).m_206428_(DamageTypeTags.f_268731_);
            HashMultimap tagsToTypes = HashMultimap.create();
            DamageTypeData.allInNamespace(this.namespace).forEach(arg_0 -> DamageTypeTagGen.lambda$addTags$1((Multimap)tagsToTypes, arg_0));
            tagsToTypes.asMap().forEach((tag, keys) -> {
                TagsProvider.TagAppender appender = this.m_206424_((TagKey)tag);
                keys.forEach(key -> appender.m_176839_(key.m_135782_()));
            });
        }

        private static /* synthetic */ void lambda$addTags$1(Multimap tagsToTypes, DamageTypeData data) {
            data.tags.forEach(tag -> tagsToTypes.put(tag, data.key));
        }
    }

    public static class DamageTypeDataProvider
    extends DatapackBuiltinEntriesProvider {
        private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().m_254916_(Registries.f_268580_, DamageTypeDataProvider::bootstrap);

        public static void bootstrap(BootstapContext<DamageType> ctx) {
            DamageTypeData.allInNamespace("eidolon").forEach(data -> data.register(ctx));
        }

        public DamageTypeDataProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries, BUILDER, Set.of("eidolon"));
        }

        public static DataProvider.Factory<DamageTypeDataProvider> makeFactory(CompletableFuture<HolderLookup.Provider> registries) {
            return output -> new DamageTypeDataProvider(output, registries);
        }

        @NotNull
        public String m_6055_() {
            return "Eidolon's Damage Type Data";
        }
    }
}

