/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item.curio;

import com.mojang.datafixers.util.Either;
import elucent.eidolon.common.item.curio.EidolonCurio;
import elucent.eidolon.registries.Registry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;

public class SanguineAmuletItem
extends EidolonCurio {
    public SanguineAmuletItem(Item.Properties properties) {
        super(properties);
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MinecraftForge.EVENT_BUS.addListener(SanguineAmuletItem::renderTooltip);
            return null;
        });
    }

    static int getCharge(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null && tag.m_128441_("charge")) {
            return tag.m_128451_("charge");
        }
        return 0;
    }

    static void addCharge(ItemStack stack, int diff) {
        int newCharge = Mth.m_14045_((int)(SanguineAmuletItem.getCharge(stack) + diff), (int)0, (int)40);
        stack.m_41784_().m_128405_("charge", newCharge);
    }

    static void setCharge(ItemStack stack, int charge) {
        int newCharge = Mth.m_14045_((int)charge, (int)0, (int)40);
        stack.m_41784_().m_128405_("charge", newCharge);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        if (!entity.m_9236_().f_46443_) {
            Player player;
            if (entity.f_19797_ % 80 == 0 && (double)entity.m_21223_() >= (double)entity.m_21233_() - 1.0E-4 && entity instanceof Player && (player = (Player)entity).m_36324_().m_38702_() >= 18 && SanguineAmuletItem.getCharge(stack) < 40) {
                float f = player.m_36324_().m_38722_() > 0.0f ? Math.min(4.0f * player.m_36324_().m_38722_(), 16.0f) : 4.0f;
                player.m_36399_(f);
                SanguineAmuletItem.addCharge(stack, 1);
            }
            if (entity.f_19797_ % 10 == 0 && SanguineAmuletItem.getCharge(stack) > 0 && entity.m_21223_() < entity.m_21233_()) {
                int taken = (int)Math.min(1.0f, entity.m_21233_() - entity.m_21223_());
                SanguineAmuletItem.addCharge(stack, -taken);
                entity.m_5634_((float)taken);
            }
        }
    }

    public boolean canSync(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    @NotNull
    public CompoundTag writeSyncData(SlotContext slotContext, ItemStack stack) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("charge", SanguineAmuletItem.getCharge(stack));
        return nbt;
    }

    public void readSyncData(SlotContext slotContext, CompoundTag compound, ItemStack stack) {
        SanguineAmuletItem.setCharge(stack, compound.m_128451_("charge"));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderTooltip(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() == Registry.SANGUINE_AMULET.get()) {
            event.getTooltipElements().add(Either.right((Object)new SanguineAmuletTooltipInfo(stack, event.getMaxWidth())));
        }
    }

    public static class SanguineAmuletTooltipInfo
    implements TooltipComponent {
        final ItemStack stack;
        final int maxWidth;

        public SanguineAmuletTooltipInfo(ItemStack stack, int maxWidth) {
            this.stack = stack;
            this.maxWidth = maxWidth;
        }
    }

    public static class SanguineAmuletTooltipComponent
    implements ClientTooltipComponent {
        final ItemStack stack;
        final int maxWidth;

        public SanguineAmuletTooltipComponent(SanguineAmuletTooltipInfo info) {
            this.stack = info.stack;
            this.maxWidth = info.maxWidth;
        }

        public int m_142103_() {
            int charge = SanguineAmuletItem.getCharge(this.stack);
            int rows = (charge + 19) / 20;
            return 8 + 12 * rows;
        }

        public int m_142069_(@NotNull Font font) {
            return this.maxWidth;
        }

        public void m_183452_(@NotNull Font font, int x, int y, @NotNull GuiGraphics pGuiGraphics) {
            Minecraft mc = Minecraft.m_91087_();
            int charge = SanguineAmuletItem.getCharge(this.stack);
            int rows = (charge + 19) / 20;
            for (int i = 0; i < charge; i += 20) {
                for (int j = 0; j < Mth.m_14045_((int)(charge - i), (int)0, (int)20); j += 2) {
                    if (charge - (i + j) == 1) {
                        pGuiGraphics.m_280163_(new ResourceLocation("minecraft", "textures/gui/icons.png"), x - 1 + j / 2 * 8, y + i / 20 * 9 + 2, 61.0f, 0.0f, 9, 9, 256, 256);
                        continue;
                    }
                    pGuiGraphics.m_280163_(new ResourceLocation("minecraft", "textures/gui/icons.png"), x - 1 + j / 2 * 8, y + i / 20 * 9 + 2, 52.0f, 0.0f, 9, 9, 256, 256);
                }
            }
        }
    }
}

