/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item;

import elucent.eidolon.api.research.Research;
import elucent.eidolon.common.item.ItemBase;
import elucent.eidolon.registries.Researches;
import elucent.eidolon.util.KnowledgeUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ResearchNotesItem
extends ItemBase {
    private final Random random = new Random();

    public ResearchNotesItem(Item.Properties builderIn) {
        super(builderIn);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_("research")) {
            return;
        }
        Research r = Researches.find(new ResourceLocation(stack.m_41783_().m_128461_("research")));
        if (r == null) {
            return;
        }
        int done = stack.m_41783_().m_128451_("stepsDone");
        StringBuilder stars = new StringBuilder();
        stars.append(ChatFormatting.GOLD);
        for (int i = 0; i < r.getStars(); ++i) {
            if (i == done) {
                stars.append(ChatFormatting.GRAY);
            }
            if (i < done) {
                stars.append("\u2605");
                continue;
            }
            stars.append("\u2606");
        }
        tooltip.add((Component)Component.m_237113_((String)stars.toString()));
        boolean known = done >= r.getStars() || KnowledgeUtil.knowsResearch((Player)Minecraft.m_91087_().f_91074_, r.getRegistryName());
        String name = known ? r.getName() : "???";
        tooltip.add((Component)Component.m_237113_((String)(String.valueOf(known ? ChatFormatting.GRAY : ChatFormatting.DARK_GRAY) + ChatFormatting.ITALIC + name)));
    }
}

