/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.codex;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Axis;
import elucent.eidolon.api.spells.Rune;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.capability.IKnowledge;
import elucent.eidolon.client.ClientRegistry;
import elucent.eidolon.codex.Chapter;
import elucent.eidolon.codex.CodexGui;
import elucent.eidolon.codex.Page;
import elucent.eidolon.event.ClientEvents;
import elucent.eidolon.registries.EidolonSounds;
import elucent.eidolon.registries.Runes;
import elucent.eidolon.util.ColorUtil;
import elucent.eidolon.util.RenderUtil;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class RuneIndexPage
extends Page {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("eidolon", "textures/gui/codex_rune_index_page.png");
    final Rune[] runes = (Rune[])Runes.getRunes().toArray(Rune[]::new);
    int scroll = 0;

    public RuneIndexPage() {
        super(BACKGROUND);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean click(CodexGui gui, int x, int y, int mouseX, int mouseY) {
        LocalPlayer entity = Minecraft.m_91087_().f_91074_;
        if (entity.getCapability(IKnowledge.INSTANCE).resolve().isEmpty()) {
            return false;
        }
        IKnowledge knowledge = (IKnowledge)entity.getCapability(IKnowledge.INSTANCE, null).resolve().get();
        for (int i = 0; i < this.runes.length; ++i) {
            int xx = x + 2 + i % 6 * 20;
            int yy = y + 2 + i / 6 * 20;
            if (!knowledge.knowsRune(this.runes[i]) || mouseX < xx || mouseX > xx + 16 || mouseY < yy || mouseY > yy + 16) continue;
            entity.m_6330_((SoundEvent)EidolonSounds.SELECT_RUNE.get(), SoundSource.NEUTRAL, 0.5f, entity.m_9236_().f_46441_.m_188501_() * 0.25f + 0.75f);
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(CodexGui gui, @NotNull GuiGraphics guiGraphics, ResourceLocation bg, int x, int y, int mouseX, int mouseY) {
        gui.hoveredRune = null;
        PoseStack mStack = guiGraphics.m_280168_();
        LocalPlayer entity = Minecraft.m_91087_().f_91074_;
        Optional knowledge = entity.getCapability(IKnowledge.INSTANCE, null).resolve();
        for (int i = 0; i < this.runes.length; ++i) {
            boolean hover;
            int xx = x + 2 + i % 6 * 20;
            int yy = y + 2 + i / 6 * 20;
            boolean bl = hover = knowledge.isPresent() && ((IKnowledge)knowledge.get()).knowsRune(this.runes[i]) && mouseX >= xx && mouseX <= xx + 16 && mouseY >= yy && mouseY <= yy + 16;
            if (hover) {
                gui.hoveredRune = this.runes[i];
            }
            guiGraphics.m_280218_(bg, xx, yy, knowledge.isPresent() && ((IKnowledge)knowledge.get()).knowsRune(this.runes[i]) ? 128 : 148, 0, 20, 20);
            if (!knowledge.isPresent() || !((IKnowledge)knowledge.get()).knowsRune(this.runes[i])) continue;
            Tesselator tess = Tesselator.m_85913_();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShader(ClientRegistry::getGlowingSpriteShader);
            if (hover) {
                mStack.m_85836_();
                mStack.m_252880_((float)(xx + 10), (float)(yy + 10), 0.0f);
                mStack.m_252781_(Axis.f_252403_.m_252977_(ClientEvents.getClientTicks() * 1.5f));
                mStack.m_85841_(0.5f, 0.5f, 1.0f);
                RuneIndexPage.colorBlit(mStack, -12, -12, 128, 20, 24, 24, 256, 256, ColorUtil.packColor(255, 255, 255, 255));
                mStack.m_85849_();
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            for (int j = 0; j < (hover ? 2 : 1); ++j) {
                RenderUtil.litQuad(mStack, (MultiBufferSource)MultiBufferSource.m_109898_((BufferBuilder)tess.m_85915_()), xx + 6, yy + 6, 8.0, 8.0, 1.0f, 1.0f, 1.0f, 0.75f, (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(this.runes[i].getSprite()));
                tess.m_85914_();
            }
            RenderSystem.disableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        }
    }

    public static class SignEntry {
        final Chapter chapter;
        final Sign sign;

        public SignEntry(Chapter chapter, Sign sign) {
            this.chapter = chapter;
            this.sign = sign;
        }
    }
}

