/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.client;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ClientConfig {
    public static ForgeConfigSpec.ConfigValue<Boolean> BETTER_LAYERING;
    public static ForgeConfigSpec.ConfigValue<String> MANA_BAR_POSITION;
    public static ForgeConfigSpec.ConfigValue<String> MANA_BAR_ORIENTATION;
    public static final ClientConfig INSTANCE;
    public static final ForgeConfigSpec SPEC;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Graphics settings").push("graphics");
        BETTER_LAYERING = builder.comment(new String[]{"Enable better particle/effect layering.", "Fixes particles and effects rendering behind clouds and weather.", "NOTE: Does NOT work with fabulous graphics mode."}).define("betterLayering", true);
        builder.pop();
        builder.comment("UI settings").push("ui");
        MANA_BAR_POSITION = builder.comment("Onscreen positioning of the magic power meter.").defineInList("manaBarPosition", (Object)"top", Positions.VALUES);
        MANA_BAR_ORIENTATION = builder.comment("Orientation of the magic power meter.").defineInList("manaBarOrientation", (Object)"default", Orientations.VALUES);
        builder.pop();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (ClientConfig)specPair.getLeft();
    }

    public static class Positions {
        public static final String BOTTOM_LEFT = "bottomLeft";
        public static final String LEFT = "left";
        public static final String TOP_LEFT = "topLeft";
        public static final String TOP = "top";
        public static final String TOP_RIGHT = "topRight";
        public static final String RIGHT = "right";
        public static final String BOTTOM_RIGHT = "bottomRight";
        public static final List<String> VALUES = ImmutableList.of((Object)"bottomLeft", (Object)"left", (Object)"topLeft", (Object)"top", (Object)"topRight", (Object)"right", (Object)"bottomRight");
    }

    public static class Orientations {
        public static final String HORIZONTAL = "horizontal";
        public static final String VERTICAL = "vertical";
        public static final String DEFAULT = "default";
        public static final List<String> VALUES = ImmutableList.of((Object)"horizontal", (Object)"vertical", (Object)"default");
    }
}

