/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.capability;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import elucent.eidolon.api.research.Research;
import elucent.eidolon.api.spells.Rune;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.capability.IKnowledge;
import elucent.eidolon.registries.Researches;
import elucent.eidolon.registries.Runes;
import elucent.eidolon.registries.Signs;
import elucent.eidolon.util.KnowledgeUtil;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class KnowledgeCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"knowledge").requires(player -> player.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").then(Commands.m_82127_((String)"signs").executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), (player, sources) -> player.getCapability(IKnowledge.INSTANCE).ifPresent(k -> KnowledgeUtil.resetSigns((Entity)player)))))).then(Commands.m_82127_((String)"facts").executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), (player, sources) -> player.getCapability(IKnowledge.INSTANCE).ifPresent(k -> KnowledgeUtil.resetFacts((Entity)player)))))).then(Commands.m_82127_((String)"research").executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), (player, sources) -> player.getCapability(IKnowledge.INSTANCE).ifPresent(k -> KnowledgeUtil.resetResearch((Entity)player)))))).then(Commands.m_82127_((String)"runes").executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), (player, sources) -> player.getCapability(IKnowledge.INSTANCE).ifPresent(k -> KnowledgeUtil.resetRunes((Entity)player))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"grant").then(Commands.m_82127_((String)"sign").then(Commands.m_82129_((String)"sign", (ArgumentType)new SignArgument()).executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), (player, sources) -> player.getCapability(IKnowledge.INSTANCE).ifPresent(k -> KnowledgeUtil.grantSign((Entity)player, SignArgument.getSign(ctx, "sign")))))))).then(Commands.m_82127_((String)"fact").then(Commands.m_82129_((String)"fact", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), (player, sources) -> player.getCapability(IKnowledge.INSTANCE).ifPresent(k -> KnowledgeUtil.grantFact((Entity)player, ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"fact")))))))).then(Commands.m_82127_((String)"research").then(Commands.m_82129_((String)"research", (ArgumentType)new ResearchArgument()).executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), (player, sources) -> player.getCapability(IKnowledge.INSTANCE).ifPresent(k -> KnowledgeUtil.grantResearch((Entity)player, ResearchArgument.getResearch(ctx, "research")))))))).then(Commands.m_82127_((String)"rune").then(Commands.m_82129_((String)"rune", (ArgumentType)new RuneArgument()).executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), (player, sources) -> player.getCapability(IKnowledge.INSTANCE).ifPresent(k -> KnowledgeUtil.grantRune((Entity)player, RuneArgument.getRune(ctx, "rune"))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").then(Commands.m_82127_((String)"sign").then(Commands.m_82129_((String)"sign", (ArgumentType)new SignArgument()).executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), (player, sources) -> player.getCapability(IKnowledge.INSTANCE).ifPresent(k -> KnowledgeUtil.removeSign((Entity)player, SignArgument.getSign(ctx, "sign")))))))).then(Commands.m_82127_((String)"fact").then(Commands.m_82129_((String)"fact", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), (player, sources) -> player.getCapability(IKnowledge.INSTANCE).ifPresent(k -> KnowledgeUtil.removeFact((Entity)player, ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"fact")))))))).then(Commands.m_82127_((String)"research").then(Commands.m_82129_((String)"research", (ArgumentType)new ResearchArgument()).executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), (player, sources) -> player.getCapability(IKnowledge.INSTANCE).ifPresent(k -> KnowledgeUtil.removeResearch((Entity)player, ResearchArgument.getResearch(ctx, "research").getRegistryName()))))))).then(Commands.m_82127_((String)"rune").then(Commands.m_82129_((String)"rune", (ArgumentType)new RuneArgument()).executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), (player, sources) -> player.getCapability(IKnowledge.INSTANCE).ifPresent(k -> KnowledgeUtil.removeRune((Entity)player, RuneArgument.getRune(ctx, "rune"))))))))));
    }

    private static int apply(CommandSourceStack sources, Collection<? extends Player> players, BiConsumer<Player, CommandSourceStack> action) {
        for (Player player : players) {
            action.accept(player, sources);
        }
        if (players.size() == 1) {
            sources.m_288197_(() -> Component.m_237110_((String)"commands.eidolon.knowledge.success.single", (Object[])new Object[]{((Player)players.iterator().next()).m_5446_()}), true);
        } else {
            sources.m_288197_(() -> Component.m_237110_((String)"commands.eidolon.knowledge.success.multiple", (Object[])new Object[]{players.size()}), true);
        }
        return players.size();
    }

    public static class SignArgument
    implements ArgumentType<Sign> {
        private static final DynamicCommandExceptionType UNKNOWN = new DynamicCommandExceptionType(obj -> Component.m_237110_((String)"argument.eidolon.sign.unknown", (Object[])new Object[]{obj}));

        public static Sign getSign(CommandContext<?> context, String name) {
            return (Sign)context.getArgument(name, Sign.class);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            for (Sign s : Signs.getSigns()) {
                if (!s.getRegistryName().toString().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(s.getRegistryName().toString());
            }
            return builder.buildFuture();
        }

        public Sign parse(StringReader reader) throws CommandSyntaxException {
            ResourceLocation rl = ResourceLocation.m_135818_((StringReader)reader);
            Sign s = Signs.find(rl);
            if (s == null) {
                throw UNKNOWN.create((Object)rl.toString());
            }
            return s;
        }

        public static SignArgument signs() {
            return new SignArgument();
        }
    }

    public static class ResearchArgument
    implements ArgumentType<Research> {
        private static final DynamicCommandExceptionType UNKNOWN = new DynamicCommandExceptionType(obj -> Component.m_237110_((String)"argument.eidolon.research.unknown", (Object[])new Object[]{obj}));

        public static ResearchArgument researches() {
            return new ResearchArgument();
        }

        public static Research getResearch(CommandContext<?> context, String name) {
            return (Research)context.getArgument(name, Research.class);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            for (Research r : Researches.getResearches()) {
                if (!r.getRegistryName().toString().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(r.getRegistryName().toString());
            }
            return builder.buildFuture();
        }

        public Research parse(StringReader reader) throws CommandSyntaxException {
            ResourceLocation rl = ResourceLocation.m_135818_((StringReader)reader);
            Research r = Researches.find(rl);
            if (r == null) {
                throw UNKNOWN.create((Object)rl.toString());
            }
            return r;
        }
    }

    public static class RuneArgument
    implements ArgumentType<Rune> {
        private static final DynamicCommandExceptionType UNKNOWN = new DynamicCommandExceptionType(obj -> Component.m_237110_((String)"argument.eidolon.rune.unknown", (Object[])new Object[]{obj}));

        public static RuneArgument runes() {
            return new RuneArgument();
        }

        public static Rune getRune(CommandContext<?> context, String name) {
            return (Rune)context.getArgument(name, Rune.class);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            for (Rune r : Runes.getRunes()) {
                if (!r.getRegistryName().toString().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(r.getRegistryName().toString());
            }
            return builder.buildFuture();
        }

        public Rune parse(StringReader reader) throws CommandSyntaxException {
            ResourceLocation rl = ResourceLocation.m_135818_((StringReader)reader);
            Rune r = Runes.find(rl);
            if (r == null) {
                throw UNKNOWN.create((Object)rl.toString());
            }
            return r;
        }
    }
}

