/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.api.ritual;

import elucent.eidolon.api.ritual.IRequirement;
import elucent.eidolon.api.ritual.IRitualItemFocus;
import elucent.eidolon.api.ritual.IRitualItemProvider;
import elucent.eidolon.api.ritual.RequirementInfo;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.network.Networking;
import elucent.eidolon.network.RitualConsumePacket;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FocusItemRequirement
implements IRequirement {
    final Ingredient match;

    public FocusItemRequirement(ItemStack item) {
        this.match = Ingredient.m_43927_((ItemStack[])new ItemStack[]{item});
    }

    public FocusItemRequirement(ItemLike item) {
        this.match = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
    }

    public FocusItemRequirement(TagKey<Item> item) {
        this.match = Ingredient.m_204132_(item);
    }

    public FocusItemRequirement(Ingredient ingredient) {
        this.match = ingredient;
    }

    @Override
    public RequirementInfo isMet(Ritual ritual, Level world, BlockPos pos) {
        List<IRitualItemFocus> tiles = Ritual.getTilesWithinAABB(IRitualItemFocus.class, world, ritual.getSearchBounds(pos));
        if (tiles.isEmpty()) {
            return RequirementInfo.FALSE;
        }
        for (IRitualItemFocus tile : tiles) {
            ItemStack stack = tile.provide();
            if (!this.match.test(stack)) continue;
            return new RequirementInfo(true, ((BlockEntity)tile).m_58899_());
        }
        return RequirementInfo.FALSE;
    }

    @Override
    public void whenMet(Ritual ritual, Level world, BlockPos pos, RequirementInfo info) {
        BlockEntity blockEntity = world.m_7702_(info.getPos());
        if (blockEntity instanceof IRitualItemProvider) {
            IRitualItemProvider provider = (IRitualItemProvider)blockEntity;
            provider.take();
        }
        if (!world.f_46443_) {
            Networking.sendToTracking(world, pos.m_6630_(2), new RitualConsumePacket(info.getPos(), pos.m_6630_(2), ritual.getRed(), ritual.getGreen(), ritual.getBlue()));
        }
    }

    @Override
    public int getPriority() {
        return 10;
    }
}

