/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vsc.dynamicpack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.vsc.CutBlockType;
import net.mehvahdjukaar.vsc.VSC;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.Logger;

public class ClientDynamicResourcesHandler
extends DynClientResourcesGenerator {
    public static final ClientDynamicResourcesHandler INSTANCE = new ClientDynamicResourcesHandler();

    public ClientDynamicResourcesHandler() {
        super(new DynamicTexturePack(VSC.res("generated_pack")));
    }

    public Logger getLogger() {
        return VSC.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return true;
    }

    public void regenerateDynamicAssets(ResourceManager manager) {
        StaticResource blockState = StaticResource.getOrFail((ResourceManager)manager, (ResourceLocation)ResType.BLOCKSTATES.getPath(VSC.res("vertical_slab_template")));
        StaticResource blockModel = StaticResource.getOrFail((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(VSC.res("vertical_slab_template")));
        StaticResource itemModel = StaticResource.getOrFail((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(VSC.res("vertical_slab_template")));
        for (Map.Entry<CutBlockType, Block> e : VSC.VERTICAL_SLABS.entrySet()) {
            try {
                CutBlockType type = e.getKey();
                ResourceLocation texture = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)type.slab);
                ResourceLocation blockModelLocation = ClientDynamicResourcesHandler.findFirstBlockModel(manager, type.base);
                ResourceLocation id = Utils.getID((Block)e.getValue());
                String modelId = new ResourceLocation(id.m_135827_(), "block/" + id.m_135815_()).toString();
                this.addSimilarJsonResource(manager, blockModel, text -> text.replace("$texture", texture.toString()), name -> name.replace("vertical_slab_template", id.m_135815_()));
                this.addSimilarJsonResource(manager, blockState, text -> {
                    text = text.replace("$v_slab", modelId);
                    text = text.replace("$block", blockModelLocation.toString());
                    return text;
                }, name -> name.replace("vertical_slab_template", id.m_135815_()));
                this.addSimilarJsonResource(manager, itemModel, text -> text.replace("$v_slab", modelId), name -> name.replace("vertical_slab_template", id.m_135815_()));
            }
            catch (Exception ex) {
                VSC.LOGGER.error("Failed to generate assets for {}", (Object)e.getValue());
            }
        }
    }

    public static ResourceLocation findFirstBlockModel(ResourceManager manager, Block block) throws FileNotFoundException {
        ResourceLocation resourceLocation;
        block8: {
            ResourceLocation res = Utils.getID((Block)block);
            Optional blockState = manager.m_213713_(ResType.BLOCKSTATES.getPath(res));
            InputStream bsStream = ((Resource)blockState.get()).m_215507_();
            try {
                JsonObject bsElement = RPUtils.deserializeJson((InputStream)bsStream);
                resourceLocation = new ResourceLocation((String)RPUtils.findAllResourcesInJsonRecursive((JsonElement)bsElement.getAsJsonObject(), s -> s.equals("model")).stream().findAny().get());
                if (bsStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (bsStream != null) {
                        try {
                            bsStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new FileNotFoundException("Could not fine any model for block " + String.valueOf(block));
                }
            }
            bsStream.close();
        }
        return resourceLocation;
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        VSC.VERTICAL_SLABS.forEach((w, b) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"block_type.v_slab_compat.vertical_slab", (BlockType)w, (Block)b));
    }
}

