/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside.libmc;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TreeCutting {
    private static final List<Vec3i> hoffsets = ImmutableList.of((Object)new Vec3i(1, 0, 0), (Object)new Vec3i(1, 0, 1), (Object)new Vec3i(0, 0, 1), (Object)new Vec3i(-1, 0, 1), (Object)new Vec3i(-1, 0, 0), (Object)new Vec3i(-1, 0, -1), (Object)new Vec3i(0, 0, -1), (Object)new Vec3i(1, 0, -1));

    public static boolean canChop(BlockState state) {
        return TreeCutting.isLog(state);
    }

    private static boolean isLog(BlockState state) {
        return state.m_204336_(BlockTags.f_13106_);
    }

    private static boolean isSameLog(BlockState a, BlockState b) {
        return a.m_60734_() == b.m_60734_();
    }

    private static boolean isLeaves(BlockState state) {
        if (state.m_60734_() instanceof LeavesBlock) {
            return true;
        }
        return state.m_204336_(BlockTags.f_13035_);
    }

    private static List<BlockPos> findBlocksAround(Level world, BlockPos centerPos, BlockState leaf_type_state, Set<BlockPos> checked, int recursion_left) {
        ArrayList<BlockPos> to_decay = new ArrayList<BlockPos>();
        for (int y = -1; y <= 1; ++y) {
            BlockPos layer = centerPos.m_7918_(0, y, 0);
            for (Vec3i v : hoffsets) {
                BlockPos pos = layer.m_121955_(v);
                if (checked.contains(pos) || world.m_8055_(pos).m_60734_() != leaf_type_state.m_60734_()) continue;
                checked.add(pos);
                to_decay.add(pos);
                if (recursion_left <= 0) continue;
                to_decay.addAll(TreeCutting.findBlocksAround(world, pos, leaf_type_state, checked, recursion_left - 1));
            }
        }
        return to_decay;
    }

    private static void breakBlock(Level world, BlockPos pos, @Nullable Function<ItemEntity, ItemEntity> entity_converter) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel sworld = (ServerLevel)world;
        BlockState state = sworld.m_8055_(pos);
        List drops = Block.m_49869_((BlockState)state, (ServerLevel)sworld, (BlockPos)pos, null);
        drops.forEach(stack -> {
            double d = (double)EntityType.f_20461_.m_20679_() / 2.0;
            double e = (double)pos.m_123341_() + 0.5 + Mth.m_216263_((RandomSource)sworld.f_46441_, (double)-0.15, (double)0.15);
            double f = (double)pos.m_123342_() + 0.5 + Mth.m_216263_((RandomSource)sworld.f_46441_, (double)-0.15, (double)0.15) - d;
            double g = (double)pos.m_123343_() + 0.5 + Mth.m_216263_((RandomSource)sworld.f_46441_, (double)-0.15, (double)0.15);
            ItemEntity ie = new ItemEntity((Level)sworld, e, f, g, stack);
            ie.m_32060_();
            if (entity_converter != null) {
                ie = (ItemEntity)entity_converter.apply(ie);
            }
            sworld.m_7967_((Entity)ie);
        });
        state.m_222967_(sworld, pos, ItemStack.f_41583_, true);
        world.m_7731_(pos, world.m_6425_(pos).m_76188_(), 11);
    }

    private static boolean alwaysBreak(BlockState state) {
        return state.m_60734_() == Blocks.f_50717_;
    }

    public static int chopTree(Level world, BlockState broken_state, BlockPos startPos, int max_blocks_to_break, boolean without_target_block) {
        return TreeCutting.chopTree(world, broken_state, startPos, max_blocks_to_break, without_target_block, null);
    }

    public static int chopTree(Level world, BlockState broken_state, BlockPos startPos, int max_blocks_to_break, boolean without_target_block, @Nullable Function<ItemEntity, ItemEntity> entity_converter) {
        if (world.f_46443_ || !TreeCutting.isLog(broken_state)) {
            return 0;
        }
        long ymin = startPos.m_123342_();
        long max_leaf_distance = 8L;
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        ArrayList<BlockPos> to_break = new ArrayList<BlockPos>();
        ArrayList<BlockPos> to_decay = new ArrayList<BlockPos>();
        checked.add(startPos);
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        LinkedList<BlockPos> upqueue = new LinkedList<BlockPos>();
        queue.add(startPos);
        int cutlevel = 0;
        int steps_left = 128;
        while (!queue.isEmpty() && --steps_left >= 0) {
            BlockPos pos = (BlockPos)queue.removeFirst();
            BlockPos uppos = pos.m_7494_();
            BlockState upstate = world.m_8055_(uppos);
            if (!checked.contains(uppos)) {
                checked.add(uppos);
                if (TreeCutting.isSameLog(upstate, broken_state) || TreeCutting.alwaysBreak(upstate)) {
                    upqueue.add(uppos);
                    to_break.add(uppos);
                    steps_left = 128;
                } else {
                    boolean isleaf = TreeCutting.isLeaves(upstate);
                    if (isleaf || world.m_46859_(uppos) || upstate.m_60734_() instanceof VineBlock) {
                        if (isleaf) {
                            to_decay.add(uppos);
                        }
                        for (Vec3i v : hoffsets) {
                            BlockPos p = uppos.m_121955_(v);
                            if (checked.contains(p)) continue;
                            checked.add(p);
                            BlockState st = world.m_8055_(p);
                            Block bl = st.m_60734_();
                            if (TreeCutting.isSameLog(st, broken_state) || TreeCutting.alwaysBreak(st)) {
                                queue.add(p);
                                to_break.add(p);
                                continue;
                            }
                            if (!TreeCutting.isLeaves(st)) continue;
                            to_decay.add(p);
                        }
                    }
                }
            }
            for (Vec3i v : hoffsets) {
                BlockPos p = pos.m_121955_(v);
                if (checked.contains(p)) continue;
                checked.add(p);
                if (p.m_123331_((Vec3i)new BlockPos(startPos.m_123341_(), p.m_123342_(), startPos.m_123343_())) > (double)(cutlevel > 2 ? 256 : 9)) continue;
                BlockState st = world.m_8055_(p);
                Block bl = st.m_60734_();
                if (TreeCutting.isSameLog(st, broken_state) || TreeCutting.alwaysBreak(st)) {
                    queue.add(p);
                    to_break.add(p);
                    continue;
                }
                if (!TreeCutting.isLeaves(st)) continue;
                queue.add(p);
                to_decay.add(p);
            }
            if (!queue.isEmpty() || upqueue.isEmpty()) continue;
            queue = upqueue;
            upqueue = new LinkedList();
            ++cutlevel;
        }
        for (BlockPos pos : to_decay) {
            int dist = 1;
            to_break.addAll(TreeCutting.findBlocksAround(world, pos, broken_state, checked, dist));
        }
        if (!to_decay.isEmpty()) {
            BlockState leaf_type_state = world.m_8055_((BlockPos)to_decay.get(0));
            ArrayList<BlockPos> leafs = to_decay;
            to_decay = new ArrayList();
            for (BlockPos pos : leafs) {
                int dist = 3;
                to_decay.add(pos);
                to_decay.addAll(TreeCutting.findBlocksAround(world, pos, leaf_type_state, checked, dist));
            }
        }
        if (without_target_block) {
            checked.remove(startPos);
        } else {
            to_break.add(startPos);
        }
        for (BlockPos pos : to_break) {
            TreeCutting.breakBlock(world, pos, entity_converter);
        }
        for (BlockPos pos : to_decay) {
            TreeCutting.breakBlock(world, pos, entity_converter);
        }
        return Mth.m_14045_((int)(to_break.size() * 6 / 5 + to_decay.size() / 10 - 1), (int)1, (int)65535);
    }
}

