/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside.libmc;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import wile.anthillinside.libmc.Auxiliaries;

public class ToolActions {

    public static class Beekeeping {
        public static ItemStack harvest(Level world, BlockPos pos, boolean honey_not_comb) {
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if (!(block instanceof BeehiveBlock)) {
                return ItemStack.f_41583_;
            }
            BeehiveBlock beehive = (BeehiveBlock)block;
            int honey = (Integer)state.m_61143_((Property)BeehiveBlock.f_49564_);
            if (honey <= 0) {
                return ItemStack.f_41583_;
            }
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(honey - 1)), 3);
            return new ItemStack((ItemLike)(honey_not_comb ? Items.f_42787_ : Items.f_42784_));
        }
    }

    public static class Fishing {
        public static List<ItemStack> fish(ServerLevel world, BlockPos pos, @Nullable ItemStack rod) {
            if (rod == null) {
                rod = new ItemStack((ItemLike)Items.f_42523_);
            }
            LootParams params = new LootParams.Builder(world).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)rod).m_287235_(LootContextParamSets.f_81414_);
            LootTable table = world.m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78720_);
            ObjectArrayList list = table.m_287195_(params);
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }
    }

    public static class BlockPlacing {
        public static boolean isPlaceable(Item item) {
            return item instanceof BlockItem;
        }

        public static boolean isPlantable(Item item) {
            return Block.m_49814_((Item)item) instanceof BushBlock;
        }

        public static PlacementResult place(Level world, BlockPos pos, ItemStack stack) {
            return BlockPlacing.place(world, pos, stack, false);
        }

        public static PlacementResult place(Level world, BlockPos pos, ItemStack stack, boolean simulate) {
            if (world.m_5776_()) {
                return PlacementResult.FAILED;
            }
            Item item = stack.m_41720_();
            if (!(item instanceof BlockItem)) {
                return PlacementResult.INVALID_ITEM;
            }
            BlockItem item2 = (BlockItem)item;
            if (!world.m_8055_(pos).m_247087_()) {
                return PlacementResult.LOCATION_BLOCKED;
            }
            Block bush = Block.m_49814_((Item)item2);
            BlockState bush_state = bush.m_49966_();
            if (!bush_state.m_60710_((LevelReader)world, pos)) {
                return PlacementResult.INVALID_LOCATION;
            }
            List blocking_entities = world.m_6443_(Entity.class, new AABB(pos), e -> !(e instanceof ItemEntity));
            if (!blocking_entities.isEmpty()) {
                return PlacementResult.LOCATION_BLOCKED;
            }
            if (simulate) {
                return PlacementResult.SUCCESS;
            }
            if (!world.m_7731_(pos, bush_state, 515)) {
                return PlacementResult.FAILED;
            }
            SoundType sound = bush_state.m_60827_();
            world.m_5594_(null, pos, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
            return PlacementResult.SUCCESS;
        }

        public static enum PlacementResult {
            SUCCESS,
            FAILED,
            INVALID_ITEM,
            INVALID_LOCATION,
            LOCATION_BLOCKED;

        }
    }

    public static class BlockBreaking {
        public static boolean isBreakable(BlockState state, BlockPos pos, Level world) {
            if (state.m_60795_() || state.m_278721_()) {
                return false;
            }
            Block block = state.m_60734_();
            if (block == Blocks.f_50752_ || block == Blocks.f_50083_ || block == Blocks.f_50257_ || block == Blocks.f_50446_ || block == Blocks.f_50258_ || block == Blocks.f_50142_ || block == Blocks.f_50375_ || block == Blocks.f_50016_) {
                return false;
            }
            float bh = state.m_60800_((BlockGetter)world, pos);
            return !(bh < 0.0f) && !(bh > 55.0f);
        }

        public static void dropOnGround(ItemStack stack, BlockPos pos, Level world) {
            ItemEntity e = new ItemEntity(world, (double)world.f_46441_.m_188501_() * 0.1 + 0.5 + (double)pos.m_123341_(), (double)world.f_46441_.m_188501_() * 0.1 + 0.5 + (double)pos.m_123342_(), (double)world.f_46441_.m_188501_() * 0.1 + 0.5 + (double)pos.m_123343_(), stack);
            e.m_32060_();
            e.m_20334_((double)world.f_46441_.m_188501_() * 0.1 - 0.05, (double)world.f_46441_.m_188501_() * 0.1 - 0.03, (double)world.f_46441_.m_188501_() * 0.1 - 0.05);
            world.m_7967_((Entity)e);
        }

        public static List<ItemStack> blockDrops(BlockState state, BlockPos pos, ServerLevel world, @Nullable ItemStack tool) {
            if (!world.m_46469_().m_46207_(GameRules.f_46136_)) {
                return Collections.emptyList();
            }
            if (tool != null) {
                Item item = tool.m_41720_();
                if (!(item instanceof DiggerItem)) {
                    return Collections.emptyList();
                }
                DiggerItem pick = (DiggerItem)item;
                boolean candrop = pick.m_8096_(state);
                if (!candrop) {
                    return Collections.emptyList();
                }
            }
            return Block.m_49869_((BlockState)state, (ServerLevel)world, (BlockPos)pos, (BlockEntity)world.m_7702_(pos));
        }

        public static Optional<List<ItemStack>> breakBlock(BlockState state, BlockPos pos, Level world, @Nullable ItemStack tool, boolean dropYield) {
            if (world.f_46443_ || !(world instanceof ServerLevel)) {
                return Optional.empty();
            }
            if (!BlockBreaking.isBreakable(state, pos, world)) {
                return Optional.empty();
            }
            List<ItemStack> drops = BlockBreaking.blockDrops(state, pos, (ServerLevel)world, tool);
            world.m_46961_(pos, false);
            if (!dropYield) {
                return Optional.of(drops);
            }
            for (ItemStack drop : drops) {
                BlockBreaking.dropOnGround(drop, pos, world);
            }
            return Optional.of(Collections.emptyList());
        }

        public static int breakTime(BlockState state, BlockPos pos, Level world, @Nullable ItemStack tool, int minTime, int maxTime, float reluctance) {
            float f;
            minTime = Math.max(0, minTime);
            maxTime = Math.max(minTime, maxTime);
            Item item = tool.m_41720_();
            if (item instanceof DiggerItem) {
                DiggerItem pick = (DiggerItem)item;
                f = Mth.m_14036_((float)pick.m_8102_(tool, state), (float)0.1f, (float)10.0f);
            } else {
                f = 1.0f;
            }
            float speedup = f;
            float destroy_time = state.m_60800_((BlockGetter)world, pos) * 20.0f;
            if (destroy_time <= 0.0f) {
                return minTime;
            }
            return Mth.m_14045_((int)((int)(destroy_time * reluctance / speedup)), (int)minTime, (int)maxTime);
        }
    }

    public static class Farming {
        public static boolean isPlantable(Item item) {
            return Farming.isPlantable(Block.m_49814_((Item)item));
        }

        public static boolean isPlantable(Block block) {
            return block instanceof CropBlock;
        }

        public static Optional<List<ItemStack>> harvestCrop(ServerLevel world, BlockPos pos, boolean try_replant, ItemStack bone_meal) {
            ItemStack seed;
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if (!(block instanceof CropBlock)) {
                return Optional.empty();
            }
            CropBlock crop = (CropBlock)block;
            if (!crop.m_52307_(state)) {
                if (!bone_meal.m_41619_() && Farming.fertilizePlant(world, pos, bone_meal, true, false)) {
                    bone_meal.m_41774_(1);
                }
                return Optional.of(Collections.emptyList());
            }
            List drops = state.m_287290_(new LootParams.Builder(world).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81461_, (Object)state).m_287289_(LootContextParams.f_81462_, (Object)world.m_7702_(pos)).m_287289_(LootContextParams.f_81455_, null).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_));
            world.m_46961_(pos, false);
            if (try_replant && !(seed = crop.m_7397_((BlockGetter)world, pos, state)).m_41619_()) {
                boolean fetched_seed = false;
                for (ItemStack stack : drops) {
                    if (!stack.m_150930_(seed.m_41720_())) continue;
                    stack.m_41774_(1);
                    fetched_seed = true;
                    break;
                }
                if (fetched_seed) {
                    int init_val = crop.m_52305_(crop.m_49966_());
                    world.m_7731_(pos, crop.m_52289_(init_val), 3);
                }
            }
            return Optional.of(drops);
        }

        public static Optional<List<ItemStack>> harvestPlant(ServerLevel world, BlockPos pos, boolean try_replant, ItemStack bone_meal) {
            return Farming.harvestCrop(world, pos, try_replant, bone_meal).or(() -> {
                BlockState state = world.m_8055_(pos);
                if (state.m_60795_()) {
                    return Optional.empty();
                }
                Block block = state.m_60734_();
                Supplier<List> dropgen = () -> state.m_287290_(new LootParams.Builder(world).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81461_, (Object)state).m_287289_(LootContextParams.f_81462_, (Object)world.m_7702_(pos)).m_287289_(LootContextParams.f_81455_, null).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_));
                if (block instanceof StemGrownBlock) {
                    List drops = dropgen.get();
                    if (!drops.isEmpty()) {
                        world.m_46961_(pos, false);
                        return Optional.of(drops);
                    }
                } else {
                    IntegerProperty age;
                    Property ager;
                    if (block == Blocks.f_50130_) {
                        BlockPos p2 = pos;
                        int n_harvested = 0;
                        while (world.m_8055_(p2.m_7494_()).m_60734_() == block) {
                            p2 = p2.m_7494_();
                        }
                        while (world.m_8055_(p2.m_7495_()).m_60734_() == block) {
                            ++n_harvested;
                            world.m_46961_(p2, false);
                            p2 = p2.m_7495_();
                        }
                        if (n_harvested == 0) {
                            return Optional.empty();
                        }
                        return Optional.of(Collections.singletonList(new ItemStack((ItemLike)Blocks.f_50130_.m_5456_(), n_harvested)));
                    }
                    if ((Farming.isPlantable(block) || block instanceof BushBlock) && (ager = (Property)state.m_61147_().stream().filter(p -> p.m_61708_().equals("age")).findFirst().orElse(null)) instanceof IntegerProperty && (Integer)state.m_61143_((Property)(age = (IntegerProperty)ager)) >= (Integer)Collections.max(age.m_6908_())) {
                        ItemStack seed_dropped;
                        ItemStack seed;
                        List drops = dropgen.get();
                        if (drops.isEmpty()) {
                            return Optional.empty();
                        }
                        world.m_46961_(pos, false);
                        if (try_replant && !(seed = block.m_7397_((BlockGetter)world, pos, state)).m_41619_() && !(seed_dropped = drops.stream().filter(stack -> stack.m_150930_(seed.m_41720_())).findFirst().orElse(ItemStack.f_41583_)).m_41619_()) {
                            seed_dropped.m_41774_(1);
                            world.m_7731_(pos, (BlockState)state.m_61124_((Property)age, (Comparable)Integer.valueOf(0)), 3);
                        }
                        return Optional.of(drops);
                    }
                }
                if (!bone_meal.m_41619_() && block instanceof BonemealableBlock) {
                    bone_meal.m_41774_(1);
                    ((BonemealableBlock)block).m_214148_(world, world.m_213780_(), pos, state);
                }
                return Optional.empty();
            });
        }

        public static boolean fertilizePlant(ServerLevel world, BlockPos pos, ItemStack bone_meal, boolean always_succeed, boolean no_particles) {
            if (bone_meal.m_41619_() || !bone_meal.m_150930_(Items.f_42499_)) {
                return false;
            }
            BlockState state = world.m_8055_(pos);
            if (!(state.m_204336_(BlockTags.f_13073_) || state.m_204336_(BlockTags.f_13104_) || state.m_204336_(BlockTags.f_13041_) || state.m_204336_(BlockTags.f_13037_))) {
                return false;
            }
            Block block = state.m_60734_();
            if (!(block instanceof BonemealableBlock)) {
                return false;
            }
            BonemealableBlock block2 = (BonemealableBlock)block;
            if (!block2.m_7370_((LevelReader)world, pos, state, world.m_5776_())) {
                return false;
            }
            if (!always_succeed && !block2.m_214167_((Level)world, world.m_213780_(), pos, state)) {
                return false;
            }
            block2.m_214148_(world, world.m_213780_(), pos, state);
            if (!no_particles) {
                Auxiliaries.particles((Level)world, pos, (ParticleOptions)ParticleTypes.f_123748_);
            }
            return true;
        }

        public static boolean isFertilizableNonFoliage(Level world, BlockPos pos) {
            BlockState state = world.m_8055_(pos);
            if (!(state.m_204336_(BlockTags.f_13073_) || state.m_204336_(BlockTags.f_13104_) || state.m_204336_(BlockTags.f_13041_) || state.m_204336_(BlockTags.f_13037_))) {
                return false;
            }
            Block block = state.m_60734_();
            if (!(block instanceof BonemealableBlock)) {
                return false;
            }
            BonemealableBlock block2 = (BonemealableBlock)block;
            return block2.m_7370_((LevelReader)world, pos, state, world.m_5776_());
        }
    }

    public static class Shearing {
        public static boolean shearEntity(LivingEntity entity) {
            if (entity.m_9236_().m_5776_() || !(entity instanceof Shearable)) {
                return false;
            }
            Shearable target = (Shearable)entity;
            if (!target.m_6220_()) {
                return false;
            }
            BlockPos pos = new BlockPos((Vec3i)entity.m_20183_());
            ItemStack tool = new ItemStack((ItemLike)Items.f_42574_);
            target.m_5851_(SoundSource.BLOCKS);
            return true;
        }

        public static boolean shearEntities(Level world, AABB range, int max_count) {
            if (max_count <= 0) {
                return false;
            }
            List entities = world.m_6443_(LivingEntity.class, range, e -> e instanceof Shearable);
            boolean snipped = false;
            for (LivingEntity e2 : entities) {
                if (!Shearing.shearEntity(e2)) continue;
                snipped = true;
                if (--max_count != 0) continue;
                break;
            }
            return snipped;
        }

        public static boolean shearPlant(Level world, BlockPos pos) {
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if (!state.m_204336_(BlockTags.f_13035_) && block != Blocks.f_50033_ && block != Blocks.f_50034_ & block != Blocks.f_50359_ && block != Blocks.f_50035_ && block != Blocks.f_50036_ && block != Blocks.f_50191_ && block != Blocks.f_50267_ && !state.m_204336_(BlockTags.f_13089_)) {
                return false;
            }
            ItemEntity ie = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)block.m_5456_()));
            ie.m_32060_();
            world.m_7967_((Entity)ie);
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            if (!world.m_5776_()) {
                world.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 0.8f, 1.1f);
            }
            return true;
        }
    }
}

