/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside.libmc;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import wile.anthillinside.libmc.Auxiliaries;

public class StandardItems {

    public static class BaseBlockItem
    extends BlockItem {
        public BaseBlockItem(Block block, Item.Properties properties) {
            super(block, properties);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
            Auxiliaries.Tooltip.addInformation(stack, (BlockGetter)world, tooltip, flag, true);
        }

        public InteractionResult m_6225_(UseOnContext context) {
            InteractionResult ir = this.onItemUseFirst(context.m_43722_(), context);
            if (ir != InteractionResult.PASS) {
                return ir;
            }
            return super.m_6225_(context);
        }

        public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
            return InteractionResult.PASS;
        }
    }

    public static class BaseItem
    extends Item
    implements IStandardItem {
        public BaseItem(Item.Properties properties) {
            super(properties);
        }

        public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
            return false;
        }

        public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
            return false;
        }

        public InteractionResult m_6225_(UseOnContext context) {
            return this.onItemUseFirst(context.m_43722_(), context);
        }

        public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
            return InteractionResult.PASS;
        }
    }

    public static interface IStandardItem {
    }
}

