/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside.libmc;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.DistExecutor;
import wile.anthillinside.libmc.Auxiliaries;

public class SidedProxy {
    private static final ISidedProxy proxy = (ISidedProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);

    @Nullable
    public static Player getPlayerClientSide() {
        return proxy.getPlayerClientSide();
    }

    @Nullable
    public static Level getWorldClientSide() {
        return proxy.getWorldClientSide();
    }

    @Nullable
    public static Minecraft mc() {
        return proxy.mc();
    }

    @Nullable
    public static Optional<Boolean> isCtrlDown() {
        return proxy.isCtrlDown();
    }

    @Nullable
    public static Optional<Boolean> isShiftDown() {
        return proxy.isShiftDown();
    }

    private static interface ISidedProxy {
        @Nullable
        default public Player getPlayerClientSide() {
            return null;
        }

        @Nullable
        default public Level getWorldClientSide() {
            return null;
        }

        @Nullable
        default public Minecraft mc() {
            return null;
        }

        default public Optional<Boolean> isCtrlDown() {
            return Optional.empty();
        }

        default public Optional<Boolean> isShiftDown() {
            return Optional.empty();
        }
    }

    private static final class ServerProxy
    implements ISidedProxy {
        private ServerProxy() {
        }
    }

    private static final class ClientProxy
    implements ISidedProxy {
        private ClientProxy() {
        }

        @Override
        @Nullable
        public Player getPlayerClientSide() {
            return Minecraft.m_91087_().f_91074_;
        }

        @Override
        @Nullable
        public Level getWorldClientSide() {
            return Minecraft.m_91087_().f_91073_;
        }

        @Override
        @Nullable
        public Minecraft mc() {
            return Minecraft.m_91087_();
        }

        @Override
        public Optional<Boolean> isCtrlDown() {
            return Optional.of(Auxiliaries.isCtrlDown());
        }

        @Override
        public Optional<Boolean> isShiftDown() {
            return Optional.of(Auxiliaries.isShiftDown());
        }
    }
}

