/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside.blocks;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import wile.anthillinside.ModContent;
import wile.anthillinside.libmc.Auxiliaries;
import wile.anthillinside.libmc.Inventories;
import wile.anthillinside.libmc.Overlay;
import wile.anthillinside.libmc.StandardBlocks;

public class RedAntTrail {
    public static void on_config() {
    }

    public static class RedAntTrailBlock
    extends StandardBlocks.HorizontalWaterLoggable {
        public static final BooleanProperty FRONT = BooleanProperty.m_61465_((String)"front");
        public static final BooleanProperty LEFT = BooleanProperty.m_61465_((String)"left");
        public static final BooleanProperty RIGHT = BooleanProperty.m_61465_((String)"right");
        public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
        public static final BooleanProperty IN = BooleanProperty.m_61465_((String)"in");
        public static final BooleanProperty DROP = BooleanProperty.m_61465_((String)"drop");

        public RedAntTrailBlock(long config, BlockBehaviour.Properties props) {
            super(config, props.m_60924_((s, w, p) -> false), (List<BlockState> states) -> {
                HashMap<BlockState, VoxelShape> shapes = new HashMap<BlockState, VoxelShape>();
                AABB base_aabb = Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 0.2, 16.0);
                AABB up_aabb = Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 16.0, 0.2);
                for (BlockState state : states) {
                    Direction facing = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
                    VoxelShape shape = Shapes.m_83040_();
                    if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)Auxiliaries.getRotatedAABB(up_aabb, facing, true)), (BooleanOp)BooleanOp.f_82695_);
                    }
                    if (((Boolean)state.m_61143_((Property)FRONT)).booleanValue() || !((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)Auxiliaries.getRotatedAABB(base_aabb, facing, true)), (BooleanOp)BooleanOp.f_82695_);
                    }
                    shapes.putIfAbsent(state, shape);
                }
                return shapes;
            });
            this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.m_49966_().m_61124_((Property)FRONT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DROP, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        public Item m_5456_() {
            return ModContent.references.ANTS_ITEM;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
            return (Boolean)state.m_61143_((Property)DROP) == false ? Collections.singletonList(new ItemStack((ItemLike)this.m_5456_())) : List.of(new ItemStack((ItemLike)this.m_5456_()), new ItemStack((ItemLike)Items.f_41963_));
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{FRONT, LEFT, RIGHT, UP, IN, DROP});
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            BlockState state = super.m_5573_(context);
            if (state == null) {
                return null;
            }
            if (!((Boolean)state.m_61143_((Property)UP)).booleanValue() && context.m_43719_().m_122434_().m_122478_() && !this.m_7898_(state, (LevelReader)context.m_43725_(), context.m_8083_())) {
                return null;
            }
            return this.updatedState((BlockState)state.m_61124_((Property)DROP, (Comparable)Boolean.valueOf(false)), (LevelAccessor)context.m_43725_(), context.m_8083_());
        }

        public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            Direction block_facing = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
            for (Direction facing : Direction.values()) {
                Direction diagonal_facing;
                BlockPos diagonal_pos;
                BlockState diagonal_state;
                if (!facing.m_122434_().m_122479_() || facing == block_facing || !(diagonal_state = world.m_8055_(diagonal_pos = pos.m_121945_(facing).m_7495_())).m_60713_((Block)this) || ((Boolean)diagonal_state.m_61143_((Property)UP)).booleanValue() || (diagonal_facing = (Direction)diagonal_state.m_61143_((Property)HORIZONTAL_FACING)) != facing.m_122424_()) continue;
                world.m_7731_(diagonal_pos, (BlockState)diagonal_state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(true)), 2);
            }
        }

        @Override
        public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
            if (!(world instanceof Level)) {
                return state;
            }
            if (this.m_7898_(state = super.m_7417_(state, facing, facingState, world, pos, facingPos), (LevelReader)world, pos)) {
                return this.updatedState(state, world, pos);
            }
            return Blocks.f_50016_.m_49966_();
        }

        public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
            if (((Boolean)state.m_61143_((Property)DROP)).booleanValue()) {
                return true;
            }
            BlockState state_below = world.m_8055_(pos.m_7495_());
            if (state_below.m_204336_(BlockTags.f_13035_) || state_below.m_60659_((BlockGetter)world, pos.m_7495_(), Direction.UP, SupportType.RIGID)) {
                return true;
            }
            Direction facing = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
            return (Boolean)state.m_61143_((Property)UP) != false ? Block.m_49918_((VoxelShape)world.m_8055_(pos.m_121945_(facing)).m_60808_((BlockGetter)world, pos.m_121945_(facing)), (Direction)facing.m_122424_()) : Stream.of(pos.m_121945_(facing), pos.m_121945_(facing.m_122424_())).allMatch(np -> world.m_8055_(np).m_60734_() == this && Block.m_49918_((VoxelShape)world.m_8055_(np.m_7495_()).m_60808_((BlockGetter)world, np.m_7495_()), (Direction)Direction.UP));
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rtr) {
            Direction facing = rtr.m_82434_().m_122424_();
            ItemStack stack = player.m_21120_(hand);
            if (facing == Direction.DOWN && !stack.m_41619_() && stack.m_150930_(Items.f_42340_)) {
                if (world.m_5776_()) {
                    return InteractionResult.SUCCESS;
                }
                Overlay.TextOverlayGui.show(Auxiliaries.localizable("hints.use_ladder"), 1000);
                return InteractionResult.CONSUME;
            }
            if (facing == Direction.DOWN && !stack.m_41619_() && stack.m_150930_(Items.f_41963_)) {
                if (world.m_5776_()) {
                    return InteractionResult.SUCCESS;
                }
                if (((Boolean)state.m_61143_((Property)DROP)).booleanValue()) {
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)DROP, (Comparable)Boolean.valueOf(false)), 10);
                    world.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), SoundEvents.f_12176_, SoundSource.PLAYERS, 0.2f, 1.0f);
                    Inventories.give(player, new ItemStack((ItemLike)Items.f_41963_, 1));
                } else {
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)DROP, (Comparable)Boolean.valueOf(true)), 10);
                    world.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), SoundEvents.f_12176_, SoundSource.PLAYERS, 0.2f, 1.0f);
                    stack.m_41774_(1);
                }
                return InteractionResult.CONSUME;
            }
            return world.m_8055_(pos.m_121945_(facing)).m_60664_(world, player, hand, new BlockHitResult(rtr.m_82450_(), rtr.m_82434_(), pos.m_121945_(facing), false));
        }

        public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
            if (entity instanceof ItemEntity) {
                this.moveEntity(state, world, pos, entity);
                if (((Boolean)state.m_61143_((Property)UP)).booleanValue() && !world.m_183326_().m_183582_(pos, (Object)this)) {
                    world.m_186460_(pos, (Block)this, 60);
                }
            } else if (entity instanceof LivingEntity) {
                this.itchEntity(state, world, pos, entity);
            }
        }

        public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
            if (!((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                return;
            }
            BlockState st = world.m_8055_(pos.m_7494_());
            if (st.m_60713_((Block)this)) {
                return;
            }
            List entities = world.m_6443_(ItemEntity.class, new AABB(pos.m_7494_()).m_82363_(0.0, -0.2, 0.0), Entity::m_6084_);
            Vec3 v = Vec3.m_82528_((Vec3i)((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122436_()).m_82520_(0.0, 1.0, 0.0).m_82490_(0.1);
            for (ItemEntity entity : entities) {
                entity.m_20256_(v);
            }
        }

        public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean unused) {
            world.m_7731_(pos, this.updatedState(state, (LevelAccessor)world, pos), 2);
        }

        public boolean shouldCheckWeakPower(BlockState state, SignalGetter world, BlockPos pos, Direction side) {
            return false;
        }

        @Override
        public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
            return (Boolean)state.m_61143_((Property)UP) == false || super.m_7357_(state, world, pos, type);
        }

        public BlockState updatedState(@Nullable BlockState state, LevelAccessor world, BlockPos pos) {
            if (state == null || !(world instanceof Level)) {
                return state;
            }
            Direction facing = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
            BlockState front_state = world.m_8055_(pos.m_121945_(facing));
            BlockState right_state = world.m_8055_(pos.m_121945_(facing.m_122427_()));
            BlockState left_state = world.m_8055_(pos.m_121945_(facing.m_122428_()));
            boolean down_solid = Block.m_49936_((BlockGetter)world, (BlockPos)pos.m_7495_());
            boolean up_is_cube = world.m_8055_(pos.m_7494_()).m_60796_((BlockGetter)world, pos.m_7494_());
            boolean up = RedAntTrailBlock.m_49918_((VoxelShape)front_state.m_60808_((BlockGetter)world, pos.m_121945_(facing)), (Direction)facing.m_122424_()) && (!down_solid || world.m_8055_(pos.m_7494_()).m_60713_((Block)this) || !up_is_cube && world.m_8055_(pos.m_121945_(facing).m_7494_()).m_60713_((Block)this));
            boolean left = false;
            boolean right = false;
            boolean front = down_solid;
            boolean in = false;
            if (!up && front_state.m_60734_() != this) {
                if (right_state.m_60713_((Block)this) && right_state.m_61143_((Property)HORIZONTAL_FACING) == facing.m_122427_()) {
                    right = true;
                }
                if (left_state.m_60713_((Block)this) && left_state.m_61143_((Property)HORIZONTAL_FACING) == facing.m_122428_()) {
                    left = true;
                }
                front = down_solid && !right && !left;
            } else if (world.m_276867_(pos)) {
                if (right_state.m_60713_((Block)this) && right_state.m_61143_((Property)HORIZONTAL_FACING) == facing.m_122427_()) {
                    right = true;
                }
                if (left_state.m_60713_((Block)this) && left_state.m_61143_((Property)HORIZONTAL_FACING) == facing.m_122428_()) {
                    left = true;
                }
                if (!right && !left) {
                    front = true;
                }
            } else if (!(right || left || up)) {
                front = true;
            }
            if (down_solid) {
                if (right_state.m_60713_((Block)this) && right_state.m_61143_((Property)HORIZONTAL_FACING) == facing.m_122428_()) {
                    in = true;
                }
                if (left_state.m_60713_((Block)this) && left_state.m_61143_((Property)HORIZONTAL_FACING) == facing.m_122427_()) {
                    in = true;
                }
            }
            state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FRONT, (Comparable)Boolean.valueOf(front))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(right))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(left))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(up))).m_61124_((Property)IN, (Comparable)Boolean.valueOf(in));
            return state;
        }

        public void moveEntity(BlockState state, Level world, BlockPos pos, Entity any_entity) {
            Direction dir;
            BlockState ahead_state;
            Direction insertion_facing;
            if (!any_entity.m_6084_() || !(any_entity instanceof ItemEntity)) {
                return;
            }
            ItemEntity entity = (ItemEntity)any_entity;
            if (entity.m_32055_().m_41619_() || entity.m_32055_().m_41720_() == ModContent.references.ANTS_ITEM) {
                return;
            }
            boolean up = (Boolean)state.m_61143_((Property)UP);
            if (!up && !entity.m_20096_()) {
                return;
            }
            Direction block_facing = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
            boolean front = (Boolean)state.m_61143_((Property)FRONT);
            boolean right = (Boolean)state.m_61143_((Property)RIGHT);
            boolean left = (Boolean)state.m_61143_((Property)LEFT);
            boolean outgoing = false;
            boolean check_insertion_front = false;
            boolean check_insertion_up = false;
            Vec3 dp = entity.m_20182_().m_82492_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5).m_82490_(2.0);
            double progress = dp.m_82507_(block_facing.m_122434_()) * Vec3.m_82528_((Vec3i)block_facing.m_122436_()).m_82507_(block_facing.m_122434_());
            Vec3 motion = Vec3.m_82528_((Vec3i)block_facing.m_122436_()).m_82490_(0.65);
            if (right) {
                insertion_facing = block_facing.m_122427_();
                ahead_state = world.m_8055_(pos.m_121945_(insertion_facing));
                if (ahead_state.m_60713_((Block)this) && (dir = (Direction)ahead_state.m_61143_((Property)HORIZONTAL_FACING)) == insertion_facing) {
                    motion = Vec3.m_82528_((Vec3i)insertion_facing.m_122436_()).m_82490_(progress < 0.4 ? 0.5 : 1.6);
                    outgoing = true;
                }
            } else if (left) {
                insertion_facing = block_facing.m_122428_();
                ahead_state = world.m_8055_(pos.m_121945_(insertion_facing));
                if (ahead_state.m_60713_((Block)this) && (dir = (Direction)ahead_state.m_61143_((Property)HORIZONTAL_FACING)) == insertion_facing) {
                    motion = Vec3.m_82528_((Vec3i)insertion_facing.m_122436_()).m_82490_(progress < 0.4 ? 0.5 : 1.6);
                    outgoing = true;
                }
            } else if ((front || up) && (insertion_facing = (Direction)this.itemFrameDiversion(world, pos, entity.m_32055_()).orElse(null)) != null && insertion_facing != block_facing && insertion_facing != block_facing.m_122424_() && insertion_facing != Direction.UP) {
                if (insertion_facing == Direction.DOWN) {
                    if (!world.m_5776_() && this.tryInsertItemEntity(world, pos, Direction.DOWN, entity)) {
                        entity.m_20256_(entity.m_20184_().m_82490_(0.7));
                        return;
                    }
                } else {
                    motion = Vec3.m_82528_((Vec3i)insertion_facing.m_122436_());
                    outgoing = true;
                }
            }
            if (!(outgoing || front || up)) {
                motion = motion.m_82490_(0.0);
            } else {
                if (!outgoing) {
                    Vec3 centering_motion = new Vec3(block_facing.m_122434_() == Direction.Axis.X ? 0.0 : -0.2 * Math.signum(dp.f_82479_), 0.02, block_facing.m_122434_() == Direction.Axis.Z ? 0.0 : -0.2 * Math.signum(dp.f_82481_));
                    motion = motion.m_82549_(centering_motion);
                    ahead_state = world.m_8055_(pos.m_121945_(block_facing));
                    if (ahead_state.m_60713_((Block)this)) {
                        dir = (Direction)ahead_state.m_61143_((Property)HORIZONTAL_FACING);
                        motion = dir == block_facing.m_122424_() ? motion.m_82490_(0.5) : ((Boolean)ahead_state.m_61143_((Property)RIGHT) == false && (Boolean)ahead_state.m_61143_((Property)LEFT) == false ? motion.m_82490_(2.0) : motion.m_82490_(1.6));
                    }
                }
                double y_speed = 0.1;
                if (!up) {
                    y_speed = -0.1 * Math.min(dp.f_82480_, 0.5);
                    if (progress > 0.5 && front) {
                        check_insertion_front = true;
                    }
                } else {
                    if (front) {
                        motion = motion.m_82490_(0.6);
                    }
                    if (world.m_8055_(pos.m_7494_()).m_60713_((Block)this)) {
                        if (progress > 0.5) {
                            y_speed = 0.2;
                        }
                        if (outgoing) {
                            motion = new Vec3(motion.m_7096_(), 0.0, motion.f_82481_);
                            y_speed = 0.08;
                        }
                    } else {
                        if (front && Math.abs(dp.m_82507_(block_facing.m_122427_().m_122434_())) > 0.4) {
                            motion = new Vec3(motion.f_82479_, -0.1, motion.f_82481_);
                            y_speed = 0.08;
                        } else if (world.m_8055_(pos.m_7494_().m_121945_(block_facing)).m_60713_((Block)this)) {
                            motion = motion.m_82549_(Vec3.m_82528_((Vec3i)block_facing.m_122436_())).m_82490_(0.5);
                        }
                        if (dp.f_82480_ >= 0.4) {
                            check_insertion_up = true;
                        }
                    }
                }
                if (progress > 0.8 && front) {
                    y_speed /= 2.0;
                }
                if (motion.f_82480_ < -0.1) {
                    motion = new Vec3(motion.f_82479_, -0.1, motion.f_82481_);
                }
                motion = motion.m_82490_(!up && dp.f_82480_ > 0.0 ? 0.02 : 0.07).m_82520_(0.0, y_speed, 0.0);
            }
            if (!world.m_5776_()) {
                if (progress < 0.4 && ((Boolean)state.m_61143_((Property)DROP)).booleanValue() && this.tryInsertItemEntity(world, pos, Direction.DOWN, entity)) {
                    check_insertion_up = false;
                    check_insertion_front = false;
                }
                if ((check_insertion_front || check_insertion_up) && !entity.m_32055_().m_41619_()) {
                    insertion_facing = check_insertion_up ? Direction.UP : block_facing;
                    this.tryInsertItemEntity(world, pos, insertion_facing, entity);
                }
            }
            if (!up && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                motion = motion.m_82520_(0.0, -0.1, 0.0);
            }
            motion = entity.m_20184_().m_82490_(0.5).m_82549_(motion);
            entity.m_20256_(motion);
            entity.m_6853_(false);
        }

        public void itchEntity(BlockState state, Level world, BlockPos pos, Entity entity) {
            if (world.m_213780_().m_188500_() > 0.004 || !entity.m_6084_() || !entity.m_20096_() || world.m_5776_() || entity.m_6144_() || !entity.m_6072_() || entity.m_20070_() || entity.f_19812_ || !(entity instanceof LivingEntity)) {
                return;
            }
            if (entity instanceof Monster) {
                entity.m_6469_(entity.m_269291_().m_269325_(), 2.0f);
            } else if (entity instanceof Player) {
                if (world.m_213780_().m_188500_() > 0.08) {
                    return;
                }
                entity.m_6469_(entity.m_269291_().m_269325_(), 0.1f);
            } else {
                entity.m_6469_(entity.m_269291_().m_269325_(), 0.0f);
                if (entity instanceof Villager) {
                    ((Villager)entity).m_6274_().m_21889_(Activity.f_37984_);
                } else if (entity instanceof Animal) {
                    ((Animal)entity).m_6274_().m_21889_(Activity.f_37984_);
                }
            }
        }

        private Optional<Direction> itemFrameDiversion(Level world, BlockPos pos, ItemStack match_stack) {
            List frames = world.m_45976_(ItemFrame.class, new AABB(pos));
            if (frames.isEmpty()) {
                return Optional.empty();
            }
            for (ItemFrame frame : frames) {
                if (!frame.m_31822_().m_150930_(match_stack.m_41720_())) continue;
                return Optional.of(frame.m_6350_());
            }
            return Optional.empty();
        }

        private boolean tryInsertItemEntity(Level world, BlockPos pos, Direction insertion_facing, ItemEntity entity) {
            ItemStack stack = entity.m_32055_();
            int stack_size = stack.m_41613_();
            ItemStack remaining = Inventories.insert(world, pos.m_121945_(insertion_facing), insertion_facing.m_122424_(), stack, false);
            if (stack.m_41619_()) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                return true;
            }
            if (remaining.m_41613_() < stack_size) {
                entity.m_32045_(remaining);
                return true;
            }
            return false;
        }
    }
}

