/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside.blocks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import wile.anthillinside.ModContent;
import wile.anthillinside.blocks.RedAntTrail;
import wile.anthillinside.entities.TransportedItemEntity;
import wile.anthillinside.libmc.Auxiliaries;
import wile.anthillinside.libmc.Containers;
import wile.anthillinside.libmc.Crafting;
import wile.anthillinside.libmc.Guis;
import wile.anthillinside.libmc.IntegralBitSet;
import wile.anthillinside.libmc.Inventories;
import wile.anthillinside.libmc.Networking;
import wile.anthillinside.libmc.Registries;
import wile.anthillinside.libmc.StandardBlocks;
import wile.anthillinside.libmc.StandardEntityBlocks;
import wile.anthillinside.libmc.ToolActions;
import wile.anthillinside.libmc.TooltipDisplay;
import wile.anthillinside.libmc.TreeCutting;

public class RedAntHive {
    private static int hive_drop_probability_percent = 3;
    private static int sugar_boost_time_s = 5;
    private static int hive_growth_latency_s = 120;
    private static int normal_processing_speed_ant_count_percent = 100;
    private static int animal_feeding_speed_percent = 100;
    private static int animal_feeding_entity_limit = 16;
    private static int animal_feeding_xz_radius = 3;
    private static int farming_speed_percent = 100;
    private static int block_breaking_speed_percent = 100;
    private static int tree_chopping_speed_percent = 100;
    private static final int brewing_fuel_efficiency_percent = 75;
    private static final int book_disenchanting_processing_time = 200;
    private static final HashMap<Item, Object> processing_command_item_mapping = new HashMap();
    private static final HashMap<Item, HashSet<Item>> known_items_mapping = new HashMap();
    private static final HashSet<Item> known_smoke_particle_command_items = new HashSet();

    public static void on_config(HashMap<Item, HashSet<Item>> known_items, int ore_minining_spawn_probability_percent, int ant_speed_scaler_percent, int sugar_time_s, int growth_latency_s, int feeding_speed_factor_percent, int feeding_entity_limit, int feeding_xz_radius, int farming_speed_factor_percent, int block_breaking_speed_factor_percent, int tree_chopping_speed_factor_percent, int tool_damage_factor_percent) {
        hive_drop_probability_percent = Mth.m_14045_((int)ore_minining_spawn_probability_percent, (int)0, (int)99);
        normal_processing_speed_ant_count_percent = Mth.m_14045_((int)ant_speed_scaler_percent, (int)10, (int)190);
        sugar_boost_time_s = Mth.m_14045_((int)sugar_time_s, (int)1, (int)60);
        hive_growth_latency_s = Mth.m_14045_((int)growth_latency_s, (int)10, (int)600);
        animal_feeding_speed_percent = Mth.m_14045_((int)feeding_speed_factor_percent, (int)0, (int)200);
        animal_feeding_entity_limit = Mth.m_14045_((int)feeding_entity_limit, (int)3, (int)64);
        animal_feeding_xz_radius = Mth.m_14045_((int)feeding_xz_radius, (int)1, (int)5);
        farming_speed_percent = farming_speed_factor_percent < 0 ? 0 : Mth.m_14045_((int)farming_speed_factor_percent, (int)10, (int)200);
        block_breaking_speed_percent = block_breaking_speed_factor_percent < 0 ? 0 : Mth.m_14045_((int)block_breaking_speed_factor_percent, (int)10, (int)200);
        tree_chopping_speed_percent = tree_chopping_speed_factor_percent < 0 ? 0 : Mth.m_14045_((int)tree_chopping_speed_factor_percent, (int)10, (int)200);
        known_items_mapping.clear();
        known_items_mapping.putAll(known_items);
        List.of(Items.f_41960_, Items.f_42770_, Items.f_42769_, Items.f_42726_, Items.f_42543_, Items.f_42773_, Items.f_42155_, Items.f_42162_, Items.f_41855_, Items.f_42574_, Items.f_42387_, Items.f_42386_, Items.f_42385_, Items.f_42405_, Items.f_42499_, Items.f_42446_, Items.f_42523_).forEach(item -> known_items.putIfAbsent((Item)item, new HashSet()));
        if (known_items_mapping.get(Items.f_41960_).isEmpty()) {
            known_items_mapping.get(Items.f_41960_).add(Items.f_41960_);
        }
        if (known_items_mapping.get(Items.f_41962_).isEmpty()) {
            known_items_mapping.get(Items.f_41962_).add(Items.f_41962_);
        }
        if (known_items_mapping.get(Items.f_42770_).isEmpty()) {
            known_items_mapping.get(Items.f_42770_).add(Items.f_42770_);
        }
        if (known_items_mapping.get(Items.f_42769_).isEmpty()) {
            known_items_mapping.get(Items.f_42769_).add(Items.f_42769_);
        }
        if (known_items_mapping.get(Items.f_42155_).isEmpty()) {
            known_items_mapping.get(Items.f_42155_).add(Items.f_42155_);
        }
        if (known_items_mapping.get(Items.f_42162_).isEmpty()) {
            known_items_mapping.get(Items.f_42162_).add(Items.f_42162_);
        }
        if (known_items_mapping.get(Items.f_41855_).isEmpty()) {
            known_items_mapping.get(Items.f_41855_).add(Items.f_41855_);
        }
        if (known_items_mapping.get(Items.f_42405_).isEmpty()) {
            known_items_mapping.get(Items.f_42405_).add(Items.f_42405_);
        }
        if (known_items_mapping.get(Items.f_42499_).isEmpty()) {
            known_items_mapping.get(Items.f_42499_).add(Items.f_42499_);
        }
        if (known_items_mapping.get(Items.f_42446_).isEmpty()) {
            known_items_mapping.get(Items.f_42446_).add(Items.f_42446_);
        }
        processing_command_item_mapping.clear();
        known_items_mapping.get(Items.f_41960_).forEach(item -> processing_command_item_mapping.put((Item)item, RecipeType.f_44107_));
        known_items_mapping.get(Items.f_41962_).forEach(item -> processing_command_item_mapping.put((Item)item, RecipeType.f_44108_));
        known_items_mapping.get(Items.f_42770_).forEach(item -> processing_command_item_mapping.put((Item)item, RecipeType.f_44109_));
        known_items_mapping.get(Items.f_42769_).forEach(item -> processing_command_item_mapping.put((Item)item, RecipeType.f_44110_));
        ProcessingHandler common_hopper_process = new ProcessingHandler(Items.f_42155_, (te, done) -> te.processHopper(), te -> false);
        known_items_mapping.get(Items.f_42155_).forEach(item -> processing_command_item_mapping.put((Item)item, common_hopper_process));
        ProcessingHandler common_composter_process = new ProcessingHandler(Items.f_42726_, (te, done) -> te.processComposter(), RedAntHiveTileEntity::itemPassThroughComposter);
        known_items_mapping.get(Items.f_42726_).forEach(item -> processing_command_item_mapping.put((Item)item, common_composter_process));
        ProcessingHandler common_shearing_process = new ProcessingHandler(Items.f_42574_, (te, done) -> te.processShears(), RedAntHiveTileEntity::itemPassThroughAll);
        known_items_mapping.get(Items.f_42574_).forEach(item -> processing_command_item_mapping.put((Item)item, common_shearing_process));
        ProcessingHandler common_brewing_process = new ProcessingHandler(Items.f_42543_, RedAntHiveTileEntity::processBrewing, RedAntHiveTileEntity::itemPassThroughBrewing);
        known_items_mapping.get(Items.f_42543_).forEach(item -> processing_command_item_mapping.put((Item)item, common_brewing_process));
        ProcessingHandler common_grinding_process = new ProcessingHandler(Items.f_42773_, RedAntHiveTileEntity::processGrindstone, RedAntHiveTileEntity::itemPassThroughGrindstone);
        known_items_mapping.get(Items.f_42773_).forEach(item -> processing_command_item_mapping.put((Item)item, common_grinding_process));
        ProcessingHandler common_blockplace_process = new ProcessingHandler(Items.f_41855_, RedAntHiveTileEntity::processDispenserBlockPlacement, RedAntHiveTileEntity::itemPassThroughDispenserBlockPlacement);
        known_items_mapping.get(Items.f_41855_).forEach(item -> processing_command_item_mapping.put((Item)item, common_blockplace_process));
        ProcessingHandler common_fluidcollection_process = new ProcessingHandler(Items.f_42446_, RedAntHiveTileEntity::processBucketFluidCollection, RedAntHiveTileEntity::itemPassThroughBucketFluidCollection);
        known_items_mapping.get(Items.f_42446_).forEach(item -> processing_command_item_mapping.put((Item)item, common_fluidcollection_process));
        ProcessingHandler common_fishing_process = new ProcessingHandler(Items.f_42523_, RedAntHiveTileEntity::processFishing, RedAntHiveTileEntity::itemPassThroughAll);
        known_items_mapping.get(Items.f_42523_).forEach(item -> processing_command_item_mapping.put((Item)item, common_fishing_process));
        ProcessingHandler common_fertilizing_process = new ProcessingHandler(Items.f_42499_, RedAntHiveTileEntity::processFertilizing, te -> te.itemPassThroughExcept(Items.f_42499_));
        known_items_mapping.get(Items.f_42499_).forEach(item -> processing_command_item_mapping.put((Item)item, common_fertilizing_process));
        if (farming_speed_percent > 0) {
            known_items_mapping.get(Items.f_42387_).forEach(item -> processing_command_item_mapping.put((Item)item, new ProcessingHandler((Item)item, (te, done) -> te.processFarming((Item)item), te -> te.itemPassThroughExcept(Items.f_42499_))));
        }
        if (block_breaking_speed_percent > 0) {
            known_items_mapping.get(Items.f_42385_).forEach(item -> processing_command_item_mapping.put((Item)item, new ProcessingHandler((Item)item, RedAntHiveTileEntity::processPickAxe, RedAntHiveTileEntity::itemPassThroughAll)));
        }
        if (tree_chopping_speed_percent > 0) {
            known_items_mapping.get(Items.f_42386_).forEach(item -> processing_command_item_mapping.put((Item)item, new ProcessingHandler((Item)item, RedAntHiveTileEntity::processAxe, RedAntHiveTileEntity::itemPassThroughAll)));
        }
        if (animal_feeding_speed_percent > 0) {
            known_items_mapping.get(Items.f_42405_).forEach(item -> processing_command_item_mapping.put((Item)item, new ProcessingHandler((Item)item, (te, done) -> te.processAnimalFood((Item)item), te -> te.itemPassThroughExcept((Item)item))));
        }
        known_smoke_particle_command_items.clear();
        known_smoke_particle_command_items.add(Items.f_41962_);
        known_smoke_particle_command_items.add(Items.f_42770_);
        known_smoke_particle_command_items.add(Items.f_42769_);
        known_smoke_particle_command_items.add(Items.f_41960_);
        known_smoke_particle_command_items.add(Items.f_42543_);
        known_smoke_particle_command_items.add(Items.f_42726_);
        Auxiliaries.logDebug("Hive:drop-probability:" + hive_drop_probability_percent + "%ant-speed-scaler:" + normal_processing_speed_ant_count_percent + "%growth-time:" + hive_growth_latency_s + "ssugar-time:" + sugar_boost_time_s + "s");
        Auxiliaries.logDebug("NOTE: Hive drop probability from Redstone mining configured to 0 (OFF). Ensure that you have a recipe or mechanic for making Hives accessible to players.");
        Auxiliaries.logDebug("Animals:feeding-speed:" + animal_feeding_speed_percent + "%entity-limit:" + animal_feeding_entity_limit + "xz-radius:" + animal_feeding_xz_radius + "blk");
        Auxiliaries.logDebug("Crop farming:havesting-speed:" + farming_speed_percent + "%");
        Auxiliaries.logDebug("Ctrl-Items:" + processing_command_item_mapping.keySet().stream().map(e -> Auxiliaries.getResourceLocation(e).m_135815_()).collect(Collectors.joining(",")));
    }

    public static void onGlobalPlayerBlockBrokenEvent(BlockState state, LevelAccessor iworld, BlockPos pos, Player player) {
        if (hive_drop_probability_percent <= 0) {
            return;
        }
        if (!state.m_60713_(Blocks.f_50173_) && !state.m_60713_(Blocks.f_152473_) || iworld.m_5776_() || !(iworld instanceof Level)) {
            return;
        }
        Level world = (Level)iworld;
        if (iworld.m_213780_().m_188503_(100) >= hive_drop_probability_percent) {
            return;
        }
        Inventories.dropStack(world, Vec3.m_82512_((Vec3i)pos), new ItemStack((ItemLike)ModContent.references.HIVE_BLOCK.m_5456_()));
        world.m_5594_(null, pos, SoundEvents.f_11672_, SoundSource.BLOCKS, 1.0f, 1.4f);
    }

    private static class ProcessingHandler {
        public final Item item;
        public final BiFunction<RedAntHiveTileEntity, Boolean, Boolean> handler;
        public final Function<RedAntHiveTileEntity, Boolean> passthrough_handler;

        public ProcessingHandler(Item item, BiFunction<RedAntHiveTileEntity, Boolean, Boolean> handler, Function<RedAntHiveTileEntity, Boolean> passthrough_handler) {
            this.item = item;
            this.handler = handler;
            this.passthrough_handler = passthrough_handler;
        }
    }

    public static class RedAntHiveBlock
    extends StandardBlocks.DirectedWaterLoggable
    implements StandardEntityBlocks.IStandardEntityBlock<RedAntHiveTileEntity> {
        public static final IntegerProperty VARIANT = IntegerProperty.m_61631_((String)"variant", (int)0, (int)3);

        public RedAntHiveBlock(long config, BlockBehaviour.Properties props, AABB[] aabbs) {
            super(config, props.m_60924_((s, w, p) -> false), aabbs);
            this.m_49959_((BlockState)((BlockState)super.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.DOWN)).m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(0)));
        }

        @Override
        public boolean isBlockEntityTicking(Level world, BlockState state) {
            return true;
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return Shapes.m_83144_();
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{VARIANT}));
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            BlockState state = super.m_5573_(context);
            if (state == null) {
                return null;
            }
            if (!context.m_43723_().m_6144_()) {
                state = (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.DOWN);
            }
            double[] variant_votes = new double[VARIANT.m_6908_().size()];
            int reference_weight = 0;
            Level world = context.m_43725_();
            BlockPos placement_pos = context.m_8083_();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        double block_volume;
                        if (x == 0 && y == 0 && z == 0) continue;
                        Vec3i dirv = new Vec3i(x, y, z);
                        BlockPos adj_pos = placement_pos.m_121955_(dirv);
                        double adj_scaler = (double)(Math.abs(x) + Math.abs(y) + Math.abs(z)) <= 1.1 ? 1.3 : 1.0;
                        double weight = (x == 0 ? 1.7 : 1.0) * (y == 0 ? 1.7 : 1.0) * (z == 0 ? 1.7 : 1.0) * adj_scaler;
                        BlockState adj_state = world.m_8055_(adj_pos);
                        VoxelShape adj_shape = adj_state.m_60808_((BlockGetter)world, adj_pos);
                        double d = block_volume = adj_shape.m_83281_() ? 0.0 : adj_shape.m_83215_().m_82309_();
                        if (block_volume < 0.75) continue;
                        reference_weight = (int)((double)reference_weight + weight);
                        String name = Auxiliaries.getResourceLocation(adj_state.m_60734_()).m_135815_();
                        if (name.contains("_log") || name.contains("_wood") || name.contains("planks") || name.contains("leaves") || adj_state.m_60713_((Block)ModContent.references.COVERED_TRAIL_BLOCK)) {
                            variant_votes[3] = variant_votes[3] + weight;
                            continue;
                        }
                        if (name.contains("sand")) {
                            variant_votes[2] = variant_votes[2] + weight;
                            continue;
                        }
                        if (name.contains("dirt") || name.contains("grass")) {
                            variant_votes[1] = variant_votes[1] + weight;
                            continue;
                        }
                        variant_votes[0] = variant_votes[0] + weight;
                    }
                }
            }
            int best_variant = 0;
            double max_vote = variant_votes[0];
            for (int i = 0; i < variant_votes.length; ++i) {
                if (!(variant_votes[i] > max_vote)) continue;
                best_variant = i;
                max_vote = variant_votes[i];
            }
            if ((max_vote /= Math.max(1.0, (double)reference_weight)) >= 0.2) {
                state = (BlockState)state.m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(best_variant));
            }
            return state;
        }

        public boolean m_7278_(BlockState state) {
            return true;
        }

        public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
            BlockEntity te = world.m_7702_(pos);
            return te instanceof RedAntHiveTileEntity ? ((RedAntHiveTileEntity)te).comparatorValue() : 0;
        }

        @Override
        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            return new RedAntHiveTileEntity(pos, state);
        }

        @Nullable
        public MenuProvider m_7246_(BlockState state, Level world, BlockPos pos) {
            BlockEntity ate = world.m_7702_(pos);
            if (!(ate instanceof RedAntHiveTileEntity)) {
                return null;
            }
            RedAntHiveTileEntity te = (RedAntHiveTileEntity)ate;
            return new SimpleMenuProvider((menu_id, inventory, player) -> new RedAntHiveMenu(menu_id, inventory, te.main_inventory_, ContainerLevelAccess.m_39289_((Level)world, (BlockPos)pos), te.fields), (Component)Component.m_237115_((String)"container.anthillinside.hive"));
        }

        public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            if (world.m_5776_()) {
                return;
            }
            if (!stack.m_41782_() || !stack.m_41784_().m_128441_("tedata")) {
                return;
            }
            CompoundTag te_nbt = stack.m_41784_().m_128469_("tedata");
            if (te_nbt.m_128456_()) {
                return;
            }
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof RedAntHiveTileEntity)) {
                return;
            }
            ((RedAntHiveTileEntity)te).readnbt(te_nbt, false);
            te.m_6596_();
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
            if (world.m_5776_() || !(te instanceof RedAntHiveTileEntity)) {
                return Collections.emptyList();
            }
            CompoundTag te_nbt = ((RedAntHiveTileEntity)te).clear_getnbt();
            ItemStack stack = new ItemStack((ItemLike)this.m_5456_());
            if (!te_nbt.m_128456_()) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128365_("tedata", (Tag)te_nbt);
                stack.m_41751_(nbt);
            }
            return Collections.singletonList(stack);
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            if (world.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof RedAntHiveTileEntity)) {
                return InteractionResult.FAIL;
            }
            player.m_5893_((MenuProvider)((RedAntHiveTileEntity)te));
            return InteractionResult.CONSUME;
        }

        public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean unused) {
            if (world.f_46443_) {
                return;
            }
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof RedAntHiveTileEntity)) {
                return;
            }
            ((RedAntHiveTileEntity)te).block_updated();
        }

        public boolean shouldCheckWeakPower(BlockState state, SignalGetter world, BlockPos pos, Direction side) {
            return false;
        }

        public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
            return true;
        }

        public boolean m_7899_(BlockState state) {
            return true;
        }

        public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
            BlockEntity te = world.m_7702_(pos);
            return te instanceof RedAntHiveTileEntity ? ((RedAntHiveTileEntity)te).getRedstonePower(state, side, false) : 0;
        }

        public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
            BlockEntity te = world.m_7702_(pos);
            return te instanceof RedAntHiveTileEntity ? ((RedAntHiveTileEntity)te).getRedstonePower(state, side, true) : 0;
        }
    }

    public static class RedAntHiveTileEntity
    extends StandardEntityBlocks.StandardBlockEntity
    implements MenuProvider,
    Nameable {
        public static final int LEFT_STORAGE_NUM_SLOTS = 10;
        public static final int LEFT_STORAGE_NUM_ROWS = 5;
        public static final int LEFT_STORAGE_START = 0;
        public static final int RIGHT_STORAGE_NUM_SLOTS = 10;
        public static final int RIGHT_STORAGE_NUM_ROWS = 5;
        public static final int RIGHT_STORAGE_START = 10;
        public static final int ANT_STORAGE_NUM_SLOTS = 3;
        public static final int ANT_STORAGE_NUM_ROWS = 1;
        public static final int ANT_STORAGE_START = 20;
        public static final int CMD_STORAGE_NUM_SLOTS = 1;
        public static final int CMD_STORAGE_NUM_ROWS = 1;
        public static final int CMD_STORAGE_START = 23;
        public static final int GRID_STORAGE_NUM_SLOTS = 9;
        public static final int GRID_STORAGE_NUM_ROWS = 3;
        public static final int GRID_STORAGE_START = 24;
        public static final int INP_STORAGE_NUM_SLOTS = 1;
        public static final int INP_STORAGE_NUM_ROWS = 1;
        public static final int INP_STORAGE_START = 33;
        public static final int OUT_STORAGE_NUM_SLOTS = 1;
        public static final int OUT_STORAGE_NUM_ROWS = 1;
        public static final int OUT_STORAGE_START = 34;
        public static final int CMD_RESULT_NUM_SLOTS = 1;
        public static final int CMD_RESULT_NUM_ROWS = 1;
        public static final int CMD_RESULT_START = 35;
        public static final int CMD_CACHE_NUM_SLOTS = 9;
        public static final int CMD_CACHE_NUM_ROWS = 3;
        public static final int CMD_CACHE_START = 36;
        public static final int LEFT_FILTER_NUM_SLOTS = 10;
        public static final int LEFT_FILTER_NUM_ROWS = 5;
        public static final int LEFT_FILTER_START = 45;
        public static final int NUM_MAIN_INVENTORY_SLOTS = 55;
        protected final Inventories.StorageInventory main_inventory_;
        protected final Inventories.InventoryRange left_storage_slot_range_;
        protected final Inventories.InventoryRange left_filter_slot_range_;
        protected final Inventories.InventoryRange right_storage_slot_range_;
        protected final Inventories.InventoryRange ant_storage_slot_range_;
        protected final Inventories.InventoryRange grid_storage_slot_range_;
        protected final Inventories.InventoryRange cache_slot_range_;
        public static final int NUM_OF_FIELDS = 3;
        public static final int TICK_INTERVAL = 8;
        public static final int SLOW_INTERVAL = 2;
        private final StateFlags state_flags_ = new StateFlags(0);
        private String last_recipe_ = "";
        private int colony_growth_progress_ = 0;
        private int sugar_ticks_ = 0;
        private boolean can_use_sugar_ = false;
        private int ant_count_ = 0;
        private double ant_speed_ = 0.0;
        private double progress_ = 0.0;
        private int max_progress_ = 0;
        private int universal_task_index_ = 0;
        private int fuel_left_ = 0;
        private int tick_timer_ = 0;
        private int slow_timer_ = 0;
        private int input_side_redstone_pulse_time_left_ = 0;
        private int output_side_redstone_pulse_time_left_ = 0;
        private final Map<UUID, Long> entity_handling_cooldowns_ = new HashMap<UUID, Long>();
        protected LazyOptional<? extends IItemHandler> item_handler_;
        protected final ContainerData fields = new ContainerData(){

            public int m_6499_() {
                return 3;
            }

            public int m_6413_(int id) {
                return switch (id) {
                    case 0 -> state_flags_.int_value();
                    case 1 -> max_progress_;
                    case 2 -> (int)progress_;
                    default -> 0;
                };
            }

            public void m_8050_(int id, int value) {
                switch (id) {
                    case 0: {
                        state_flags_.value(value);
                        break;
                    }
                    case 1: {
                        max_progress_ = Math.max(value, 0);
                        break;
                    }
                    case 2: {
                        progress_ = Mth.m_14045_((int)value, (int)0, (int)max_progress_);
                        break;
                    }
                }
            }
        };

        public static BiPredicate<Integer, ItemStack> main_inventory_validator() {
            return (index, stack) -> {
                if (stack.m_41720_() == ModContent.references.HIVE_BLOCK.m_5456_()) {
                    return false;
                }
                if (index >= 20 && index < 23) {
                    return stack.m_41720_() == ModContent.references.ANTS_ITEM;
                }
                if (index >= 23 && index < 24) {
                    return processing_command_item_mapping.containsKey(stack.m_41720_());
                }
                if (index >= 24 && index < 33) {
                    return stack.m_41720_() != ModContent.references.ANTS_ITEM;
                }
                if (index >= 33 && index < 34) {
                    return known_items_mapping.get(Items.f_42155_).contains(stack.m_41720_());
                }
                if (index >= 34 && index < 35) {
                    return known_items_mapping.get(Items.f_42155_).contains(stack.m_41720_()) || known_items_mapping.get(Items.f_42162_).contains(stack.m_41720_()) || known_items_mapping.get(Items.f_41855_).contains(stack.m_41720_());
                }
                return index < 35 || index >= 36;
            };
        }

        public RedAntHiveTileEntity(BlockPos pos, BlockState state) {
            super(Registries.getBlockEntityTypeOfBlock(state.m_60734_()), pos, state);
            this.main_inventory_ = new Inventories.StorageInventory(this, 55).setValidator(RedAntHiveTileEntity.main_inventory_validator());
            this.left_storage_slot_range_ = new Inventories.InventoryRange(this.main_inventory_, 0, 10, 5);
            this.right_storage_slot_range_ = new Inventories.InventoryRange(this.main_inventory_, 10, 10, 5);
            this.ant_storage_slot_range_ = new Inventories.InventoryRange(this.main_inventory_, 20, 3, 1);
            this.grid_storage_slot_range_ = new Inventories.InventoryRange(this.main_inventory_, 24, 9, 3).setMaxStackSize(1);
            this.cache_slot_range_ = new Inventories.InventoryRange(this.main_inventory_, 36, 9, 3);
            this.left_filter_slot_range_ = new Inventories.InventoryRange(this.main_inventory_, 45, 10, 5).setMaxStackSize(1);
            this.left_storage_slot_range_.setValidator((slot, stack) -> {
                if (!this.state_flags_.filteredinsert()) {
                    return true;
                }
                if (slot >= this.left_storage_slot_range_.size()) {
                    return false;
                }
                if (this.left_filter_slot_range_.m_8020_((int)slot).m_41619_()) {
                    return true;
                }
                return stack.m_150930_(this.left_filter_slot_range_.m_8020_((int)slot).m_41720_());
            });
            this.initItemHandler();
        }

        public void m_7651_() {
            super.m_7651_();
            this.item_handler_.invalidate();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == ForgeCapabilities.ITEM_HANDLER) {
                return this.item_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        private void initItemHandler() {
            this.item_handler_ = Inventories.MappedItemHandler.createGenericHandler(this.main_inventory_, (slot, stack) -> slot >= this.right_storage_slot_range_.offset() && slot < this.right_storage_slot_range_.offset() + this.right_storage_slot_range_.size(), (slot, stack) -> slot >= this.left_storage_slot_range_.offset() && slot < this.left_storage_slot_range_.offset() + this.left_storage_slot_range_.size() && this.insertionAllowed(this.left_storage_slot_range_.offset() + slot, (ItemStack)stack));
        }

        public CompoundTag clear_getnbt() {
            CompoundTag nbt = new CompoundTag();
            if (!this.main_inventory_.m_7983_()) {
                this.writenbt(nbt, false);
            } else {
                this.main_inventory_.m_6211_();
            }
            return nbt;
        }

        public void readnbt(CompoundTag nbt, boolean update_packet) {
            this.main_inventory_.load(nbt);
            this.state_flags_.value(nbt.m_128454_("state_flags"));
            this.progress_ = nbt.m_128459_("progress");
            this.max_progress_ = nbt.m_128451_("max_progress");
            this.colony_growth_progress_ = nbt.m_128451_("colony_growth_progress");
            this.sugar_ticks_ = nbt.m_128451_("sugar_ticks");
            this.fuel_left_ = nbt.m_128451_("fuel_left");
            this.last_recipe_ = nbt.m_128461_("last_recipe");
            if (!ResourceLocation.m_135830_((String)this.last_recipe_)) {
                this.last_recipe_ = "";
            }
        }

        protected void writenbt(CompoundTag nbt, boolean update_packet) {
            this.main_inventory_.save(nbt);
            nbt.m_128356_("state_flags", this.state_flags_.value());
            nbt.m_128347_("progress", this.progress_);
            nbt.m_128405_("max_progress", this.max_progress_);
            nbt.m_128405_("colony_growth_progress", this.colony_growth_progress_);
            nbt.m_128405_("sugar_ticks", this.sugar_ticks_);
            nbt.m_128405_("fuel_left", this.fuel_left_);
            nbt.m_128359_("last_recipe", this.last_recipe_);
        }

        public void block_updated() {
            this.tick_timer_ = Math.min(this.tick_timer_, 2);
        }

        public int comparatorValue() {
            return 0;
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt, false);
        }

        protected void m_183515_(CompoundTag nbt) {
            super.m_183515_(nbt);
            this.writenbt(nbt, false);
        }

        public Component m_7755_() {
            return Auxiliaries.localizable(this.m_58900_().m_60734_().m_7705_());
        }

        public boolean m_8077_() {
            return false;
        }

        public Component m_7770_() {
            return this.m_7755_();
        }

        public Component m_5446_() {
            return this.m_7755_();
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
            return new RedAntHiveMenu(id, inventory, this.main_inventory_, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_), this.fields);
        }

        @Override
        public void tick() {
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 8;
            if (this.slow_timer_++ >= 2) {
                this.slow_timer_ = 0;
            }
            this.updateBlockstate();
            if (!this.checkColony()) {
                return;
            }
            boolean dirty = false;
            dirty |= this.checkItemOutput();
            dirty |= this.checkWorkProcess();
            if (dirty |= this.checkItemInput()) {
                this.m_6596_();
            }
        }

        public int getRedstonePower(BlockState state, Direction redstone_side, boolean strong) {
            if (strong) {
                return 0;
            }
            if (this.input_side_redstone_pulse_time_left_ > 0 && redstone_side == state.m_61143_((Property)RedAntHiveBlock.FACING)) {
                return 15;
            }
            if (this.output_side_redstone_pulse_time_left_ > 0 && redstone_side == ((Direction)state.m_61143_((Property)RedAntHiveBlock.FACING)).m_122424_()) {
                return 15;
            }
            return 0;
        }

        protected StateFlags getStateFlags() {
            return this.state_flags_;
        }

        protected boolean isSlowTimerTick() {
            return this.slow_timer_ == 0;
        }

        protected boolean isProcessing() {
            return this.progress_ > 0.0 && this.max_progress_ > 0;
        }

        @Nullable
        BlockState updateBlockstate() {
            BlockState state = this.m_58900_();
            this.state_flags_.powered(this.m_58904_().m_276867_(this.m_58899_()));
            return state;
        }

        protected void setResultSlot(ItemStack stack) {
            this.main_inventory_.m_6836_(35, stack);
        }

        protected ItemStack getResultSlot() {
            return this.main_inventory_.m_8020_(35);
        }

        protected void setCommandSlot(ItemStack stack) {
            this.main_inventory_.m_6836_(23, stack);
        }

        protected ItemStack getCommandSlot() {
            return this.main_inventory_.m_8020_(23);
        }

        protected void setInputControlSlot(ItemStack stack) {
            this.main_inventory_.m_6836_(33, stack);
        }

        protected ItemStack getInputControlSlot() {
            return this.main_inventory_.m_8020_(33);
        }

        protected void setOutputControlSlot(ItemStack stack) {
            this.main_inventory_.m_6836_(34, stack);
        }

        protected ItemStack getOutputControlSlot() {
            return this.main_inventory_.m_8020_(34);
        }

        protected boolean insertionAllowed(int index, ItemStack stack) {
            if (!this.state_flags_.filteredinsert()) {
                return true;
            }
            if (this.left_filter_slot_range_.m_8020_(index).m_41619_()) {
                return true;
            }
            return this.left_filter_slot_range_.m_8020_(index).m_41720_() == stack.m_41720_();
        }

        protected ItemStack insertLeft(ItemStack stack) {
            if (!this.state_flags_.filteredinsert()) {
                return this.left_storage_slot_range_.insert(stack);
            }
            ItemStack remaining = stack.m_41777_();
            for (int i = 0; i < this.left_storage_slot_range_.m_6643_() && (this.left_storage_slot_range_.m_8020_(i).m_41619_() && !this.left_filter_slot_range_.m_8020_(i).m_41619_() && this.left_filter_slot_range_.m_8020_(i).m_41720_() != stack.m_41720_() || !(remaining = this.left_storage_slot_range_.insert(i, remaining)).m_41619_()); ++i) {
            }
            return remaining;
        }

        public void enableInsertionFilter(boolean enable) {
            this.state_flags_.filteredinsert(enable);
            if (!enable) {
                this.left_filter_slot_range_.m_6211_();
            } else {
                for (int i = 0; i < this.left_filter_slot_range_.size(); ++i) {
                    ItemStack stack = this.left_storage_slot_range_.m_8020_(i);
                    if (stack.m_41619_()) {
                        this.left_filter_slot_range_.m_6836_(i, ItemStack.f_41583_);
                        continue;
                    }
                    stack = stack.m_41777_();
                    stack.m_41764_(1);
                    this.left_filter_slot_range_.m_6836_(i, stack);
                }
            }
            this.m_6596_();
        }

        private AABB workingRange(int xz_radius, int y_height, int y_offset) {
            Direction facing = ((Direction)this.m_58900_().m_61143_((Property)RedAntHiveBlock.FACING)).m_122424_();
            AABB aabb = new AABB((double)(-xz_radius), (double)y_offset, (double)(-xz_radius), (double)(xz_radius + 1), (double)(y_offset + y_height), (double)(xz_radius + 1));
            aabb = facing == Direction.UP ? aabb.m_82338_(this.m_58899_().m_7494_()) : (facing == Direction.DOWN ? aabb.m_82338_(this.m_58899_().m_6625_(y_height)) : aabb.m_82338_(this.m_58899_().m_5484_(facing, xz_radius + 1)));
            return aabb;
        }

        private boolean entityCooldownExpired(UUID uuid) {
            long t = this.entity_handling_cooldowns_.getOrDefault(uuid, 0L);
            if (t <= this.m_58904_().m_46467_()) {
                this.entity_handling_cooldowns_.remove(uuid);
                return true;
            }
            return false;
        }

        private void entityCooldown(UUID uuid, int time) {
            long t = this.m_58904_().m_46467_();
            this.entity_handling_cooldowns_.put(uuid, t + (long)time);
            if (this.entity_handling_cooldowns_.size() < 128) {
                return;
            }
            this.entity_handling_cooldowns_.keySet().forEach(k -> {
                if (this.entity_handling_cooldowns_.getOrDefault(k, 0L) >= t) {
                    return;
                }
                this.entity_handling_cooldowns_.remove(k);
            });
        }

        private boolean checkColony() {
            int max_ants = this.ant_storage_slot_range_.size() * this.ant_storage_slot_range_.m_6893_();
            this.ant_count_ = this.ant_storage_slot_range_.stream().filter(e -> e.m_41720_() == ModContent.references.ANTS_ITEM).mapToInt(ItemStack::m_41613_).sum();
            this.state_flags_.noants(this.ant_count_ == 0);
            this.sugar_ticks_ = Math.max(this.sugar_ticks_ - 8, 0);
            boolean bl = this.can_use_sugar_ = this.sugar_ticks_ <= 0 && (this.ant_count_ < max_ants || this.isProcessing());
            if (this.can_use_sugar_ && !this.left_storage_slot_range_.extract(new ItemStack((ItemLike)ModContent.references.RED_SUGAR_ITEM, 1)).m_41619_()) {
                this.sugar_ticks_ = 20 * sugar_boost_time_s;
            }
            this.state_flags_.sugared(this.sugar_ticks_ > 0);
            this.colony_growth_progress_ += 8 * (this.sugar_ticks_ > 0 ? 3 : 1);
            if (this.colony_growth_progress_ >= 20 * hive_growth_latency_s) {
                this.colony_growth_progress_ = 0;
                this.ant_storage_slot_range_.insert(new ItemStack((ItemLike)ModContent.references.ANTS_ITEM));
            }
            if (this.ant_count_ == 0) {
                if (this.progress_ > 0.0) {
                    this.progress_ -= 8.0;
                }
                return false;
            }
            this.ant_speed_ = (this.state_flags_.sugared() ? 2.0 : 1.0) * ((double)this.ant_count_ / (double)max_ants * (0.01 * (double)normal_processing_speed_ant_count_percent));
            return true;
        }

        private boolean checkItemOutput() {
            if (this.output_side_redstone_pulse_time_left_ > 0 && (this.output_side_redstone_pulse_time_left_ -= 8) <= 0) {
                this.output_side_redstone_pulse_time_left_ = 0;
                this.f_58857_.m_46586_(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)RedAntHiveBlock.FACING)), this.m_58900_().m_60734_(), this.m_58899_());
            }
            if (this.state_flags_.powered()) {
                return false;
            }
            if (this.getOutputControlSlot().m_41619_()) {
                return false;
            }
            int outstack_size = 1 + this.ant_count_ / 96;
            Item control_item = this.getOutputControlSlot().m_41720_();
            Direction output_facing = (Direction)this.m_58900_().m_61143_((Property)RedAntHiveBlock.FACING);
            BlockPos output_position = this.m_58899_().m_121945_(output_facing);
            if (known_items_mapping.get(Items.f_42155_).contains(control_item)) {
                Inventories.ItemPort ih = Inventories.ItemPort.of(this.m_58904_(), output_position, output_facing.m_122424_(), true);
                if (ih.allowsInsertion()) {
                    int n_inserted = 0;
                    for (int slot = 0; slot < this.right_storage_slot_range_.size(); ++slot) {
                        ItemStack remaining;
                        ItemStack ostack = this.right_storage_slot_range_.m_8020_(slot);
                        if (ostack.m_41619_()) continue;
                        ItemStack stack = ostack.m_41777_();
                        if (stack.m_41613_() > outstack_size) {
                            stack.m_41764_(outstack_size);
                        }
                        if ((remaining = ih.insert(stack)).m_41613_() == stack.m_41613_()) continue;
                        n_inserted = stack.m_41613_() - remaining.m_41613_();
                        this.right_storage_slot_range_.m_8020_(slot).m_41774_(n_inserted);
                    }
                    if (!(!this.right_storage_slot_range_.m_7983_() && n_inserted > 0 || ih.isStorageEmpty() || ih.owner() instanceof BlockEntity)) {
                        Object object;
                        boolean notify = this.output_side_redstone_pulse_time_left_ <= 0;
                        this.output_side_redstone_pulse_time_left_ = 15;
                        if (notify) {
                            this.f_58857_.m_46586_(this.m_58899_().m_121945_(output_facing), this.m_58900_().m_60734_(), this.m_58899_());
                        }
                        if ((object = ih.owner()) instanceof Entity) {
                            Entity entity = (Entity)object;
                            entity.m_246865_(Vec3.m_82528_((Vec3i)output_facing.m_122436_()).m_82490_(0.1));
                        }
                    }
                    return n_inserted > 0;
                }
                BlockState trail_state = this.m_58904_().m_8055_(output_position);
                if (!trail_state.m_60713_((Block)ModContent.references.TRAIL_BLOCK)) {
                    return false;
                }
                if (output_facing == ((Direction)trail_state.m_61143_((Property)RedAntTrail.RedAntTrailBlock.HORIZONTAL_FACING)).m_122424_() || output_facing == Direction.DOWN && ((Boolean)trail_state.m_61143_((Property)RedAntTrail.RedAntTrailBlock.UP)).booleanValue()) {
                    return false;
                }
                Inventories.dropStack(this.m_58904_(), Vec3.m_82512_((Vec3i)output_position).m_82520_(0.0, -0.4, 0.0), this.right_storage_slot_range_.extract(1), new Vec3(0.0, -0.2, 0.0), 0.1, 0.1);
                return true;
            }
            if (known_items_mapping.get(Items.f_42162_).contains(control_item) || known_items_mapping.get(Items.f_41855_).contains(control_item)) {
                BlockState state = this.m_58904_().m_8055_(output_position);
                if (state.m_60838_((BlockGetter)this.m_58904_(), output_position)) {
                    return false;
                }
                ItemStack stack = this.right_storage_slot_range_.extract(1, true);
                if (known_items_mapping.get(Items.f_41855_).contains(control_item)) {
                    Vec3 drop_pos = Vec3.m_82512_((Vec3i)output_position).m_82549_(Vec3.m_82528_((Vec3i)output_facing.m_122424_().m_122436_()).m_82490_(0.3));
                    Vec3 speed = Vec3.m_82528_((Vec3i)output_facing.m_122436_()).m_82490_(0.6);
                    Inventories.dropStack(this.m_58904_(), drop_pos, stack, speed, 0.1, 0.2);
                } else {
                    Vec3 drop_pos = Vec3.m_82512_((Vec3i)output_position).m_82549_(Vec3.m_82528_((Vec3i)output_facing.m_122424_().m_122436_()).m_82490_(0.1));
                    Vec3 speed = Vec3.m_82528_((Vec3i)output_facing.m_122436_()).m_82490_(0.05);
                    Inventories.dropStack(this.m_58904_(), drop_pos, stack, speed, 0.3, 0.02);
                }
            }
            return false;
        }

        private boolean checkItemInput() {
            Direction input_facing = ((Direction)this.m_58900_().m_61143_((Property)RedAntHiveBlock.FACING)).m_122424_();
            if (this.input_side_redstone_pulse_time_left_ > 0 && (this.input_side_redstone_pulse_time_left_ -= 8) <= 0) {
                this.input_side_redstone_pulse_time_left_ = 0;
                this.f_58857_.m_46586_(this.m_58899_().m_121945_(input_facing), this.m_58900_().m_60734_(), this.m_58899_());
            }
            if (!known_items_mapping.get(Items.f_42155_).contains(this.getInputControlSlot().m_41720_())) {
                return false;
            }
            int instack_size = 1 + this.ant_count_ / 96;
            boolean filtered = this.state_flags_.filteredinsert();
            boolean dirty = false;
            boolean allow_item_pickup = true;
            Inventories.ItemPort ih = Inventories.ItemPort.of(this.m_58904_(), this.m_58899_().m_121945_(input_facing), input_facing.m_122424_(), true);
            if (ih != Inventories.ItemPort.EMPTY) {
                Object ref_stack;
                allow_item_pickup = false;
                if (!ih.allowsExtraction()) {
                    return false;
                }
                for (int i = 0; i < this.left_storage_slot_range_.size(); ++i) {
                    ref_stack = this.left_storage_slot_range_.m_8020_(i);
                    if (ref_stack.m_41613_() >= ref_stack.m_41741_() || ref_stack.m_41613_() >= this.left_storage_slot_range_.m_6893_()) continue;
                    if (ref_stack.m_41619_()) {
                        ItemStack fetched;
                        if (filtered) {
                            ref_stack = this.left_filter_slot_range_.m_8020_(i);
                        }
                        if ((fetched = ih.extract((ItemStack)(ref_stack.m_41619_() ? null : ref_stack), instack_size, false)).m_41619_()) continue;
                        this.insertLeft(fetched);
                        return true;
                    }
                    int limit = Math.min(instack_size, ref_stack.m_41741_() - ref_stack.m_41613_());
                    ItemStack fetched = ih.extract((ItemStack)ref_stack, limit, false);
                    if (fetched.m_41619_()) continue;
                    this.insertLeft(fetched);
                    return true;
                }
                ref_stack = ih.owner();
                if (ref_stack instanceof Entity) {
                    Entity entity = (Entity)ref_stack;
                    if (ih.isStorageEmpty()) {
                        boolean notify = this.input_side_redstone_pulse_time_left_ <= 0;
                        this.input_side_redstone_pulse_time_left_ = 15;
                        if (notify) {
                            this.f_58857_.m_46586_(this.m_58899_().m_121945_(input_facing), this.m_58900_().m_60734_(), this.m_58899_());
                        }
                        entity.m_246865_(Vec3.m_82528_((Vec3i)input_facing.m_122436_()).m_82490_(0.1));
                    }
                }
            }
            if (allow_item_pickup) {
                Vec3 dvec = Vec3.m_82528_((Vec3i)input_facing.m_122436_());
                AABB aabb = new AABB(this.m_58899_()).m_82400_(0.3).m_82383_(dvec.m_82490_(0.3)).m_82369_(dvec.m_82490_(1.0));
                List items = this.m_58904_().m_6443_(ItemEntity.class, aabb, e -> e.m_6084_() && !e.m_32055_().m_41619_());
                for (ItemEntity ie : items) {
                    ItemStack stack = ie.m_32055_().m_41777_();
                    ItemStack remaining = this.insertLeft(stack);
                    if (remaining.m_41613_() == stack.m_41613_()) continue;
                    dirty = true;
                    if (remaining.m_41619_()) {
                        ie.m_142687_(Entity.RemovalReason.DISCARDED);
                        continue;
                    }
                    ie.m_32045_(remaining);
                }
            }
            return dirty;
        }

        private boolean checkWorkProcess() {
            Object cat = processing_command_item_mapping.getOrDefault(this.getCommandSlot().m_41720_(), null);
            if (cat == null) {
                this.max_progress_ = 0;
                this.progress_ = 0.0;
                this.last_recipe_ = "";
                this.fuel_left_ = 0;
                this.state_flags_.mask(28L, 0L);
                this.cache_slot_range_.move(this.left_storage_slot_range_);
                if (!this.getResultSlot().m_41619_()) {
                    this.setResultSlot(ItemStack.f_41583_);
                    this.entity_handling_cooldowns_.clear();
                    return true;
                }
                return false;
            }
            if (this.progress_ < 0.0) {
                this.progress_ = Math.min(0.0, this.progress_ + 8.0);
                if (this.progress_ < 0.0) {
                    return this.inventoryManagement() || this.itemPassThrough(cat);
                }
                this.cache_slot_range_.move(this.right_storage_slot_range_);
                return true;
            }
            if (this.max_progress_ > 0 && this.progress_ < (double)this.max_progress_) {
                if (this.progress_ > 1.0 || !this.state_flags_.powered()) {
                    this.progress_ = Math.min((double)this.max_progress_, this.progress_ + (double)Math.max(8, (int)((1.0 + this.ant_speed_) * 8.0)));
                }
                if (this.inventoryManagement() || this.itemPassThrough(cat)) {
                    return true;
                }
            } else {
                boolean is_done = this.progress_ >= (double)this.max_progress_ && this.max_progress_ > 0;
                this.state_flags_.mask(28L, 0L);
                this.max_progress_ = 0;
                this.progress_ = 0.0;
                if (is_done && known_smoke_particle_command_items.contains(this.getCommandSlot().m_41720_())) {
                    Auxiliaries.particles(this.m_58904_(), this.m_58899_(), (ParticleOptions)ParticleTypes.f_123762_);
                }
                if (cat instanceof RecipeType) {
                    if (cat == RecipeType.f_44107_) {
                        this.processCrafting(cat, is_done);
                    } else if (cat == RecipeType.f_44108_ || cat == RecipeType.f_44109_ || cat == RecipeType.f_44110_) {
                        this.processFurnace(cat, is_done);
                    }
                } else if (cat instanceof ProcessingHandler) {
                    return ((ProcessingHandler)cat).handler.apply(this, is_done);
                }
            }
            return true;
        }

        private boolean inventoryManagement() {
            if (!this.isSlowTimerTick() || !this.state_flags_.filteredinsert()) {
                return false;
            }
            return this.left_filter_slot_range_.iterate((fslot, fstack) -> {
                int missing;
                if (fstack.m_41619_()) {
                    return false;
                }
                ItemStack sstack = this.left_storage_slot_range_.get((int)fslot);
                int n = missing = sstack.m_41619_() ? fstack.m_41741_() : sstack.m_41741_() - sstack.m_41613_();
                if (missing <= 0) {
                    return false;
                }
                if (!fstack.m_41753_() && !sstack.m_41619_()) {
                    return false;
                }
                ItemStack found = this.left_storage_slot_range_.extract(new ItemStack((ItemLike)fstack.m_41720_(), missing), false, (slot, stack) -> {
                    if (slot.equals(fslot)) {
                        return false;
                    }
                    return !this.left_filter_slot_range_.get((int)slot).m_150930_(fstack.m_41720_());
                });
                if (found.m_41619_()) {
                    return false;
                }
                if (sstack.m_41619_()) {
                    this.left_storage_slot_range_.set((int)fslot, found);
                } else {
                    sstack.m_41769_(found.m_41613_());
                    this.left_storage_slot_range_.set((int)fslot, sstack);
                }
                return true;
            });
        }

        private boolean itemPassThrough(Object type) {
            if (this.state_flags_.nopassthrough()) {
                return false;
            }
            if (!this.isSlowTimerTick()) {
                return false;
            }
            if (type == RecipeType.f_44107_) {
                return this.itemPassThroughCrafting((RecipeType)type);
            }
            if (type == RecipeType.f_44108_ || type == RecipeType.f_44109_ || type == RecipeType.f_44110_) {
                return this.itemPassThroughFurnace((RecipeType)type);
            }
            if (type instanceof ProcessingHandler) {
                return ((ProcessingHandler)type).passthrough_handler.apply(this);
            }
            return false;
        }

        private boolean itemPassThroughExcept(Item except) {
            return this.itemPassThroughExcept(Collections.singletonList(except));
        }

        private boolean itemPassThroughExcept(List<Item> except) {
            for (int i = 0; i < this.left_storage_slot_range_.size(); ++i) {
                ItemStack stack = this.left_storage_slot_range_.m_8020_(i);
                if (stack.m_41619_() || stack.m_41720_() == ModContent.references.RED_SUGAR_ITEM || except.contains(stack.m_41720_()) || !this.left_storage_slot_range_.move(i, this.right_storage_slot_range_)) continue;
                return true;
            }
            return false;
        }

        private boolean itemPassThroughAll() {
            return this.itemPassThroughExcept(Collections.emptyList());
        }

        private boolean processCrafting(RecipeType<?> recipe_type, boolean is_done) {
            List last;
            this.progress_ = -40.0;
            if (is_done) {
                this.setResultSlot(ItemStack.f_41583_);
                List<Object> crafting_recipes = !this.last_recipe_.isEmpty() ? Crafting.getCraftingRecipe(this.m_58904_(), new ResourceLocation(this.last_recipe_)).map(Collections::singletonList).orElse(Collections.emptyList()) : Crafting.get3x3CraftingRecipes(this.m_58904_(), this.cache_slot_range_);
                if (!crafting_recipes.isEmpty()) {
                    List<ItemStack> remaining = Crafting.get3x3RemainingItems(this.m_58904_(), this.cache_slot_range_, (CraftingRecipe)crafting_recipes.get(0));
                    ItemStack result = Crafting.get3x3CraftingResult(this.m_58904_(), this.cache_slot_range_, (CraftingRecipe)crafting_recipes.get(0));
                    this.cache_slot_range_.m_6211_();
                    this.cache_slot_range_.insert(result);
                    for (ItemStack stack : remaining) {
                        if (stack.m_41619_()) continue;
                        this.cache_slot_range_.insert(stack);
                    }
                    if (this.cache_slot_range_.move(this.right_storage_slot_range_)) {
                        this.progress_ = 0.0;
                        return true;
                    }
                }
                this.progress_ = -8.0;
                return true;
            }
            if (!this.cache_slot_range_.m_7983_()) {
                return false;
            }
            List<Object> crafting_recipes = Crafting.get3x3CraftingRecipes(this.m_58904_(), this.grid_storage_slot_range_);
            if (!crafting_recipes.isEmpty() && !this.last_recipe_.isEmpty() && !(last = Crafting.getCraftingRecipe(this.m_58904_(), new ResourceLocation(this.last_recipe_)).map(Collections::singletonList).orElse(Collections.emptyList())).isEmpty() && crafting_recipes.contains(last.get(0))) {
                crafting_recipes = last;
            }
            if (crafting_recipes.isEmpty()) {
                this.state_flags_.norecipe(true);
                this.last_recipe_ = "";
                return false;
            }
            CraftingRecipe selected_recipe = null;
            List<Object> selected_placement = Collections.emptyList();
            Iterator<CraftingRecipe> iterator = crafting_recipes.iterator();
            while (iterator.hasNext()) {
                CraftingRecipe recipe;
                selected_recipe = recipe = iterator.next();
                List<ItemStack> placement = Crafting.get3x3Placement(this.m_58904_(), recipe, this.left_storage_slot_range_, this.grid_storage_slot_range_);
                if (placement.isEmpty()) continue;
                selected_placement = placement;
                break;
            }
            if (selected_placement.isEmpty()) {
                this.state_flags_.noingr(true);
                if (this.last_recipe_.isEmpty() && selected_recipe != null) {
                    this.last_recipe_ = Crafting.getRecipeId(this.f_58857_, selected_recipe).map(ResourceLocation::toString).orElse("");
                }
                return false;
            }
            this.cache_slot_range_.m_6211_();
            for (int i = 0; i < selected_placement.size(); ++i) {
                this.cache_slot_range_.m_6836_(i, this.left_storage_slot_range_.extract((ItemStack)selected_placement.get(i)));
            }
            this.setResultSlot(Crafting.get3x3CraftingResult(this.m_58904_(), this.cache_slot_range_, selected_recipe));
            this.last_recipe_ = Crafting.getRecipeId(this.f_58857_, selected_recipe).map(ResourceLocation::toString).orElse("");
            this.progress_ = 0.0;
            this.max_progress_ = 60 + 4 * this.cache_slot_range_.stream().mapToInt(ItemStack::m_41613_).sum();
            return true;
        }

        private boolean itemPassThroughCrafting(RecipeType<?> recipe_type) {
            if (this.last_recipe_.isEmpty()) {
                return false;
            }
            CraftingRecipe recipe = Crafting.getCraftingRecipe(this.m_58904_(), new ResourceLocation(this.last_recipe_)).orElse(null);
            if (recipe == null) {
                return false;
            }
            List<Ingredient> ingredients = recipe.m_7527_().stream().filter(ing -> ing != Ingredient.f_43901_).toList();
            if (ingredients.isEmpty()) {
                return false;
            }
            for (int i = 0; i < this.left_storage_slot_range_.size(); ++i) {
                ItemStack stack = this.left_storage_slot_range_.m_8020_(i);
                if (stack.m_41720_() == ModContent.references.RED_SUGAR_ITEM || !ingredients.stream().noneMatch(ing -> ing.test(stack)) || !this.left_storage_slot_range_.move(i, this.right_storage_slot_range_)) continue;
                return true;
            }
            return false;
        }

        private boolean processFurnace(RecipeType<?> recipe_type, boolean is_done) {
            this.last_recipe_ = "";
            this.progress_ = -40.0;
            if (is_done) {
                if (!this.getResultSlot().m_41619_()) {
                    this.cache_slot_range_.m_6836_(0, this.getResultSlot());
                    this.setResultSlot(ItemStack.f_41583_);
                }
                this.cache_slot_range_.move(this.right_storage_slot_range_);
                if (this.cache_slot_range_.m_7983_()) {
                    this.progress_ = 0.0;
                }
                this.state_flags_.nofuel(false);
                this.state_flags_.noingr(false);
                return true;
            }
            Inventories.InventoryRange input_slots = this.left_storage_slot_range_;
            List<Item> allowed_fuel = this.grid_storage_slot_range_.stream().filter(e -> !e.m_41619_()).map(ItemStack::m_41720_).toList();
            Tuple recipe_search = input_slots.find((slot, stack) -> {
                if (Crafting.isFuel(this.f_58857_, stack)) {
                    return Optional.empty();
                }
                Optional<AbstractCookingRecipe> recipe = Crafting.getFurnaceRecipe(recipe_type, this.f_58857_, stack);
                return recipe.map(r -> new Tuple(slot, r));
            }).orElse(null);
            if (recipe_search == null) {
                recipe_search = input_slots.find((slot, stack) -> {
                    if (stack.m_41619_()) {
                        return Optional.empty();
                    }
                    if (!allowed_fuel.isEmpty() && allowed_fuel.contains(stack.m_41720_())) {
                        return Optional.empty();
                    }
                    Optional<AbstractCookingRecipe> recipe = Crafting.getFurnaceRecipe(recipe_type, this.f_58857_, stack);
                    return recipe.map(r -> new Tuple(slot, r));
                }).orElse(null);
            }
            if (recipe_search == null) {
                this.state_flags_.noingr(true);
                return false;
            }
            AbstractCookingRecipe recipe = (AbstractCookingRecipe)recipe_search.m_14419_();
            int smelting_input_slot = (Integer)recipe_search.m_14418_();
            int fuel_time_needed = (int)Math.ceil((1.0 + this.ant_speed_) * (double)recipe.m_43753_());
            int initial_fuel_left = this.fuel_left_;
            boolean enough_fuel = input_slots.iterate((slot, stack) -> {
                if (this.fuel_left_ >= fuel_time_needed) {
                    return true;
                }
                if (slot == smelting_input_slot || stack.m_41619_()) {
                    return false;
                }
                int t = Crafting.getFuelBurntime(this.f_58857_, stack);
                if (t <= 0) {
                    return false;
                }
                if (!allowed_fuel.isEmpty() && !allowed_fuel.contains(stack.m_41720_())) {
                    return false;
                }
                while (stack.m_41613_() > 0 && this.fuel_left_ < fuel_time_needed) {
                    ItemStack consumed = stack.m_41620_(1);
                    Tuple<Integer, ItemStack> bt_and_rem = Crafting.consumeFuel(this.m_58904_(), consumed);
                    this.fuel_left_ += ((Integer)bt_and_rem.m_14418_()).intValue();
                    if (((ItemStack)bt_and_rem.m_14419_()).m_41619_()) continue;
                    ItemStack container_item = (ItemStack)bt_and_rem.m_14419_();
                    if (stack.m_41619_()) {
                        stack = container_item;
                        continue;
                    }
                    if (this.right_storage_slot_range_.insert(container_item).m_41619_()) continue;
                    this.cache_slot_range_.insert(container_item);
                }
                if (stack.m_41619_()) {
                    stack = ItemStack.f_41583_;
                }
                input_slots.m_6836_((int)slot, (ItemStack)stack);
                return false;
            });
            if (!enough_fuel && !this.state_flags_.noingr()) {
                this.state_flags_.nofuel(true);
                return this.fuel_left_ != initial_fuel_left;
            }
            if (this.fuel_left_ < fuel_time_needed) {
                return true;
            }
            this.state_flags_.nofuel(false);
            this.state_flags_.norecipe(false);
            this.setResultSlot(recipe.m_8043_(this.m_58904_().m_9598_()));
            this.fuel_left_ -= fuel_time_needed;
            this.max_progress_ = recipe.m_43753_();
            this.last_recipe_ = Crafting.getRecipeId(this.f_58857_, recipe).map(ResourceLocation::toString).orElse("");
            this.progress_ = 0.0;
            this.cache_slot_range_.m_6836_(0, input_slots.m_8020_(smelting_input_slot).m_41620_(1));
            return true;
        }

        private boolean itemPassThroughFurnace(RecipeType<?> recipe_type) {
            List<Item> allowed_fuel = this.grid_storage_slot_range_.stream().filter(e -> !e.m_41619_()).map(ItemStack::m_41720_).toList();
            List unmatching_slots = this.left_storage_slot_range_.collect((slot, stack) -> {
                if (stack.m_41619_() || stack.m_41720_() == ModContent.references.RED_SUGAR_ITEM) {
                    return Optional.empty();
                }
                if (Crafting.isFuel(this.f_58857_, stack) && (allowed_fuel.isEmpty() || allowed_fuel.contains(stack.m_41720_()))) {
                    return Optional.empty();
                }
                if (Crafting.getFurnaceRecipe(recipe_type, this.f_58857_, stack).isPresent()) {
                    return Optional.empty();
                }
                return Optional.of(slot);
            });
            if (unmatching_slots.isEmpty()) {
                return false;
            }
            int picked_slot = (Integer)unmatching_slots.get(this.f_58857_.m_213780_().m_188503_(unmatching_slots.size()));
            return this.left_storage_slot_range_.move(picked_slot, this.right_storage_slot_range_);
        }

        private boolean processComposter() {
            if (this.cache_slot_range_.m_7983_()) {
                ItemStack bonemeal = new ItemStack((ItemLike)Items.f_42499_);
                int processed = 0;
                for (ItemStack stack : this.left_storage_slot_range_) {
                    double chance;
                    if (stack.m_41619_() || (chance = Crafting.getCompostingChance(stack)) <= 0.0) continue;
                    ++processed;
                    stack.m_41774_(1);
                    if (this.m_58904_().m_213780_().m_188500_() < chance || --this.fuel_left_ >= 0) continue;
                    if (!this.right_storage_slot_range_.insert(bonemeal).m_41619_()) {
                        this.cache_slot_range_.insert(bonemeal);
                    }
                    this.fuel_left_ = 8;
                }
                if (processed > 0) {
                    this.state_flags_.noingr(false);
                    this.progress_ = 0.0;
                    this.max_progress_ = 20 + processed * 10;
                    this.setResultSlot(bonemeal);
                    return true;
                }
            }
            this.setResultSlot(ItemStack.f_41583_);
            this.progress_ = -40.0;
            this.state_flags_.noingr(true);
            return false;
        }

        private boolean itemPassThroughComposter() {
            if (!this.cache_slot_range_.m_7983_()) {
                return false;
            }
            for (int i = 0; i < this.left_storage_slot_range_.size(); ++i) {
                ItemStack stack = this.left_storage_slot_range_.m_8020_(i);
                if (stack.m_41619_() || Crafting.getCompostingChance(stack) > 0.0 || stack.m_41720_() == ModContent.references.RED_SUGAR_ITEM || !this.left_storage_slot_range_.move(i, this.right_storage_slot_range_)) continue;
                return true;
            }
            return false;
        }

        private boolean processHopper() {
            this.progress_ = 0.0;
            this.max_progress_ = 8;
            return this.itemPassThroughExcept(Collections.emptyList());
        }

        private boolean processShears() {
            ItemStack stack;
            Direction input_facing = ((Direction)this.m_58900_().m_61143_((Property)RedAntHiveBlock.FACING)).m_122424_();
            boolean snipped = ToolActions.Shearing.shearPlant(this.m_58904_(), this.m_58899_().m_121945_(input_facing));
            if (!snipped) {
                AABB aabb = new AABB(this.m_58899_().m_121945_(input_facing));
                snipped = ToolActions.Shearing.shearEntities(this.m_58904_(), aabb, 1);
            }
            if (!snipped && !(stack = ToolActions.Beekeeping.harvest(this.m_58904_(), this.m_58899_().m_121945_(input_facing), false)).m_41619_()) {
                snipped = true;
                this.right_storage_slot_range_.insert(stack);
            }
            if (snipped) {
                this.progress_ = 0.0;
                this.max_progress_ = 120;
            } else {
                this.progress_ = -40.0;
                this.max_progress_ = 0;
            }
            return false;
        }

        private boolean processPickAxe(boolean done) {
            Level level = this.m_58904_();
            if (!(level instanceof ServerLevel)) {
                return false;
            }
            ServerLevel world = (ServerLevel)level;
            Direction input_facing = ((Direction)this.m_58900_().m_61143_((Property)RedAntHiveBlock.FACING)).m_122424_();
            BlockPos pos = this.m_58899_().m_121945_(input_facing);
            BlockState state = world.m_8055_(pos);
            int break_time = -1;
            if (ToolActions.BlockBreaking.isBreakable(state, pos, (Level)world)) {
                if (!done) {
                    float reluctance = (float)(1.0 / Math.max(this.ant_speed_, 0.01));
                    break_time = ToolActions.BlockBreaking.breakTime(state, pos, (Level)world, this.getCommandSlot(), 5, 600, reluctance);
                } else {
                    List<ItemStack> drops = ToolActions.BlockBreaking.breakBlock(state, pos, (Level)world, this.getCommandSlot(), false).orElse(null);
                    if (drops != null) {
                        if (drops.isEmpty()) {
                            drops = Collections.singletonList(new ItemStack((ItemLike)state.m_60734_().m_5456_()));
                        }
                        boolean drop_on_ground = !known_items_mapping.get(Items.f_42155_).contains(this.getInputControlSlot().m_41720_());
                        for (ItemStack drop : drops) {
                            if (!drop_on_ground) {
                                drop = this.insertLeft(drop);
                            }
                            if (drop.m_41619_()) continue;
                            ToolActions.BlockBreaking.dropOnGround(drop, pos, (Level)world);
                        }
                    }
                }
            }
            if (break_time >= 0) {
                this.progress_ = 0.0;
                this.max_progress_ = break_time;
            } else {
                this.progress_ = -40.0;
                this.max_progress_ = 0;
            }
            return this.itemPassThroughExcept(Collections.emptyList());
        }

        private boolean processAxe(boolean done) {
            Level world = this.m_58904_();
            Direction input_facing = ((Direction)this.m_58900_().m_61143_((Property)RedAntHiveBlock.FACING)).m_122424_();
            BlockPos pos = this.m_58899_().m_121945_(input_facing);
            BlockState state = world.m_8055_(pos);
            int break_time = -1;
            if (TreeCutting.canChop(state)) {
                if (!done) {
                    float reluctance = (float)(7.5 / Math.max(this.ant_speed_, 0.01));
                    break_time = 10 * ToolActions.BlockBreaking.breakTime(state, pos, world, this.getCommandSlot(), 5, 1800, reluctance);
                } else {
                    TreeCutting.chopTree(world, state, pos, 256, false, ie -> TransportedItemEntity.of(ie).setTargetPosition(pos));
                    world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12630_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            if (break_time >= 0) {
                this.progress_ = 0.0;
                this.max_progress_ = break_time;
            } else {
                this.progress_ = -40.0;
                this.max_progress_ = 0;
            }
            return this.itemPassThroughExcept(Collections.emptyList());
        }

        private boolean processAnimalFood(Item food) {
            if (animal_feeding_speed_percent <= 0) {
                this.progress_ = -40.0;
                this.max_progress_ = 0;
                return false;
            }
            this.progress_ = 0.0;
            this.max_progress_ = 20000 / animal_feeding_speed_percent;
            ItemStack kibble = new ItemStack((ItemLike)food, 2);
            if (this.left_storage_slot_range_.stream().filter(s -> s.m_150930_(kibble.m_41720_())).mapToInt(ItemStack::m_41613_).sum() <= 0) {
                return false;
            }
            AABB aabb = this.workingRange(animal_feeding_xz_radius, 2, 0);
            List animals = this.m_58904_().m_6443_(Animal.class, aabb, LivingEntity::m_6084_);
            double progress_delay = 1.0 / Mth.m_14008_((double)(1.0 - Math.max((double)(animals.size() * animals.size()), 1.0) / Math.max((double)(animal_feeding_entity_limit * animal_feeding_entity_limit), 16.0)), (double)0.05, (double)1.0);
            Auxiliaries.logDebug(this.m_58899_() + ": animals:" + animals.size() + "/" + animal_feeding_entity_limit + " feeding delay rate:" + progress_delay);
            if (animals.size() >= animal_feeding_entity_limit) {
                this.max_progress_ = (int)(600.0 * progress_delay);
                return false;
            }
            if ((animals = animals.stream().filter(a -> !a.m_6162_() && a.m_6898_(kibble) && a.m_5957_() && !a.m_27593_() && this.entityCooldownExpired(a.m_20148_())).collect(Collectors.toList())).size() >= 2) {
                for (int i = 0; i < animals.size() - 1; ++i) {
                    for (int j = i + 1; j < animals.size(); ++j) {
                        if (((Animal)animals.get(i)).getClass() != ((Animal)animals.get(j)).getClass()) continue;
                        this.left_storage_slot_range_.extract(kibble);
                        ((Animal)animals.get(i)).m_27595_(null);
                        ((Animal)animals.get(j)).m_27595_(null);
                        int cooldown = (int)((double)(1200000 / animal_feeding_speed_percent) / progress_delay);
                        this.entityCooldown(((Animal)animals.get(i)).m_20148_(), cooldown);
                        this.entityCooldown(((Animal)animals.get(j)).m_20148_(), cooldown);
                        this.max_progress_ = (int)(600.0 * progress_delay);
                        return false;
                    }
                }
            }
            this.max_progress_ = (int)((double)this.max_progress_ * progress_delay);
            return false;
        }

        private boolean processFarming(Item hoe) {
            if (farming_speed_percent <= 0) {
                this.progress_ = -40.0;
                this.max_progress_ = 0;
                return false;
            }
            this.progress_ = 0.0;
            this.max_progress_ = 30000 / farming_speed_percent;
            boolean dirty = false;
            int range_ref = Mth.m_14045_((int)(hoe instanceof TieredItem ? ((TieredItem)hoe).m_43314_().m_6604_() : 0), (int)0, (int)4);
            int range_rad = range_ref + 1;
            Auxiliaries.BlockPosRange range = Auxiliaries.BlockPosRange.of(this.workingRange(range_rad, 1, 0));
            int[] step_sizes = new int[]{5, 13, 31, 47, 71};
            int step_size = step_sizes[range_ref];
            int volume = range.getVolume();
            int max_count = range_ref / 2 + 1;
            int max_search_count = 5;
            TagKey<Item> fertilizers = Registries.getItemTagKey("fertilizers");
            int fertilizer_slot = -1;
            if (fertilizers != null) {
                fertilizer_slot = this.left_storage_slot_range_.find((slot, stack) -> stack.m_204117_(fertilizers) ? Optional.of(slot) : Optional.empty()).orElse(-1);
            }
            if (fertilizer_slot < 0) {
                fertilizer_slot = this.left_storage_slot_range_.find((slot, stack) -> known_items_mapping.get(Items.f_42499_).contains(stack.m_41720_()) ? Optional.of(slot) : Optional.empty()).orElse(-1);
            }
            ItemStack fertilizer = fertilizer_slot >= 0 ? this.left_storage_slot_range_.m_8020_(fertilizer_slot).m_41777_() : ItemStack.f_41583_;
            for (int search_count = 5; search_count > 0; --search_count) {
                for (int i = 0; i < max_count; ++i) {
                    this.universal_task_index_ = (this.universal_task_index_ + step_size) % volume;
                    BlockPos pos = range.byXZYIndex(this.universal_task_index_);
                    Optional<List<ItemStack>> drops = ToolActions.Farming.harvestPlant((ServerLevel)this.m_58904_(), pos, true, fertilizer);
                    if (drops.isEmpty()) continue;
                    if (!drops.get().isEmpty()) {
                        this.m_58904_().m_5594_(null, pos, SoundEvents.f_11839_, SoundSource.BLOCKS, 0.6f, 1.4f);
                    }
                    for (ItemStack stack2 : drops.get()) {
                        this.right_storage_slot_range_.insert(stack2);
                    }
                    search_count = 0;
                }
            }
            if (fertilizer_slot >= 0) {
                this.left_storage_slot_range_.m_6836_(fertilizer_slot, fertilizer.m_41619_() ? ItemStack.f_41583_ : fertilizer);
            }
            return dirty;
        }

        private boolean processBrewing(boolean is_done) {
            this.last_recipe_ = "";
            this.progress_ = -40.0;
            if (is_done) {
                if (!this.getResultSlot().m_41619_()) {
                    this.cache_slot_range_.m_6836_(0, this.getResultSlot());
                    this.cache_slot_range_.m_6836_(1, ItemStack.f_41583_);
                    this.setResultSlot(ItemStack.f_41583_);
                }
                this.cache_slot_range_.move(this.right_storage_slot_range_);
                if (this.cache_slot_range_.m_7983_()) {
                    this.progress_ = 0.0;
                }
                this.state_flags_.nofuel(false);
                this.state_flags_.noingr(false);
                return true;
            }
            if (this.progress_ <= 0.0 && !this.cache_slot_range_.m_7983_()) {
                this.cache_slot_range_.move(this.right_storage_slot_range_);
                if (this.cache_slot_range_.m_7983_()) {
                    this.progress_ = 0.0;
                }
                return false;
            }
            Inventories.InventoryRange input_slots = this.left_storage_slot_range_;
            Crafting.BrewingOutput brewing_output = Crafting.BrewingOutput.find(this.f_58857_, input_slots, input_slots);
            if (brewing_output.item.m_41619_()) {
                this.state_flags_.noingr(true);
                return false;
            }
            int fuel_time_needed = (int)Math.ceil((1.0 + this.ant_speed_) * (double)brewing_output.brewTime);
            int initial_fuel_left = this.fuel_left_;
            boolean enough_fuel = input_slots.iterate((slot, stack) -> {
                if (this.fuel_left_ >= fuel_time_needed) {
                    return true;
                }
                if (slot == brewing_output.ingredientSlot || slot == brewing_output.potionSlot || stack.m_41619_()) {
                    return false;
                }
                int t = Crafting.getBrewingFuelBurntime(this.f_58857_, stack) * 75 / 100;
                if (t <= 0) {
                    return false;
                }
                while (stack.m_41613_() > 0 && this.fuel_left_ < fuel_time_needed) {
                    ItemStack consumed = stack.m_41620_(1);
                    Tuple<Integer, ItemStack> bt_and_rem = Crafting.consumeBrewingFuel(this.m_58904_(), consumed);
                    this.fuel_left_ += ((Integer)bt_and_rem.m_14418_()).intValue();
                    if (((ItemStack)bt_and_rem.m_14419_()).m_41619_()) continue;
                    ItemStack container_item = (ItemStack)bt_and_rem.m_14419_();
                    if (stack.m_41619_()) {
                        stack = container_item;
                        continue;
                    }
                    if (this.right_storage_slot_range_.insert(container_item).m_41619_()) continue;
                    this.cache_slot_range_.insert(container_item);
                }
                if (stack.m_41619_()) {
                    stack = ItemStack.f_41583_;
                }
                input_slots.m_6836_((int)slot, (ItemStack)stack);
                return false;
            });
            if (!enough_fuel && !this.state_flags_.noingr()) {
                this.state_flags_.nofuel(true);
                return this.fuel_left_ != initial_fuel_left;
            }
            if (this.fuel_left_ < fuel_time_needed) {
                return true;
            }
            this.state_flags_.nofuel(false);
            this.state_flags_.norecipe(false);
            this.setResultSlot(brewing_output.item);
            this.fuel_left_ -= fuel_time_needed;
            this.max_progress_ = brewing_output.brewTime;
            this.progress_ = 0.0;
            this.cache_slot_range_.m_6836_(0, input_slots.m_8020_(brewing_output.potionSlot).m_41620_(1));
            this.cache_slot_range_.m_6836_(1, input_slots.m_8020_(brewing_output.ingredientSlot).m_41620_(1));
            return true;
        }

        private boolean itemPassThroughBrewing() {
            if (!this.cache_slot_range_.m_7983_()) {
                return false;
            }
            boolean changed = false;
            for (int i = 0; i < this.left_storage_slot_range_.size(); ++i) {
                ItemStack stack = this.left_storage_slot_range_.m_8020_(i);
                if (stack.m_41619_() || stack.m_41720_() == ModContent.references.RED_SUGAR_ITEM || Crafting.isBrewingFuel(this.f_58857_, stack) || Crafting.isBrewingIngredient(this.f_58857_, stack) || Crafting.isBrewingPotion(this.f_58857_, stack) || !this.left_storage_slot_range_.move(i, this.right_storage_slot_range_)) continue;
                if (this.left_storage_slot_range_.m_8020_(i).m_41619_()) {
                    return true;
                }
                changed = true;
            }
            return changed;
        }

        private boolean processGrindstone(boolean is_done) {
            this.last_recipe_ = "";
            this.progress_ = -40.0;
            this.fuel_left_ = 0;
            if (is_done) {
                if (!this.getResultSlot().m_41619_()) {
                    ItemStack input_stack = this.cache_slot_range_.m_8020_(0);
                    this.cache_slot_range_.m_6836_(0, this.getResultSlot());
                    this.setResultSlot(ItemStack.f_41583_);
                    List enchanted_books = Crafting.removeEnchantmentsOnItem(this.f_58857_, input_stack, (e, l) -> true).entrySet().stream().filter(e -> !((Enchantment)e.getKey()).m_6589_()).sorted(Comparator.comparingInt(Map.Entry::getValue)).map(e -> Crafting.getEnchantmentBook(this.f_58857_, (Enchantment)e.getKey(), (Integer)e.getValue())).filter(e -> !e.m_41619_()).limit(this.cache_slot_range_.size() - 1).collect(Collectors.toList());
                    for (int i = 0; i < this.cache_slot_range_.size(); ++i) {
                        if (this.cache_slot_range_.m_8020_(i).m_41720_() != Items.f_42517_) continue;
                        if (enchanted_books.isEmpty()) break;
                        this.cache_slot_range_.m_6836_(i, (ItemStack)enchanted_books.remove(0));
                    }
                }
                this.cache_slot_range_.move(this.right_storage_slot_range_);
                if (this.cache_slot_range_.m_7983_()) {
                    this.progress_ = 0.0;
                }
                this.state_flags_.nofuel(false);
                this.state_flags_.noingr(false);
                return true;
            }
            Inventories.InventoryRange input_slots = this.left_storage_slot_range_;
            int input_slot = -1;
            ItemStack input_stack = ItemStack.f_41583_;
            ItemStack output_stack = ItemStack.f_41583_;
            ArrayList<ItemStack> secondary_output_stacks = new ArrayList<ItemStack>();
            int additional_processing_time = 0;
            Optional match = input_slots.find((slot, stack) -> stack.m_150930_(Items.f_42690_) || !Crafting.isEnchanted(this.f_58857_, stack) ? Optional.empty() : Optional.of(new Tuple(slot, stack)));
            if (match.isPresent()) {
                input_slot = (Integer)((Tuple)match.get()).m_14418_();
                input_stack = (ItemStack)((Tuple)match.get()).m_14419_();
                output_stack = input_stack.m_41777_();
                List<ItemStack> enchanted_books = Crafting.removeEnchantmentsOnItem(this.f_58857_, output_stack, (e, l) -> true).entrySet().stream().filter(e -> !((Enchantment)e.getKey()).m_6589_()).sorted(Comparator.comparingInt(Map.Entry::getValue)).map(e -> Crafting.getEnchantmentBook(this.f_58857_, (Enchantment)e.getKey(), (Integer)e.getValue())).filter(e -> !e.m_41619_()).limit(this.cache_slot_range_.size() - 1).toList();
                for (ItemStack enchanted_book : enchanted_books) {
                    if (input_slots.extract(new ItemStack((ItemLike)Items.f_42517_, 1)).m_41619_()) break;
                    secondary_output_stacks.add(new ItemStack((ItemLike)Items.f_42517_));
                    additional_processing_time += (Crafting.getEnchantmentRepairCost(this.f_58857_, Crafting.getEnchantmentsOnItem(this.f_58857_, enchanted_book)) + 1) * 200;
                }
            }
            if (input_slot < 0 || input_stack.m_41619_()) {
                this.state_flags_.noingr(true);
                return false;
            }
            this.state_flags_.nofuel(false);
            this.state_flags_.norecipe(false);
            this.setResultSlot(output_stack);
            this.max_progress_ = 60 + additional_processing_time;
            this.progress_ = 0.0;
            this.cache_slot_range_.m_6836_(0, input_slots.m_8020_(input_slot).m_41620_(1));
            for (int i = 0; i < secondary_output_stacks.size() && i < this.cache_slot_range_.size() - 1; ++i) {
                this.cache_slot_range_.m_6836_(1 + i, (ItemStack)secondary_output_stacks.get(i));
            }
            return true;
        }

        private boolean itemPassThroughGrindstone() {
            if (!this.cache_slot_range_.m_7983_()) {
                return false;
            }
            boolean changed = false;
            for (int i = 0; i < this.left_storage_slot_range_.size(); ++i) {
                ItemStack stack = this.left_storage_slot_range_.m_8020_(i);
                if (stack.m_41619_() || stack.m_150930_((Item)ModContent.references.RED_SUGAR_ITEM) || stack.m_150930_(Items.f_42517_) || !stack.m_150930_(Items.f_42690_) && Crafting.isEnchanted(this.f_58857_, stack) || !this.left_storage_slot_range_.move(i, this.right_storage_slot_range_)) continue;
                if (this.left_storage_slot_range_.m_8020_(i).m_41619_()) {
                    return true;
                }
                changed = true;
            }
            return changed;
        }

        private boolean processDispenserBlockPlacement(boolean is_done) {
            Level level = this.m_58904_();
            if (!(level instanceof ServerLevel)) {
                return false;
            }
            ServerLevel world = (ServerLevel)level;
            Direction output_facing = (Direction)this.m_58900_().m_61143_((Property)RedAntHiveBlock.FACING);
            BlockPos pos = this.m_58899_().m_121945_(output_facing);
            BlockState state = world.m_8055_(pos);
            List<Item> allowed = this.grid_storage_slot_range_.stream().filter(e -> !e.m_41619_()).map(ItemStack::m_41720_).toList();
            List matching_slots = this.left_storage_slot_range_.collect((slot, stack) -> {
                if (stack.m_41619_() || stack.m_41720_() == ModContent.references.RED_SUGAR_ITEM) {
                    return Optional.empty();
                }
                if (!allowed.isEmpty() && !allowed.contains(stack.m_41720_())) {
                    return Optional.empty();
                }
                if (!ToolActions.BlockPlacing.isPlaceable(stack.m_41720_())) {
                    return Optional.empty();
                }
                if (ToolActions.Farming.isPlantable(stack.m_41720_())) {
                    return Optional.empty();
                }
                return Optional.of(slot);
            });
            float reluctance = (float)Math.min(1.0 / Math.max(this.ant_speed_, 0.1), 6.0);
            int place_time = Math.min(60, Math.max((int)(10.0f * reluctance), 4));
            if (matching_slots.isEmpty()) {
                place_time = -40;
            } else if (is_done) {
                int picked_slot = (Integer)matching_slots.get(this.f_58857_.m_213780_().m_188503_(matching_slots.size()));
                ItemStack stack2 = this.left_storage_slot_range_.m_8020_(picked_slot);
                ToolActions.BlockPlacing.PlacementResult placeresult = ToolActions.BlockPlacing.place((Level)world, pos, stack2);
                if (placeresult == ToolActions.BlockPlacing.PlacementResult.LOCATION_BLOCKED && ToolActions.BlockPlacing.isPlantable(stack2.m_41720_()) && world.m_46859_(pos.m_121945_(Direction.UP))) {
                    placeresult = ToolActions.BlockPlacing.place((Level)world, pos.m_121945_(Direction.UP), stack2);
                }
                if (placeresult == ToolActions.BlockPlacing.PlacementResult.SUCCESS) {
                    stack2.m_41774_(1);
                    this.left_storage_slot_range_.m_6836_(picked_slot, stack2);
                } else {
                    place_time = -(2 * place_time);
                }
            }
            if (place_time >= 0) {
                this.progress_ = 0.0;
                this.max_progress_ = place_time;
            } else {
                this.progress_ = place_time;
                this.max_progress_ = 0;
            }
            return this.itemPassThroughDispenserBlockPlacement();
        }

        private boolean itemPassThroughDispenserBlockPlacement() {
            List<Item> allowed = this.grid_storage_slot_range_.stream().filter(e -> !e.m_41619_()).map(ItemStack::m_41720_).toList();
            List unmatching_slots = this.left_storage_slot_range_.collect((slot, stack) -> {
                if (stack.m_41619_() || stack.m_41720_() == ModContent.references.RED_SUGAR_ITEM) {
                    return Optional.empty();
                }
                if (!ToolActions.BlockPlacing.isPlaceable(stack.m_41720_())) {
                    return Optional.of(slot);
                }
                if (ToolActions.Farming.isPlantable(stack.m_41720_())) {
                    return Optional.of(slot);
                }
                if (allowed.isEmpty() || allowed.contains(stack.m_41720_())) {
                    return Optional.empty();
                }
                return Optional.of(slot);
            });
            if (unmatching_slots.isEmpty()) {
                return false;
            }
            int picked_slot = (Integer)unmatching_slots.get(this.f_58857_.m_213780_().m_188503_(unmatching_slots.size()));
            return this.left_storage_slot_range_.move(picked_slot, this.right_storage_slot_range_);
        }

        private boolean processBucketFluidCollection(boolean is_done) {
            ItemStack pending_stack;
            this.progress_ = -20.0;
            this.max_progress_ = 0;
            if (is_done) {
                if (!this.getResultSlot().m_41619_()) {
                    ItemStack input_stack = this.cache_slot_range_.m_8020_(0);
                    this.cache_slot_range_.m_6836_(0, this.getResultSlot());
                    this.setResultSlot(ItemStack.f_41583_);
                }
                this.cache_slot_range_.move(this.right_storage_slot_range_);
                if (this.cache_slot_range_.m_7983_()) {
                    this.progress_ = 0.0;
                }
                return true;
            }
            if (!this.cache_slot_range_.m_7983_() && ((pending_stack = this.cache_slot_range_.m_8020_(0)).m_150930_(Items.f_42447_) || pending_stack.m_150930_(Items.f_42589_) || pending_stack.m_150930_(Items.f_42448_))) {
                return false;
            }
            float reluctance = (float)Math.min(1.0 / Math.max(this.ant_speed_, 0.1), 6.0);
            int collection_time = Math.min(120, Math.max((int)(100.0f * reluctance), 20));
            BlockPos target_pos = this.m_58899_().m_121945_(((Direction)this.m_58900_().m_61143_((Property)RedAntHiveBlock.FACING)).m_122424_());
            BlockState bs = this.m_58904_().m_8055_(target_pos);
            FluidState fs = bs.m_60819_();
            boolean no_fluid_container = false;
            ItemStack result_stack = ItemStack.f_41583_;
            ItemStack source_stack = ItemStack.f_41583_;
            if (bs.m_60713_(Blocks.f_49990_) && fs.m_76170_()) {
                if (this.left_storage_slot_range_.contains(new ItemStack((ItemLike)Items.f_42446_, 1))) {
                    result_stack = new ItemStack((ItemLike)Items.f_42447_, 1);
                    source_stack = new ItemStack((ItemLike)Items.f_42446_, 1);
                    this.m_58904_().m_7731_(target_pos, Blocks.f_50016_.m_49966_(), 3);
                } else if (this.left_storage_slot_range_.contains(new ItemStack((ItemLike)Items.f_42590_, 1))) {
                    result_stack = new ItemStack((ItemLike)Items.f_42589_, 1);
                    PotionUtils.m_43549_((ItemStack)result_stack, (Potion)Potions.f_43599_);
                    source_stack = new ItemStack((ItemLike)Items.f_42590_, 1);
                    this.m_58904_().m_7731_(target_pos, Blocks.f_50016_.m_49966_(), 3);
                } else {
                    no_fluid_container = true;
                }
            } else if (bs.m_60713_(Blocks.f_49991_) && fs.m_76170_()) {
                if (this.left_storage_slot_range_.contains(new ItemStack((ItemLike)Items.f_42446_, 1))) {
                    result_stack = new ItemStack((ItemLike)Items.f_42448_, 1);
                    source_stack = new ItemStack((ItemLike)Items.f_42446_, 1);
                    this.m_58904_().m_7731_(target_pos, Blocks.f_50016_.m_49966_(), 3);
                } else {
                    no_fluid_container = true;
                }
            } else if (bs.m_60713_(Blocks.f_50718_) || bs.m_60713_(Blocks.f_50717_)) {
                if (this.left_storage_slot_range_.contains(new ItemStack((ItemLike)Items.f_42590_, 1))) {
                    ItemStack honey_bottle = ToolActions.Beekeeping.harvest(this.m_58904_(), target_pos, true);
                    if (!honey_bottle.m_41619_()) {
                        result_stack = new ItemStack((ItemLike)Items.f_42787_);
                        source_stack = new ItemStack((ItemLike)Items.f_42590_, 1);
                    }
                } else {
                    no_fluid_container = true;
                }
            }
            this.state_flags_.noingr(no_fluid_container);
            if (!result_stack.m_41619_()) {
                this.setResultSlot(result_stack);
                this.left_storage_slot_range_.extract(source_stack);
                this.cache_slot_range_.m_6836_(0, source_stack);
                this.progress_ = 0.0;
                this.max_progress_ = collection_time;
                return true;
            }
            return this.itemPassThroughBucketFluidCollection();
        }

        private boolean itemPassThroughBucketFluidCollection() {
            boolean changed = false;
            for (int i = 0; i < this.left_storage_slot_range_.size(); ++i) {
                ItemStack stack = this.left_storage_slot_range_.m_8020_(i);
                if (stack.m_41619_() || stack.m_150930_((Item)ModContent.references.RED_SUGAR_ITEM) || stack.m_150930_(Items.f_42446_) || stack.m_150930_(Items.f_42590_) || !this.left_storage_slot_range_.move(i, this.right_storage_slot_range_)) continue;
                if (this.left_storage_slot_range_.m_8020_(i).m_41619_()) {
                    return true;
                }
                changed = true;
            }
            return changed;
        }

        private boolean processFishing(boolean done) {
            double reluctance = Math.min(1.0 / Math.max(this.ant_speed_, 0.1), 6.0);
            int collection_time = Math.min(120, Math.max((int)(30.0 * reluctance), 20));
            BlockPos water_pos = this.m_58899_().m_121945_(((Direction)this.m_58900_().m_61143_((Property)RedAntHiveBlock.FACING)).m_122424_());
            if (!this.m_58904_().m_8055_(water_pos).m_60713_(Blocks.f_49990_)) {
                this.progress_ = -40.0;
                this.max_progress_ = 0;
            } else {
                this.progress_ = 0.0;
                this.max_progress_ = collection_time * 20;
                if (done) {
                    ToolActions.Fishing.fish((ServerLevel)this.m_58904_(), this.m_58899_(), this.getCommandSlot()).forEach(this.right_storage_slot_range_::insert);
                    return true;
                }
            }
            return false;
        }

        private boolean processFertilizing(boolean done) {
            double reluctance = Math.min(1.0 / Math.max(this.ant_speed_, 0.1), 6.0);
            this.max_progress_ = Math.min(1000, Math.max((int)(100.0 * reluctance), 40));
            this.progress_ = 0.0;
            if (!done) {
                return false;
            }
            int bone_meal_slot = this.left_storage_slot_range_.indexOf(new ItemStack((ItemLike)Items.f_42499_));
            if (bone_meal_slot < 0) {
                return false;
            }
            int radius = 2;
            int max_simultaneously_fertilized = 8;
            ItemStack bone_meal = this.left_storage_slot_range_.m_8020_(bone_meal_slot).m_41777_();
            Direction hive_facing = (Direction)this.m_58900_().m_61143_((Property)RedAntHiveBlock.FACING);
            int range = 5;
            BlockPos center_pos = hive_facing.m_122434_() == Direction.Axis.Y ? this.m_58899_().m_121945_(Direction.UP) : this.m_58899_().m_5484_(hive_facing, 3);
            ArrayList<BlockPos> fertilizable_positions = new ArrayList<BlockPos>();
            int xmax = center_pos.m_123341_() + 2;
            int ymax = center_pos.m_123342_() + 2;
            int zmax = center_pos.m_123343_() + 2;
            ServerLevel world = (ServerLevel)this.m_58904_();
            for (int x = center_pos.m_123341_() - 2; x <= xmax; ++x) {
                for (int y = center_pos.m_123342_() - 1; y <= ymax; ++y) {
                    for (int z = center_pos.m_123343_() - 2; z <= zmax; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        if (!ToolActions.Farming.isFertilizableNonFoliage((Level)world, pos)) continue;
                        fertilizable_positions.add(pos.m_7949_());
                    }
                }
            }
            if (fertilizable_positions.isEmpty()) {
                return false;
            }
            int max_fertilized = Math.min(8, bone_meal.m_41613_());
            if (fertilizable_positions.size() >= max_fertilized) {
                Collections.shuffle(fertilizable_positions);
                fertilizable_positions.subList(max_fertilized, fertilizable_positions.size()).clear();
            }
            for (BlockPos p : fertilizable_positions) {
                boolean ignored = ToolActions.Farming.fertilizePlant(world, p, bone_meal, false, false);
                bone_meal.m_41774_(1);
            }
            this.left_storage_slot_range_.m_6836_(bone_meal_slot, bone_meal.m_41619_() ? ItemStack.f_41583_ : bone_meal);
            return true;
        }

        public static class StateFlags
        extends IntegralBitSet {
            public static final long mask_powered = 1L;
            public static final long mask_sugared = 2L;
            public static final long mask_nofuel = 4L;
            public static final long mask_norecipe = 8L;
            public static final long mask_noingr = 16L;
            public static final long mask_nopassthrough = 32L;
            public static final long mask_filteredinsert = 64L;
            public static final long mask_noants = 128L;

            public StateFlags(int v) {
                super(v);
            }

            public boolean powered() {
                return this.bit(0);
            }

            public boolean sugared() {
                return this.bit(1);
            }

            public boolean nofuel() {
                return this.bit(2);
            }

            public boolean norecipe() {
                return this.bit(3);
            }

            public boolean noingr() {
                return this.bit(4);
            }

            public boolean nopassthrough() {
                return this.bit(5);
            }

            public boolean filteredinsert() {
                return this.bit(6);
            }

            public boolean noants() {
                return this.bit(7);
            }

            public void powered(boolean v) {
                this.bit(0, v);
            }

            public void sugared(boolean v) {
                this.bit(1, v);
            }

            public void nofuel(boolean v) {
                this.bit(2, v);
            }

            public void norecipe(boolean v) {
                this.bit(3, v);
            }

            public void noingr(boolean v) {
                this.bit(4, v);
            }

            public void nopassthrough(boolean v) {
                this.bit(5, v);
            }

            public void filteredinsert(boolean v) {
                this.bit(6, v);
            }

            public void noants(boolean v) {
                this.bit(7, v);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class RedAntHiveGui
    extends Guis.ContainerGui<RedAntHiveMenu> {
        protected final Guis.BackgroundImage gui_background_;
        protected final Guis.BackgroundImage grid_background_;
        protected final Guis.BackgroundImage result_background_;
        protected final Guis.BackgroundImage powered_indicator_;
        protected final Guis.BackgroundImage sugar_indicator_;
        protected final Guis.BackgroundImage norecipe_indicator_;
        protected final Guis.BackgroundImage noingredients_indicator_;
        protected final Guis.BackgroundImage nofuel_indicator_;
        protected final Guis.BackgroundImage noants_indicator_;
        protected final Guis.HorizontalProgressBar progress_bar_;
        protected final Guis.CheckBox left_filter_enable_;
        protected final Guis.CheckBox passthrough_enable_;
        protected final TooltipDisplay tooltip_ = new TooltipDisplay();
        protected final Player player_;
        protected final RedAntHiveTileEntity.StateFlags state_flags_ = new RedAntHiveTileEntity.StateFlags(0);
        protected final Component EMPTY_TOOLTIP = Component.m_237119_();
        protected final List<Item> command_items_with_process_bar = new ArrayList<Item>();
        protected final List<Item> command_items_grid_visible = new ArrayList<Item>();
        protected final List<Item> command_items_result_visible = new ArrayList<Item>();

        public RedAntHiveGui(RedAntHiveMenu container, Inventory player_inventory, Component title) {
            super(container, player_inventory, title, "textures/gui/hive_gui.png");
            this.player_ = player_inventory.f_35978_;
            this.f_97726_ = 176;
            this.f_97727_ = 222;
            this.gui_background_ = new Guis.BackgroundImage(this.getBackgroundImage(), this.f_97726_, this.f_97727_, new Guis.Coord2d(0, 0));
            this.grid_background_ = new Guis.BackgroundImage(this.getBackgroundImage(), 54, 54, new Guis.Coord2d(180, 71));
            this.result_background_ = new Guis.BackgroundImage(this.getBackgroundImage(), 22, 18, new Guis.Coord2d(206, 49));
            this.progress_bar_ = new Guis.HorizontalProgressBar(this.getBackgroundImage(), 40, 8, new Guis.Coord2d(180, 0), new Guis.Coord2d(180, 8));
            this.powered_indicator_ = new Guis.BackgroundImage(this.getBackgroundImage(), 9, 8, new Guis.Coord2d(181, 35));
            this.sugar_indicator_ = new Guis.BackgroundImage(this.getBackgroundImage(), 12, 12, new Guis.Coord2d(230, 19));
            this.noants_indicator_ = new Guis.BackgroundImage(this.getBackgroundImage(), 16, 16, new Guis.Coord2d(228, 32));
            this.norecipe_indicator_ = new Guis.BackgroundImage(this.getBackgroundImage(), 16, 16, new Guis.Coord2d(196, 17));
            this.noingredients_indicator_ = new Guis.BackgroundImage(this.getBackgroundImage(), 16, 16, new Guis.Coord2d(212, 17));
            this.nofuel_indicator_ = new Guis.BackgroundImage(this.getBackgroundImage(), 16, 16, new Guis.Coord2d(180, 17));
            this.left_filter_enable_ = new Guis.CheckBox(this.getBackgroundImage(), 5, 6, new Guis.Coord2d(182, 46), new Guis.Coord2d(182, 53)).onclick(box -> container.onGuiAction(box.checked() ? "input-filter-on" : "input-filter-off"));
            this.passthrough_enable_ = new Guis.CheckBox(this.getBackgroundImage(), 11, 6, new Guis.Coord2d(189, 46), new Guis.Coord2d(189, 53)).onclick(box -> container.onGuiAction(box.checked() ? "pass-through-on" : "pass-through-off"));
            Collections.addAll(this.command_items_with_process_bar, known_items_mapping.get(Items.f_41960_).toArray(new Item[0]));
            Collections.addAll(this.command_items_with_process_bar, known_items_mapping.get(Items.f_41962_).toArray(new Item[0]));
            Collections.addAll(this.command_items_with_process_bar, known_items_mapping.get(Items.f_42770_).toArray(new Item[0]));
            Collections.addAll(this.command_items_with_process_bar, known_items_mapping.get(Items.f_42769_).toArray(new Item[0]));
            Collections.addAll(this.command_items_with_process_bar, known_items_mapping.get(Items.f_41855_).toArray(new Item[0]));
            Collections.addAll(this.command_items_with_process_bar, known_items_mapping.get(Items.f_42726_).toArray(new Item[0]));
            Collections.addAll(this.command_items_with_process_bar, known_items_mapping.get(Items.f_42543_).toArray(new Item[0]));
            Collections.addAll(this.command_items_with_process_bar, known_items_mapping.get(Items.f_42773_).toArray(new Item[0]));
            Collections.addAll(this.command_items_with_process_bar, known_items_mapping.get(Items.f_42387_).toArray(new Item[0]));
            Collections.addAll(this.command_items_with_process_bar, known_items_mapping.get(Items.f_42385_).toArray(new Item[0]));
            Collections.addAll(this.command_items_with_process_bar, known_items_mapping.get(Items.f_42386_).toArray(new Item[0]));
            Collections.addAll(this.command_items_with_process_bar, known_items_mapping.get(Items.f_42405_).toArray(new Item[0]));
            Collections.addAll(this.command_items_with_process_bar, known_items_mapping.get(Items.f_42446_).toArray(new Item[0]));
            Collections.addAll(this.command_items_with_process_bar, known_items_mapping.get(Items.f_42523_).toArray(new Item[0]));
            Collections.addAll(this.command_items_with_process_bar, known_items_mapping.get(Items.f_42499_).toArray(new Item[0]));
            Collections.addAll(this.command_items_result_visible, known_items_mapping.get(Items.f_41960_).toArray(new Item[0]));
            Collections.addAll(this.command_items_result_visible, known_items_mapping.get(Items.f_41962_).toArray(new Item[0]));
            Collections.addAll(this.command_items_result_visible, known_items_mapping.get(Items.f_42770_).toArray(new Item[0]));
            Collections.addAll(this.command_items_result_visible, known_items_mapping.get(Items.f_42769_).toArray(new Item[0]));
            Collections.addAll(this.command_items_result_visible, known_items_mapping.get(Items.f_42726_).toArray(new Item[0]));
            Collections.addAll(this.command_items_result_visible, known_items_mapping.get(Items.f_42543_).toArray(new Item[0]));
            Collections.addAll(this.command_items_result_visible, known_items_mapping.get(Items.f_42773_).toArray(new Item[0]));
            Collections.addAll(this.command_items_result_visible, known_items_mapping.get(Items.f_42446_).toArray(new Item[0]));
            Collections.addAll(this.command_items_grid_visible, known_items_mapping.get(Items.f_41960_).toArray(new Item[0]));
            Collections.addAll(this.command_items_grid_visible, known_items_mapping.get(Items.f_41962_).toArray(new Item[0]));
            Collections.addAll(this.command_items_grid_visible, known_items_mapping.get(Items.f_42770_).toArray(new Item[0]));
            Collections.addAll(this.command_items_grid_visible, known_items_mapping.get(Items.f_42769_).toArray(new Item[0]));
            Collections.addAll(this.command_items_grid_visible, known_items_mapping.get(Items.f_41855_).toArray(new Item[0]));
        }

        private void update() {
            RedAntHiveMenu container = (RedAntHiveMenu)this.m_6262_();
            this.state_flags_.value(container.field(0));
            ItemStack cmdstack = container.command_slot.m_7993_();
            boolean show_process = !cmdstack.m_41619_() && this.command_items_with_process_bar.contains(cmdstack.m_41720_());
            this.grid_background_.visible = show_process && this.command_items_grid_visible.contains(cmdstack.m_41720_()) || !container.grid_storage_slot_range_.m_7983_();
            container.grid_slots.forEach(slot -> {
                slot.enabled = this.grid_background_.visible;
            });
            this.progress_bar_.f_93623_ = this.progress_bar_.f_93624_ = show_process;
            boolean bl = this.result_background_.visible = show_process && this.command_items_result_visible.contains(cmdstack.m_41720_());
            if (this.progress_bar_.f_93624_) {
                this.progress_bar_.setMaxProgress(container.field(1)).setProgress(container.field(2));
            }
            this.powered_indicator_.visible = this.state_flags_.powered();
            this.sugar_indicator_.visible = this.state_flags_.sugared();
            this.noants_indicator_.visible = this.state_flags_.noants();
            this.norecipe_indicator_.visible = this.state_flags_.norecipe() && !this.noants_indicator_.visible;
            this.noingredients_indicator_.visible = this.state_flags_.noingr() && !this.noants_indicator_.visible;
            this.nofuel_indicator_.visible = this.state_flags_.nofuel() && !this.noants_indicator_.visible;
            this.left_filter_enable_.checked(this.state_flags_.filteredinsert());
            this.passthrough_enable_.checked(!this.state_flags_.nopassthrough());
        }

        @Override
        public void m_7856_() {
            super.m_7856_();
            this.gui_background_.init((Screen)this, new Guis.Coord2d(0, 0)).show();
            this.grid_background_.init((Screen)this, new Guis.Coord2d(61, 71)).hide();
            this.result_background_.init((Screen)this, new Guis.Coord2d(87, 49)).hide();
            this.powered_indicator_.init((Screen)this, new Guis.Coord2d(153, 6)).hide();
            this.sugar_indicator_.init((Screen)this, new Guis.Coord2d(47, 20)).hide();
            this.norecipe_indicator_.init((Screen)this, new Guis.Coord2d(92, 50)).hide();
            this.noingredients_indicator_.init((Screen)this, new Guis.Coord2d(92, 50)).hide();
            this.nofuel_indicator_.init((Screen)this, new Guis.Coord2d(92, 50)).hide();
            this.noants_indicator_.init((Screen)this, new Guis.Coord2d(92, 50)).hide();
            this.m_142416_((GuiEventListener)this.progress_bar_.init((Screen)this, new Guis.Coord2d(69, 38)));
            this.m_142416_((GuiEventListener)this.left_filter_enable_.init((Screen)this, new Guis.Coord2d(20, 126)));
            this.m_142416_((GuiEventListener)this.passthrough_enable_.init((Screen)this, new Guis.Coord2d(28, 126)));
            this.left_filter_enable_.checked(this.state_flags_.filteredinsert());
            this.passthrough_enable_.checked(!this.state_flags_.nopassthrough());
            String prefix = ModContent.references.HIVE_BLOCK.m_7705_() + ".tooltips.";
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            this.tooltip_.init(new TooltipDisplay.TipRange(x0 + 164, y0 + 6, 7, 9, () -> Component.m_237115_((String)(prefix + "help"))), new TooltipDisplay.TipRange(this.powered_indicator_.m_252754_(), this.powered_indicator_.m_252907_(), this.powered_indicator_.m_5711_(), this.powered_indicator_.m_93694_(), () -> this.powered_indicator_.visible ? Component.m_237115_((String)(prefix + "powered")) : this.EMPTY_TOOLTIP), new TooltipDisplay.TipRange(this.sugar_indicator_.m_252754_(), this.sugar_indicator_.m_252907_(), this.sugar_indicator_.m_5711_(), this.sugar_indicator_.m_93694_(), () -> this.sugar_indicator_.visible ? Component.m_237115_((String)(prefix + "sugartrip")) : this.EMPTY_TOOLTIP), new TooltipDisplay.TipRange(this.norecipe_indicator_.m_252754_(), this.norecipe_indicator_.m_252907_(), this.norecipe_indicator_.m_5711_(), this.norecipe_indicator_.m_93694_(), () -> this.norecipe_indicator_.visible ? Component.m_237115_((String)(prefix + "norecipe")) : this.EMPTY_TOOLTIP), new TooltipDisplay.TipRange(this.noingredients_indicator_.m_252754_(), this.noingredients_indicator_.m_252907_(), this.noingredients_indicator_.m_5711_(), this.noingredients_indicator_.m_93694_(), () -> this.noingredients_indicator_.visible ? Component.m_237115_((String)(prefix + "noingredients")) : this.EMPTY_TOOLTIP), new TooltipDisplay.TipRange(this.nofuel_indicator_.m_252754_(), this.nofuel_indicator_.m_252907_(), this.nofuel_indicator_.m_5711_(), this.nofuel_indicator_.m_93694_(), () -> this.nofuel_indicator_.visible ? Component.m_237115_((String)(prefix + "nofuel")) : this.EMPTY_TOOLTIP), new TooltipDisplay.TipRange(this.noants_indicator_.m_252754_(), this.noants_indicator_.m_252907_(), this.noants_indicator_.m_5711_(), this.noants_indicator_.m_93694_(), () -> this.noants_indicator_.visible ? Component.m_237115_((String)(prefix + "noants")) : this.EMPTY_TOOLTIP), new TooltipDisplay.TipRange(x0 + 12, y0 + 22, 8, 8, () -> Component.m_237115_((String)(prefix + "inputside"))), new TooltipDisplay.TipRange(x0 + 156, y0 + 112, 8, 8, () -> Component.m_237115_((String)(prefix + "outputside"))), new TooltipDisplay.TipRange(x0 + 28, y0 + 126, 11, 6, () -> Component.m_237115_((String)(prefix + "passthroughlock"))), new TooltipDisplay.TipRange(x0 + 20, y0 + 126, 5, 6, () -> Component.m_237115_((String)(prefix + "insertionlock"))), new TooltipDisplay.TipRange(x0 + 26, y0 + 18, 16, 16, () -> ((RedAntHiveMenu)this.m_6262_()).input_selection_slot.m_6657_() ? this.EMPTY_TOOLTIP : Component.m_237115_((String)(prefix + "inputselect"))), new TooltipDisplay.TipRange(x0 + 134, y0 + 108, 16, 16, () -> ((RedAntHiveMenu)this.m_6262_()).output_selection_slot.m_6657_() ? this.EMPTY_TOOLTIP : Component.m_237115_((String)(prefix + "outputselect"))), new TooltipDisplay.TipRange(x0 + 70, y0 + 50, 16, 16, () -> ((RedAntHiveMenu)this.m_6262_()).command_slot.m_6657_() ? this.EMPTY_TOOLTIP : Component.m_237115_((String)(prefix + "workselect"))), new TooltipDisplay.TipRange(x0 + 62, y0 + 18, 52, 16, () -> ((RedAntHiveMenu)this.m_6262_()).ant_slot_range_.m_7983_() ? Component.m_237115_((String)(prefix + "antslots")) : this.EMPTY_TOOLTIP)).delay(400);
            this.update();
        }

        public void m_181908_() {
            super.m_181908_();
            this.update();
        }

        @Override
        public void m_88315_(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
            super.m_88315_(gg, mouseX, mouseY, partialTicks);
            if (!this.tooltip_.render(gg, this, mouseX, mouseY)) {
                this.m_280072_(gg, mouseX, mouseY);
            }
        }

        @Override
        protected void m_280003_(GuiGraphics gg, int x, int y) {
            gg.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x303030, false);
        }

        protected void m_6597_(Slot slot, int slotId, int button, ClickType type) {
            this.tooltip_.resetTimer();
            super.m_6597_(slot, slotId, button, type);
        }

        public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
            this.tooltip_.resetTimer();
            return super.m_6375_(mouseX, mouseY, mouseButton);
        }

        @Override
        protected void renderBgWidgets(GuiGraphics gg, float partialTicks, int mouseX, int mouseY) {
            Slot slot;
            int i;
            RedAntHiveMenu container = (RedAntHiveMenu)this.m_6262_();
            this.gui_background_.draw(gg, (Screen)this);
            this.grid_background_.draw(gg, (Screen)this);
            this.result_background_.draw(gg, (Screen)this);
            this.powered_indicator_.draw(gg, (Screen)this);
            this.sugar_indicator_.draw(gg, (Screen)this);
            this.norecipe_indicator_.draw(gg, (Screen)this);
            this.noants_indicator_.draw(gg, (Screen)this);
            this.noingredients_indicator_.draw(gg, (Screen)this);
            this.nofuel_indicator_.draw(gg, (Screen)this);
            ItemStack stack = container.result_slot.m_7993_();
            if (!stack.m_41619_()) {
                this.renderItemTemplate(gg, stack, container.result_slot.f_40220_, container.result_slot.f_40221_);
            }
            for (i = 0; i < 3; ++i) {
                slot = container.m_38853_(20 + i);
                if (!slot.m_7993_().m_41619_()) continue;
                this.renderItemTemplate(gg, new ItemStack((ItemLike)ModContent.references.ANTS_ITEM), slot.f_40220_, slot.f_40221_);
            }
            if (this.state_flags_.filteredinsert()) {
                for (i = 0; i < 10; ++i) {
                    ItemStack filter_stack;
                    slot = container.m_38853_(0 + i);
                    if (!slot.m_7993_().m_41619_() || (filter_stack = container.left_filter_slot_range_.m_8020_(i)).m_41619_()) continue;
                    this.renderItemTemplate(gg, filter_stack, slot.f_40220_, slot.f_40221_);
                }
            }
        }
    }

    public static class RedAntHiveMenu
    extends AbstractContainerMenu
    implements Networking.INetworkSynchronisableContainer {
        private final RedAntHiveTileEntity te_;
        private final Player player_;
        private final ContainerLevelAccess wpc_;
        private final ContainerData fields_;
        private final Inventories.InventoryRange block_inventory_;
        private final Inventories.InventoryRange left_storage_slot_range_;
        private final Inventories.InventoryRange left_filter_slot_range_;
        private final Inventories.InventoryRange right_storage_slot_range_;
        private final Inventories.InventoryRange player_inventory_range_;
        private final Inventories.InventoryRange grid_storage_slot_range_;
        private final Inventories.InventoryRange ant_slot_range_;
        public final Containers.StorageSlot command_slot;
        public final Containers.StorageSlot input_selection_slot;
        public final Containers.StorageSlot output_selection_slot;
        public final Containers.LockedSlot result_slot;
        public final List<Containers.StorageSlot> grid_slots;
        private final int storage_slot_count;

        public RedAntHiveMenu(int windowId, Inventory player_inventory) {
            this(windowId, player_inventory, (Container)new SimpleContainer(55), ContainerLevelAccess.f_39287_, (ContainerData)new SimpleContainerData(3));
        }

        private RedAntHiveMenu(int windowId, Inventory player_inventory, Container block_inventory, ContainerLevelAccess wpc, ContainerData fields) {
            super(Registries.getMenuTypeOfBlock("hive"), windowId);
            int ypos;
            int xpos;
            int x;
            int y;
            this.wpc_ = wpc;
            this.player_ = player_inventory.f_35978_;
            this.fields_ = fields;
            this.player_inventory_range_ = Inventories.InventoryRange.fromPlayerInventory(this.player_);
            this.block_inventory_ = new Inventories.InventoryRange(block_inventory);
            this.block_inventory_.setValidator(RedAntHiveTileEntity.main_inventory_validator());
            this.left_storage_slot_range_ = new Inventories.InventoryRange(this.block_inventory_, 0, 10, 5);
            this.left_filter_slot_range_ = new Inventories.InventoryRange(this.block_inventory_, 45, 10, 5);
            this.right_storage_slot_range_ = new Inventories.InventoryRange(this.block_inventory_, 10, 10, 5);
            this.grid_storage_slot_range_ = new Inventories.InventoryRange(this.block_inventory_, 24, 9, 3);
            this.ant_slot_range_ = new Inventories.InventoryRange(this.block_inventory_, 20, 3, 1);
            this.te_ = this.wpc_.m_6721_((w, p) -> {
                this.block_inventory_.m_5856_(this.player_);
                BlockEntity te = w.m_7702_(p);
                return te instanceof RedAntHiveTileEntity ? (RedAntHiveTileEntity)te : null;
            }).orElse(null);
            int i = -1;
            for (y = 0; y < 5; ++y) {
                for (x = 0; x < 2; ++x) {
                    xpos = 8 + x * 18;
                    ypos = 36 + y * 18;
                    Containers.StorageSlot slot = new Containers.StorageSlot(this.block_inventory_, ++i, xpos, ypos);
                    int inventory_index = i;
                    if (this.te_ != null) {
                        slot.setSlotChangeNotifier((old_stack, new_stack) -> {
                            if (!old_stack.m_41619_() || new_stack.m_41619_()) {
                                return;
                            }
                            if (!this.te_.getStateFlags().filteredinsert() || inventory_index < 0 || inventory_index >= this.left_storage_slot_range_.size()) {
                                return;
                            }
                            ItemStack filter_stack = new_stack.m_41777_();
                            filter_stack.m_41764_(1);
                            this.left_filter_slot_range_.m_6836_(inventory_index, filter_stack);
                            this.sync();
                        });
                    }
                    this.m_38897_(slot);
                }
            }
            for (y = 0; y < 5; ++y) {
                for (x = 0; x < 2; ++x) {
                    xpos = 134 + x * 18;
                    ypos = 18 + y * 18;
                    this.m_38897_(new Containers.StorageSlot(this.block_inventory_, ++i, xpos, ypos));
                }
            }
            for (y = 0; y < 1; ++y) {
                for (x = 0; x < 3; ++x) {
                    xpos = 62 + x * 18;
                    ypos = 18 + y * 18;
                    this.m_38897_(new Containers.StorageSlot(this.block_inventory_, ++i, xpos, ypos));
                }
            }
            int xpos2 = 70;
            int ypos2 = 50;
            this.command_slot = new Containers.StorageSlot(this.block_inventory_, ++i, xpos2, ypos2).setSlotStackLimit(1);
            this.m_38897_(this.command_slot);
            ArrayList<Containers.StorageSlot> slots = new ArrayList<Containers.StorageSlot>();
            for (int y2 = 0; y2 < 3; ++y2) {
                for (int x2 = 0; x2 < 3; ++x2) {
                    int xpos3 = 62 + x2 * 18;
                    int ypos3 = 72 + y2 * 18;
                    Containers.StorageSlot slot = new Containers.StorageSlot(this.block_inventory_, ++i, xpos3, ypos3).setSlotStackLimit(1);
                    slots.add(slot);
                    this.m_38897_(slot);
                }
            }
            this.grid_slots = ImmutableList.copyOf(slots);
            xpos = 26;
            ypos2 = 18;
            this.input_selection_slot = new Containers.StorageSlot(this.block_inventory_, ++i, xpos, ypos2).setSlotStackLimit(1);
            this.m_38897_(this.input_selection_slot);
            xpos = 134;
            ypos2 = 108;
            this.output_selection_slot = new Containers.StorageSlot(this.block_inventory_, ++i, xpos, ypos2).setSlotStackLimit(1);
            this.m_38897_(this.output_selection_slot);
            xpos = 92;
            ypos2 = 50;
            this.result_slot = new Containers.LockedSlot(this.block_inventory_, ++i, xpos, ypos2);
            this.m_38897_(this.result_slot);
            this.result_slot.enabled = false;
            this.storage_slot_count = i + 1;
            while (i < this.block_inventory_.m_6643_() - 1) {
                this.m_38897_(new Containers.HiddenSlot(this.block_inventory_, ++i));
            }
            for (int x3 = 0; x3 < 9; ++x3) {
                this.m_38897_(new Slot((Container)player_inventory, x3, 8 + x3 * 18, 198));
            }
            for (int y3 = 0; y3 < 3; ++y3) {
                for (x = 0; x < 9; ++x) {
                    this.m_38897_(new Slot((Container)player_inventory, x + y3 * 9 + 9, 8 + x * 18, 140 + y3 * 18));
                }
            }
            this.m_38884_(this.fields_);
        }

        public final int field(int index) {
            return this.fields_.m_6413_(index);
        }

        private void sync() {
            this.block_inventory_.m_6596_();
            this.player_.m_150109_().m_6596_();
            this.m_38946_();
        }

        public boolean m_6875_(Player player) {
            return this.block_inventory_.m_6542_(player);
        }

        public void m_6877_(Player player) {
            super.m_6877_(player);
            this.block_inventory_.m_5785_(player);
        }

        public ItemStack m_7648_(Player player, int index) {
            int player_start_index = this.block_inventory_.m_6643_();
            Slot slot = this.m_38853_(index);
            if (!slot.m_6657_()) {
                return ItemStack.f_41583_;
            }
            ItemStack slot_stack = slot.m_7993_();
            ItemStack transferred = slot_stack.m_41777_();
            if (index >= 0 && index < player_start_index) {
                if (!this.m_38903_(slot_stack, player_start_index, player_start_index + 36, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index >= player_start_index && index <= player_start_index + 36) {
                if (slot_stack.m_41720_() == ModContent.references.ANTS_ITEM) {
                    if (!this.m_38903_(slot_stack, 20, 23, false)) {
                        return ItemStack.f_41583_;
                    }
                } else {
                    ItemStack remaining = this.left_storage_slot_range_.insert(slot_stack);
                    if (!remaining.m_41619_()) {
                        remaining = this.right_storage_slot_range_.insert(remaining.m_41777_());
                    }
                    if (remaining.m_41613_() == slot_stack.m_41613_()) {
                        return ItemStack.f_41583_;
                    }
                    slot_stack.m_41764_(remaining.m_41613_());
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (slot_stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slot_stack.m_41613_() == transferred.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slot_stack);
            return transferred;
        }

        public void m_150399_(int slot, int dragType, ClickType clickType, Player player) {
            if (this.te_ == null || slot < 0 || slot >= this.storage_slot_count || dragType != 0 || clickType != ClickType.PICKUP || this.m_38853_(slot).m_6657_() || !this.te_.getStateFlags().filteredinsert()) {
                super.m_150399_(slot, dragType, clickType, player);
                return;
            }
            int index = this.m_38853_(slot).m_150661_() - this.left_storage_slot_range_.offset();
            if (index < 0 || index >= this.left_storage_slot_range_.size()) {
                super.m_150399_(slot, dragType, clickType, player);
            } else {
                super.m_150399_(slot, dragType, clickType, player);
                if (!this.m_38853_(slot).m_6657_()) {
                    this.left_filter_slot_range_.m_6836_(index, ItemStack.f_41583_);
                    this.sync();
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(CompoundTag nbt) {
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String key, int value) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_(key, value);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String message) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("action", message);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String message, CompoundTag nbt) {
            nbt.m_128359_("action", message);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundTag nbt) {
        }

        @Override
        public void onClientPacketReceived(int windowId, Player player, CompoundTag nbt) {
            if (!nbt.m_128441_("action")) {
                return;
            }
            boolean changed = false;
            int slotId = nbt.m_128441_("slot") ? nbt.m_128451_("slot") : -1;
            switch (nbt.m_128461_("action")) {
                case "input-filter-on": {
                    this.te_.enableInsertionFilter(true);
                    changed = true;
                    break;
                }
                case "input-filter-off": {
                    this.te_.enableInsertionFilter(false);
                    changed = true;
                    break;
                }
                case "pass-through-on": {
                    this.te_.getStateFlags().nopassthrough(false);
                    changed = true;
                    break;
                }
                case "pass-through-off": {
                    this.te_.getStateFlags().nopassthrough(true);
                    changed = true;
                    break;
                }
            }
            if (changed) {
                this.block_inventory_.m_6596_();
                player.m_150109_().m_6596_();
                this.m_38946_();
            }
        }
    }
}

