/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import wile.anthillinside.ModContent;
import wile.anthillinside.blocks.RedAntTrail;
import wile.anthillinside.libmc.Inventories;
import wile.anthillinside.libmc.Registries;
import wile.anthillinside.libmc.StandardBlocks;
import wile.anthillinside.libmc.StandardEntityBlocks;

public class RedAntCoveredTrail {
    private static final int max_transfer_stack_size = 8;

    public static class RedAntCoveredTrailTileEntity
    extends StandardEntityBlocks.StandardBlockEntity {
        protected final Inventories.StorageInventory main_inventory_ = new Inventories.StorageInventory(this, 1);
        protected final Inventories.InventoryRange inventory_range_ = new Inventories.InventoryRange(this.main_inventory_, 0, 1);
        public static final int TICK_INTERVAL = 4;
        public static final int TICK_INTERVAL_FAST = 2;
        private int tick_timer_ = 0;
        protected LazyOptional<? extends IItemHandler> item_handler_;

        public RedAntCoveredTrailTileEntity(BlockPos pos, BlockState state) {
            super(Registries.getBlockEntityTypeOfBlock(state.m_60734_()), pos, state);
            this.initItemHandler();
        }

        public void m_7651_() {
            super.m_7651_();
            this.item_handler_.invalidate();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == ForgeCapabilities.ITEM_HANDLER) {
                return this.item_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        private void initItemHandler() {
            this.item_handler_ = Inventories.MappedItemHandler.createGenericHandler(this.main_inventory_, (slot, stack) -> slot >= this.inventory_range_.offset() && slot < this.inventory_range_.offset() + this.inventory_range_.size(), (slot, stack) -> slot >= this.inventory_range_.offset() && slot < this.inventory_range_.offset() + this.inventory_range_.size() && this.insertionAllowed(this.inventory_range_.offset() + slot, (ItemStack)stack));
        }

        public CompoundTag clear_getnbt() {
            CompoundTag nbt = new CompoundTag();
            if (!this.main_inventory_.m_7983_()) {
                this.writenbt(nbt, false);
            } else {
                this.main_inventory_.m_6211_();
            }
            return nbt;
        }

        public void readnbt(CompoundTag nbt, boolean update_packet) {
            this.main_inventory_.load(nbt);
        }

        protected void writenbt(CompoundTag nbt, boolean update_packet) {
            this.main_inventory_.save(nbt);
        }

        public int comparatorValue() {
            if (this.main_inventory_.m_7983_()) {
                return 0;
            }
            int max = this.main_inventory_.m_8020_(0).m_41741_();
            int use = this.main_inventory_.m_8020_(0).m_41613_();
            if (use == 0) {
                return 0;
            }
            if (use == max) {
                return 15;
            }
            return 1 + 14 * use / max;
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt, false);
        }

        protected void m_183515_(CompoundTag nbt) {
            super.m_183515_(nbt);
            this.writenbt(nbt, false);
        }

        @Override
        public void tick() {
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 4;
            boolean dirty = this.checkItemInput();
            if (this.checkItemOutput()) {
                dirty = true;
                this.tick_timer_ = 2;
            }
            if (dirty) {
                this.m_6596_();
            }
        }

        protected boolean insertionAllowed(int index, ItemStack stack) {
            if (index >= this.inventory_range_.size()) {
                return false;
            }
            if (this.inventory_range_.m_8020_(index).m_41619_()) {
                return true;
            }
            return this.inventory_range_.m_8020_(index).m_41720_() == stack.m_41720_();
        }

        protected ItemStack insert(ItemStack stack) {
            return this.inventory_range_.insert(stack.m_41777_());
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean checkItemOutput() {
            Inventories.ItemPort ih;
            block8: {
                Direction output_facing = (Direction)this.m_58900_().m_61143_((Property)RedAntCoveredTrailBlock.FACING);
                BlockPos output_position = this.m_58899_().m_121945_(output_facing);
                ih = Inventories.ItemPort.of(this.m_58904_(), output_position, output_facing.m_122424_(), true);
                if (ih != Inventories.ItemPort.EMPTY) {
                    if (ih.allowsInsertion()) {
                        break block8;
                    } else {
                        BlockState trail_state = this.m_58904_().m_8055_(output_position);
                        if (!trail_state.m_60713_((Block)ModContent.references.TRAIL_BLOCK)) {
                            return false;
                        }
                        if (output_facing == ((Direction)trail_state.m_61143_((Property)RedAntTrail.RedAntTrailBlock.HORIZONTAL_FACING)).m_122424_() || output_facing == Direction.DOWN && ((Boolean)trail_state.m_61143_((Property)RedAntTrail.RedAntTrailBlock.UP)).booleanValue()) {
                            return false;
                        }
                        Inventories.dropStack(this.m_58904_(), Vec3.m_82512_((Vec3i)output_position).m_82520_(0.0, -0.4, 0.0), this.inventory_range_.extract(1), new Vec3(0.0, -0.2, 0.0), 0.1, 0.1);
                        return true;
                    }
                }
                BlockState state = this.m_58904_().m_8055_(output_position);
                if (state.m_60838_((BlockGetter)this.m_58904_(), output_position)) {
                    return false;
                }
                ItemStack stack = this.inventory_range_.extract(1, true);
                Vec3 drop_pos = Vec3.m_82512_((Vec3i)output_position).m_82549_(Vec3.m_82528_((Vec3i)output_facing.m_122424_().m_122436_()).m_82490_(0.1));
                Vec3 speed = Vec3.m_82528_((Vec3i)output_facing.m_122436_()).m_82490_(0.02);
                Inventories.dropStack(this.m_58904_(), drop_pos, stack, speed, 0.2, 0.02);
                return false;
            }
            for (int slot = 0; slot < this.inventory_range_.size(); ++slot) {
                ItemStack remaining;
                ItemStack ostack = this.inventory_range_.m_8020_(slot);
                if (ostack.m_41619_()) continue;
                ItemStack stack = ostack.m_41777_();
                if (stack.m_41613_() > 8) {
                    stack.m_41764_(8);
                }
                if ((remaining = ih.insert(stack)).m_41613_() == stack.m_41613_()) continue;
                int n_inserted = stack.m_41613_() - remaining.m_41613_();
                this.inventory_range_.m_8020_(slot).m_41774_(n_inserted);
                return true;
            }
            return false;
        }

        private boolean checkItemInput() {
            Direction input_facing = ((Direction)this.m_58900_().m_61143_((Property)RedAntCoveredTrailBlock.FACING)).m_122424_();
            Inventories.ItemPort ih = Inventories.ItemPort.of(this.m_58904_(), this.m_58899_().m_121945_(input_facing), input_facing.m_122424_(), true);
            if (ih == Inventories.ItemPort.EMPTY || !ih.allowsExtraction()) {
                return false;
            }
            return this.inventory_range_.iterate((slot, ref_stack) -> {
                if (ref_stack.m_41613_() >= ref_stack.m_41741_() || ref_stack.m_41613_() >= this.inventory_range_.m_6893_()) {
                    return false;
                }
                if (ref_stack.m_41619_()) {
                    ItemStack fetched = ih.extract(ref_stack.m_41619_() ? null : ref_stack, 8, false);
                    if (!fetched.m_41619_()) {
                        this.insert(fetched);
                        return true;
                    }
                } else {
                    int limit = Math.min(8, ref_stack.m_41741_() - ref_stack.m_41613_());
                    ItemStack fetched = ih.extract((ItemStack)ref_stack, limit, false);
                    if (!fetched.m_41619_()) {
                        this.insert(fetched);
                        return true;
                    }
                }
                return false;
            });
        }
    }

    public static class RedAntCoveredTrailBlock
    extends StandardBlocks.DirectedWaterLoggable
    implements StandardEntityBlocks.IStandardEntityBlock<RedAntCoveredTrailTileEntity> {
        public RedAntCoveredTrailBlock(long config, BlockBehaviour.Properties props, AABB[] aabbs) {
            super(config, props.m_60924_((s, w, p) -> false), aabbs);
            this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.DOWN));
        }

        @Override
        public boolean isBlockEntityTicking(Level world, BlockState state) {
            return true;
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return Shapes.m_83144_();
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            BlockState state = (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
            if (state == null) {
                return null;
            }
            if (context.m_43723_().m_6144_()) {
                state = (BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)).m_122424_());
            } else {
                Direction adjacent_facing;
                BlockState opposite_state;
                Direction adjacent_facing2;
                boolean skip = false;
                BlockState clicked_state = context.m_43725_().m_8055_(context.m_8083_().m_121945_(context.m_43719_().m_122424_()));
                if ((clicked_state.m_60713_((Block)ModContent.references.COVERED_TRAIL_BLOCK) || clicked_state.m_60713_((Block)ModContent.references.HIVE_BLOCK)) && (adjacent_facing2 = (Direction)clicked_state.m_61143_((Property)FACING)).m_122434_() == context.m_43719_().m_122434_()) {
                    state = (BlockState)state.m_61124_((Property)FACING, (Comparable)adjacent_facing2);
                    skip = true;
                }
                if (!skip && ((opposite_state = context.m_43725_().m_8055_(context.m_8083_().m_121945_(context.m_43719_()))).m_60713_((Block)ModContent.references.COVERED_TRAIL_BLOCK) || opposite_state.m_60713_((Block)ModContent.references.HIVE_BLOCK)) && (adjacent_facing = (Direction)opposite_state.m_61143_((Property)FACING)).m_122434_() == context.m_43719_().m_122434_()) {
                    state = (BlockState)state.m_61124_((Property)FACING, (Comparable)adjacent_facing);
                }
            }
            return state;
        }

        public boolean m_7278_(BlockState state) {
            return true;
        }

        public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
            BlockEntity te = world.m_7702_(pos);
            return te instanceof RedAntCoveredTrailTileEntity ? ((RedAntCoveredTrailTileEntity)te).comparatorValue() : 0;
        }

        @Override
        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            return new RedAntCoveredTrailTileEntity(pos, state);
        }

        public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            if (world.m_5776_()) {
                return;
            }
            if (!stack.m_41782_() || !stack.m_41784_().m_128441_("tedata")) {
                return;
            }
            CompoundTag te_nbt = stack.m_41784_().m_128469_("tedata");
            if (te_nbt.m_128456_()) {
                return;
            }
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof RedAntCoveredTrailTileEntity)) {
                return;
            }
            ((RedAntCoveredTrailTileEntity)te).readnbt(te_nbt, false);
            te.m_6596_();
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
            if (world.m_5776_() || !(te instanceof RedAntCoveredTrailTileEntity)) {
                return Collections.emptyList();
            }
            RedAntCoveredTrailTileEntity rte = (RedAntCoveredTrailTileEntity)te;
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(new ItemStack((ItemLike)this.m_5456_()));
            rte.inventory_range_.forEach(drops::add);
            rte.main_inventory_.m_6211_();
            return drops;
        }

        public boolean shouldCheckWeakPower(BlockState state, SignalGetter world, BlockPos pos, Direction side) {
            return false;
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            if (!player.m_21120_(hand).m_41619_()) {
                return InteractionResult.PASS;
            }
            if (world.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            int co = this.m_6782_(state, world, pos);
            float min = 0.9f;
            float max = 1.4f;
            float pitch = min + (max - min) * (float)co / 15.0f;
            if (co == 0) {
                pitch = 0.3f;
            }
            world.m_5594_(null, pos, SoundEvents.f_244240_, SoundSource.BLOCKS, 1.0f, pitch);
            return InteractionResult.CONSUME;
        }
    }
}

