/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside.blocks;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import wile.anthillinside.ModContent;
import wile.anthillinside.libmc.Auxiliaries;
import wile.anthillinside.libmc.Overlay;
import wile.anthillinside.libmc.StandardBlocks;

public class QueensLair {
    private static int use_health_restore_probability_percent = 50;
    private static int rndtick_health_loss_probability_percent = 30;
    private static int rndtick_growth_probability_percent = 30;
    private static boolean trace_progress_and_health = false;

    public static void on_config(int health_restore_probability_percent, int health_loss_probability_percent, int growth_probability_percent, boolean enable_log_tracing) {
        use_health_restore_probability_percent = Mth.m_14045_((int)health_restore_probability_percent, (int)10, (int)100);
        rndtick_health_loss_probability_percent = Mth.m_14045_((int)health_loss_probability_percent, (int)10, (int)90);
        rndtick_growth_probability_percent = Mth.m_14045_((int)growth_probability_percent, (int)10, (int)90);
        trace_progress_and_health = enable_log_tracing;
    }

    public static class QueensLairBlock
    extends StandardBlocks.Cutout {
        public static final IntegerProperty HEALTH = IntegerProperty.m_61631_((String)"health", (int)0, (int)7);
        public static final IntegerProperty GROWTH = IntegerProperty.m_61631_((String)"growth", (int)0, (int)3);
        private static final int MAX_HEALTH = (Integer)HEALTH.m_6908_().stream().max(Integer::compareTo).orElseThrow();
        private static final int MAX_GROWTH = (Integer)GROWTH.m_6908_().stream().max(Integer::compareTo).orElseThrow();

        public QueensLairBlock(long config, BlockBehaviour.Properties properties, AABB[] aabbs) {
            super(config, properties, aabbs);
            this.m_49959_((BlockState)((BlockState)super.m_49966_().m_61124_((Property)HEALTH, (Comparable)Integer.valueOf(1))).m_61124_((Property)GROWTH, (Comparable)Integer.valueOf(0)));
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
            return Collections.singletonList(new ItemStack((ItemLike)this.m_5456_()));
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{HEALTH, GROWTH});
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            return super.m_5573_(context);
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rtr) {
            if (world.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            ItemStack red_sugar = player.m_21120_(hand);
            if (red_sugar.m_150930_((Item)ModContent.references.RED_SUGAR_ITEM) && (Integer)state.m_61143_((Property)HEALTH) < MAX_HEALTH) {
                if (!player.m_7500_()) {
                    red_sugar.m_41774_(1);
                }
                if (red_sugar.m_41619_()) {
                    player.m_21008_(hand, ItemStack.f_41583_);
                }
                if (world.m_213780_().m_216339_(0, 100) < use_health_restore_probability_percent) {
                    state = (BlockState)state.m_61124_((Property)HEALTH, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)HEALTH) + 1));
                    world.m_7731_(pos, state, 10);
                    Auxiliaries.particles(world, pos, (ParticleOptions)ParticleTypes.f_123751_);
                } else {
                    Auxiliaries.particles(world, pos, (ParticleOptions)ParticleTypes.f_123762_);
                }
            }
            Overlay.show((Player)((ServerPlayer)player), Auxiliaries.localizable("block." + Auxiliaries.modid() + ".queens_lair.health" + state.m_61143_((Property)HEALTH)));
            return InteractionResult.CONSUME;
        }

        public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
            if (world.m_5776_()) {
                return;
            }
            int health = (Integer)state.m_61143_((Property)HEALTH);
            int growth = (Integer)state.m_61143_((Property)GROWTH);
            if (rand.m_216339_(0, 100) < rndtick_health_loss_probability_percent) {
                if (health > 0) {
                    state = (BlockState)state.m_61124_((Property)HEALTH, (Comparable)Integer.valueOf(health - 1));
                    world.m_7731_(pos, state, 10);
                    Auxiliaries.particles((Level)world, pos, (ParticleOptions)ParticleTypes.f_123792_);
                } else if (growth > 0 && rand.m_216339_(0, 100) < rndtick_growth_probability_percent) {
                    state = (BlockState)state.m_61124_((Property)GROWTH, (Comparable)Integer.valueOf(growth - 1));
                    world.m_7731_(pos, state, 10);
                    Auxiliaries.particles((Level)world, pos, (ParticleOptions)ParticleTypes.f_123749_);
                }
            } else {
                int growth_chance = rndtick_growth_probability_percent * health / MAX_HEALTH;
                if (rand.m_216339_(0, 100) < growth_chance) {
                    if (growth >= MAX_GROWTH) {
                        world.m_7731_(pos, ModContent.references.HIVE_BLOCK.m_49966_(), 11);
                        world.m_5594_(null, pos, SoundEvents.f_11675_, SoundSource.BLOCKS, 1.0f, 1.1f);
                        Auxiliaries.particles((Level)world, Vec3.m_82512_((Vec3i)pos), (ParticleOptions)ParticleTypes.f_123751_, 10.0f);
                    } else {
                        state = (BlockState)state.m_61124_((Property)GROWTH, (Comparable)Integer.valueOf(growth + 1));
                        world.m_7731_(pos, state, 10);
                        Auxiliaries.particles((Level)world, Vec3.m_82512_((Vec3i)pos).m_82520_(0.0, 0.2, 0.0), (ParticleOptions)ParticleTypes.f_123751_, 5.0f);
                    }
                }
            }
            if (trace_progress_and_health) {
                Auxiliaries.logInfo("Queens-Lair: health:" + health + "->" + state.m_61143_((Property)HEALTH) + ", growth:" + growth + "->" + state.m_61143_((Property)GROWTH));
            }
        }
    }
}

