/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import wile.anthillinside.ModAnthillInside;
import wile.anthillinside.blocks.RedAntHive;
import wile.anthillinside.blocks.RedAntTrail;
import wile.anthillinside.libmc.Auxiliaries;

public class ModConfig {
    private static final Logger LOGGER = ModAnthillInside.LOGGER;
    private static final String MODID = "anthillinside";
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_CONFIG_SPEC;
    private static final CompoundTag server_config_;
    private static final HashSet<String> optouts_;
    private static boolean with_experimental_features_;
    private static boolean with_config_logging_;

    public static boolean isOptedOut(@Nullable Block block) {
        return ModConfig.isOptedOut(block.m_5456_());
    }

    public static boolean isOptedOut(@Nullable Item item) {
        return item != null && optouts_.contains(Auxiliaries.getResourceLocation(item).m_135815_());
    }

    public static boolean withExperimental() {
        return with_experimental_features_;
    }

    public static boolean withoutRecipes() {
        return false;
    }

    public static boolean withDebugLogging() {
        return with_experimental_features_ && with_config_logging_;
    }

    public static CompoundTag getServerConfig() {
        return server_config_;
    }

    private static void updateOptouts() {
        optouts_.clear();
    }

    public static void apply() {
        if (!COMMON_CONFIG_SPEC.isLoaded()) {
            return;
        }
        with_config_logging_ = (Boolean)ModConfig.COMMON.with_config_logging.get();
        with_experimental_features_ = (Boolean)ModConfig.COMMON.with_experimental.get();
        if (with_experimental_features_) {
            LOGGER.info("Config: EXPERIMENTAL FEATURES ENABLED.");
        }
        ModConfig.updateOptouts();
        ArrayList unknown_items = new ArrayList();
        HashMap<Item, HashSet<Item>> known_items = new HashMap<Item, HashSet<Item>>();
        BiConsumer<Item, List> add_known_items = (ref_item, item_regnames) -> {
            known_items.putIfAbsent((Item)ref_item, new HashSet());
            HashSet items = (HashSet)known_items.get(ref_item);
            item_regnames.forEach(s -> {
                try {
                    ResourceLocation rl = ResourceLocation.m_135820_((String)s);
                    if (rl == null) {
                        unknown_items.add(s);
                        return;
                    }
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(rl);
                    if (item == null) {
                        return;
                    }
                    items.add(item);
                }
                catch (Throwable ex) {
                    unknown_items.add(s);
                }
            });
        };
        add_known_items.accept(Items.f_41960_, (List)ModConfig.COMMON.crafting_tables.get());
        add_known_items.accept(Items.f_41962_, (List)ModConfig.COMMON.furnaces.get());
        add_known_items.accept(Items.f_42770_, (List)ModConfig.COMMON.blast_furnaces.get());
        add_known_items.accept(Items.f_42769_, (List)ModConfig.COMMON.smokers.get());
        add_known_items.accept(Items.f_42726_, (List)ModConfig.COMMON.composters.get());
        add_known_items.accept(Items.f_42543_, (List)ModConfig.COMMON.brewing_stands.get());
        add_known_items.accept(Items.f_42773_, (List)ModConfig.COMMON.grindstones.get());
        add_known_items.accept(Items.f_42155_, (List)ModConfig.COMMON.hoppers.get());
        add_known_items.accept(Items.f_42162_, (List)ModConfig.COMMON.droppers.get());
        add_known_items.accept(Items.f_41855_, (List)ModConfig.COMMON.dispensers.get());
        add_known_items.accept(Items.f_42574_, (List)ModConfig.COMMON.shears.get());
        add_known_items.accept(Items.f_42387_, (List)ModConfig.COMMON.hoes.get());
        add_known_items.accept(Items.f_42386_, (List)ModConfig.COMMON.axes.get());
        add_known_items.accept(Items.f_42385_, (List)ModConfig.COMMON.pickaxes.get());
        known_items.putIfAbsent(Items.f_42499_, new HashSet());
        ((HashSet)known_items.get(Items.f_42499_)).add(Items.f_42499_);
        known_items.putIfAbsent(Items.f_42405_, new HashSet());
        ((HashSet)known_items.get(Items.f_42405_)).add(Items.f_42405_);
        ((HashSet)known_items.get(Items.f_42405_)).add(Items.f_42404_);
        ((HashSet)known_items.get(Items.f_42405_)).add(Items.f_42619_);
        known_items.putIfAbsent(Items.f_42499_, new HashSet());
        ((HashSet)known_items.get(Items.f_42499_)).add(Items.f_42499_);
        known_items.putIfAbsent(Items.f_42446_, new HashSet());
        ((HashSet)known_items.get(Items.f_42446_)).add(Items.f_42446_);
        known_items.putIfAbsent(Items.f_42523_, new HashSet());
        ((HashSet)known_items.get(Items.f_42523_)).add(Items.f_42523_);
        if (!unknown_items.isEmpty()) {
            Auxiliaries.logInfo("Unknown items/invalid resource locations in config: [" + String.join((CharSequence)",", unknown_items) + "]");
        }
        RedAntTrail.on_config();
        RedAntHive.on_config(known_items, (Integer)ModConfig.COMMON.hive_drop_chance_percent.get(), (Integer)ModConfig.COMMON.hive_processing_speed_percent.get(), (Integer)ModConfig.COMMON.hive_sugar_boost_time_s.get(), (Integer)ModConfig.COMMON.hive_growth_period_s.get(), (Integer)ModConfig.COMMON.hive_animal_feeding_speed_percent.get(), 16, 3, (Integer)ModConfig.COMMON.hive_farming_speed_percent.get(), 100, 100, 100);
    }

    public static void log(String config_message) {
        if (!with_config_logging_) {
            return;
        }
        LOGGER.info(config_message);
    }

    static {
        Pair common_ = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_CONFIG_SPEC = (ForgeConfigSpec)common_.getRight();
        COMMON = (CommonConfig)common_.getLeft();
        server_config_ = new CompoundTag();
        optouts_ = new HashSet();
        with_experimental_features_ = false;
        with_config_logging_ = false;
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.BooleanValue with_experimental;
        public final ForgeConfigSpec.BooleanValue with_config_logging;
        public final ForgeConfigSpec.IntValue hive_drop_chance_percent;
        public final ForgeConfigSpec.IntValue hive_processing_speed_percent;
        public final ForgeConfigSpec.IntValue hive_sugar_boost_time_s;
        public final ForgeConfigSpec.IntValue hive_growth_period_s;
        public final ForgeConfigSpec.IntValue hive_animal_feeding_speed_percent;
        public final ForgeConfigSpec.IntValue hive_farming_speed_percent;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> crafting_tables;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> furnaces;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> blast_furnaces;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> smokers;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> hoppers;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> composters;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> brewing_stands;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> grindstones;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> dispensers;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> droppers;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> shears;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> hoes;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> axes;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> pickaxes;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings affecting the logical server side.").push("server");
            builder.comment("Miscellaneous settings").push("miscellaneous");
            this.with_experimental = builder.translation("anthillinside.config.with_experimental").comment("Enables experimental features. Use at own risk.").define("with_experimental", false);
            this.with_config_logging = builder.translation("anthillinside.config.with_config_logging").comment("Enable detailed logging of the config values and resulting calculations in each mod feature config.").define("with_config_logging", false);
            builder.pop();
            builder.comment("Tweak settings").push("tweaks");
            this.hive_drop_chance_percent = builder.translation("anthillinside.config.hive_drop_chance_percent").comment("Sets how probable it is that a Red Ant Hive drops when manually mining Redstone Ore. The value 0 disables drops from Redstone mining (you need to add your own recipe in a data pack).").defineInRange("hive_drop_chance_percent", 3, 0, 20);
            this.hive_processing_speed_percent = builder.translation("anthillinside.config.hive_processing_speed_percent").comment("Sets how fast the ant processing part of work process is (in percent).").defineInRange("hive_processing_speed_percent", 100, 50, 150);
            this.hive_sugar_boost_time_s = builder.translation("anthillinside.config.hive_sugar_boost_time_s").comment("Sets how long the Red Sugar boost lasts (in seconds).").defineInRange("hive_sugar_boost_time_s", 5, 1, 60);
            this.hive_growth_period_s = builder.translation("anthillinside.config.hive_growth_period_s").comment("Sets how long it takes (seconds, in average) to generate one new ant in a hive.").defineInRange("hive_growth_period_s", 120, 60, 600);
            this.hive_animal_feeding_speed_percent = builder.translation("anthillinside.config.hive_animal_feeding_speed_percent").comment("Tunes the internal delay between animals are fed. The value 0 disables animal feeding.").defineInRange("hive_animal_feeding_speed_percent", 100, 0, 150);
            this.hive_farming_speed_percent = builder.translation("anthillinside.config.hive_farming_speed_percent").comment("Tunes the internal delay between harvesting crops. The value 0 disables harvesting.").defineInRange("hive_farming_speed_percent", 100, 0, 150);
            builder.pop();
            builder.pop().comment("Settings where you can explicitly define which tools or other control items the Hive knows.").push("hive_control_items");
            this.crafting_tables = builder.translation("anthillinside.config.crafting_tables").comment("Items that can be placed into the Hive control slot to activate ~normal crafting~.").define("crafting_tables", new ArrayList<String>(List.of("minecraft:crafting_table")));
            this.furnaces = builder.translation("anthillinside.config.furnaces").comment("Items that can be placed into the Hive control slot to activate ~smelting or cooking~.").define("furnaces", new ArrayList<String>(List.of("minecraft:furnace")));
            this.blast_furnaces = builder.translation("anthillinside.config.blast_furnaces").comment("Items that can be placed into the Hive control slot to activate ~fast smelting~.").define("blast_furnaces", new ArrayList<String>(List.of("minecraft:blast_furnace")));
            this.smokers = builder.translation("anthillinside.config.smokers").comment("Items that can be placed into the Hive control slot to activate ~fast cooking~.").define("smokers", new ArrayList<String>(List.of("minecraft:smoker")));
            this.composters = builder.translation("anthillinside.config.composters").comment("Items that can be placed into the Hive control slot to activate ~composting~.").define("composters", new ArrayList<String>(List.of("minecraft:composter")));
            this.brewing_stands = builder.translation("anthillinside.config.brewing_stands").comment("Items that can be placed into the Hive control slot to activate ~potion brewing~.").define("brewing_stands", new ArrayList<String>(List.of("minecraft:brewing_stand")));
            this.grindstones = builder.translation("anthillinside.config.grindstones").comment("Items that can be placed into the Hive control slot to activate ~disenchanting~.").define("grindstones", new ArrayList<String>(List.of("minecraft:grindstone")));
            this.hoppers = builder.translation("anthillinside.config.hoppers").comment("Items that can be placed into Hive slots to activate ~item pass through (control slot), item input drawing, and item output inserting~.").define("hoppers", new ArrayList<String>(List.of("minecraft:hopper")));
            this.droppers = builder.translation("anthillinside.config.droppers").comment("Items that can be placed into the Hive output slot to activate ~item drop output (soft eject)~.").define("droppers", new ArrayList<String>(List.of("minecraft:dropper")));
            this.dispensers = builder.translation("anthillinside.config.dispensers").comment("Items that can be placed into the Hive output slot to activate ~item dispense output (fast eject)~.").define("dispensers", new ArrayList<String>(List.of("minecraft:dispenser")));
            this.shears = builder.translation("anthillinside.config.shears").comment("Items that can be placed into the Hive control slot to activate ~animal or plant shearing~.").define("shears", new ArrayList<String>(List.of("minecraft:shears")));
            this.hoes = builder.translation("anthillinside.config.hoes").comment("Items that can be placed into the Hive control slot to activate ~farmning~.").define("hoes", new ArrayList<String>(List.of("minecraft:iron_hoe", "minecraft:diamond_hoe", "minecraft:netherite_hoe")));
            this.axes = builder.translation("anthillinside.config.axes").comment("Items that can be placed into the Hive control slot to activate ~tree chopping~.").define("axes", new ArrayList<String>(List.of("minecraft:iron_axe", "minecraft:diamond_axe", "minecraft:netherite_axe")));
            this.pickaxes = builder.translation("anthillinside.config.pickaxes").comment("Items that can be placed into the Hive control slot to activate ~block breaking~.").define("pickaxes", new ArrayList<String>(List.of("minecraft:iron_pickaxe", "minecraft:diamond_pickaxe", "minecraft:netherite_pickaxe")));
            builder.pop();
        }
    }
}

